/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfile;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAuthenticationProfilesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeAuthenticationProfilesResponse> {
    private static final SdkField<List<AuthenticationProfile>> AUTHENTICATION_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthenticationProfiles").getter(DescribeAuthenticationProfilesResponse.getter(DescribeAuthenticationProfilesResponse::authenticationProfiles)).setter(DescribeAuthenticationProfilesResponse.setter(Builder::authenticationProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthenticationProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_PROFILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAuthenticationProfilesResponse.memberNameToFieldInitializer();
    private final List<AuthenticationProfile> authenticationProfiles;

    private DescribeAuthenticationProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationProfiles = builder.authenticationProfiles;
    }

    public final boolean hasAuthenticationProfiles() {
        return this.authenticationProfiles != null && !(this.authenticationProfiles instanceof SdkAutoConstructList);
    }

    public final List<AuthenticationProfile> authenticationProfiles() {
        return this.authenticationProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationProfiles() ? this.authenticationProfiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAuthenticationProfilesResponse)) {
            return false;
        }
        DescribeAuthenticationProfilesResponse other = (DescribeAuthenticationProfilesResponse)((Object)obj);
        return this.hasAuthenticationProfiles() == other.hasAuthenticationProfiles() && Objects.equals(this.authenticationProfiles(), other.authenticationProfiles());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAuthenticationProfilesResponse").add("AuthenticationProfiles", this.hasAuthenticationProfiles() ? this.authenticationProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationProfiles": {
                return Optional.ofNullable(clazz.cast(this.authenticationProfiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AuthenticationProfile>>> map = new HashMap<String, SdkField<List<AuthenticationProfile>>>();
        map.put("AuthenticationProfiles", AUTHENTICATION_PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAuthenticationProfilesResponse, T> g) {
        return obj -> g.apply((DescribeAuthenticationProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<AuthenticationProfile> authenticationProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAuthenticationProfilesResponse model) {
            super(model);
            this.authenticationProfiles(model.authenticationProfiles);
        }

        public final List<AuthenticationProfile.Builder> getAuthenticationProfiles() {
            List<AuthenticationProfile.Builder> result = AuthenticationProfileListCopier.copyToBuilder(this.authenticationProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationProfiles(Collection<AuthenticationProfile.BuilderImpl> authenticationProfiles) {
            this.authenticationProfiles = AuthenticationProfileListCopier.copyFromBuilder(authenticationProfiles);
        }

        @Override
        public final Builder authenticationProfiles(Collection<AuthenticationProfile> authenticationProfiles) {
            this.authenticationProfiles = AuthenticationProfileListCopier.copy(authenticationProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfiles(AuthenticationProfile ... authenticationProfiles) {
            this.authenticationProfiles(Arrays.asList(authenticationProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationProfiles(Consumer<AuthenticationProfile.Builder> ... authenticationProfiles) {
            this.authenticationProfiles(Stream.of(authenticationProfiles).map(c -> (AuthenticationProfile)((AuthenticationProfile.Builder)AuthenticationProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAuthenticationProfilesResponse build() {
            return new DescribeAuthenticationProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAuthenticationProfilesResponse> {
        public Builder authenticationProfiles(Collection<AuthenticationProfile> var1);

        public Builder authenticationProfiles(AuthenticationProfile ... var1);

        public Builder authenticationProfiles(Consumer<AuthenticationProfile.Builder> ... var1);
    }
}

