/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIntegrationResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyIntegrationResponse.Builder, ModifyIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(ModifyIntegrationResponse::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationName").getter(getter(ModifyIntegrationResponse::integrationName))
            .setter(setter(Builder::integrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(ModifyIntegrationResponse::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(ModifyIntegrationResponse::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModifyIntegrationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<IntegrationError>> ERRORS_FIELD = SdkField
            .<List<IntegrationError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(ModifyIntegrationResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IntegrationError")
                            .memberFieldInfo(
                                    SdkField.<IntegrationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IntegrationError").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ModifyIntegrationResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ModifyIntegrationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(ModifyIntegrationResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AdditionalEncryptionContext")
            .getter(getter(ModifyIntegrationResponse::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ModifyIntegrationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD,
            INTEGRATION_NAME_FIELD, SOURCE_ARN_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, ERRORS_FIELD, CREATE_TIME_FIELD,
            DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, TAGS_FIELD));

    private final String integrationArn;

    private final String integrationName;

    private final String sourceArn;

    private final String targetArn;

    private final String status;

    private final List<IntegrationError> errors;

    private final Instant createTime;

    private final String description;

    private final String kmsKeyId;

    private final Map<String, String> additionalEncryptionContext;

    private final List<Tag> tags;

    private ModifyIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationArn = builder.integrationArn;
        this.integrationName = builder.integrationName;
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.errors = builder.errors;
        this.createTime = builder.createTime;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the integration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The name of the integration.
     * </p>
     * 
     * @return The name of the integration.
     */
    public final String integrationName() {
        return integrationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the database used as the source for replication.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the database used as the source for replication.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for replication.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for
     *         replication.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The current status of the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZeroETLIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the integration.
     * @see ZeroETLIntegrationStatus
     */
    public final ZeroETLIntegrationStatus status() {
        return ZeroETLIntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the integration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZeroETLIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the integration.
     * @see ZeroETLIntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any errors associated with the integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Any errors associated with the integration.
     */
    public final List<IntegrationError> errors() {
        return errors;
    }

    /**
     * <p>
     * The time (UTC) when the integration was created.
     * </p>
     * 
     * @return The time (UTC) when the integration was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The description of the integration.
     * </p>
     * 
     * @return The description of the integration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
     * </p>
     * 
     * @return The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The encryption context for the integration. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a>
     * in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The encryption context for the integration. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption
     *         context</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags associated with the integration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags associated with the integration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIntegrationResponse)) {
            return false;
        }
        ModifyIntegrationResponse other = (ModifyIntegrationResponse) obj;
        return Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(integrationName(), other.integrationName()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(description(), other.description())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIntegrationResponse").add("IntegrationArn", integrationArn())
                .add("IntegrationName", integrationName()).add("SourceArn", sourceArn()).add("TargetArn", targetArn())
                .add("Status", statusAsString()).add("Errors", hasErrors() ? errors() : null).add("CreateTime", createTime())
                .add("Description", description()).add("KMSKeyId", kmsKeyId())
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "IntegrationName":
            return Optional.ofNullable(clazz.cast(integrationName()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "AdditionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyIntegrationResponse, T> g) {
        return obj -> g.apply((ModifyIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyIntegrationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the integration.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The name of the integration.
         * </p>
         * 
         * @param integrationName
         *        The name of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationName(String integrationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the database used as the source for replication.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the database used as the source for replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for replication.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) of the Amazon Redshift data warehouse to use as the target for
         *        replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The current status of the integration.
         * </p>
         * 
         * @param status
         *        The current status of the integration.
         * @see ZeroETLIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZeroETLIntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the integration.
         * </p>
         * 
         * @param status
         *        The current status of the integration.
         * @see ZeroETLIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZeroETLIntegrationStatus
         */
        Builder status(ZeroETLIntegrationStatus status);

        /**
         * <p>
         * Any errors associated with the integration.
         * </p>
         * 
         * @param errors
         *        Any errors associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<IntegrationError> errors);

        /**
         * <p>
         * Any errors associated with the integration.
         * </p>
         * 
         * @param errors
         *        Any errors associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(IntegrationError... errors);

        /**
         * <p>
         * Any errors associated with the integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.IntegrationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<IntegrationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.IntegrationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<IntegrationError>)
         */
        Builder errors(Consumer<IntegrationError.Builder>... errors);

        /**
         * <p>
         * The time (UTC) when the integration was created.
         * </p>
         * 
         * @param createTime
         *        The time (UTC) when the integration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The description of the integration.
         * </p>
         * 
         * @param description
         *        The description of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service (KMS) key identifier for the key used to encrypt the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The encryption context for the integration. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption
         * context</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The encryption context for the integration. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption
         *        context</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * The list of tags associated with the integration.
         * </p>
         * 
         * @param tags
         *        The list of tags associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags associated with the integration.
         * </p>
         * 
         * @param tags
         *        The list of tags associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags associated with the integration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String integrationArn;

        private String integrationName;

        private String sourceArn;

        private String targetArn;

        private String status;

        private List<IntegrationError> errors = DefaultSdkAutoConstructList.getInstance();

        private Instant createTime;

        private String description;

        private String kmsKeyId;

        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIntegrationResponse model) {
            super(model);
            integrationArn(model.integrationArn);
            integrationName(model.integrationName);
            sourceArn(model.sourceArn);
            targetArn(model.targetArn);
            status(model.status);
            errors(model.errors);
            createTime(model.createTime);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            additionalEncryptionContext(model.additionalEncryptionContext);
            tags(model.tags);
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getIntegrationName() {
            return integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZeroETLIntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<IntegrationError.Builder> getErrors() {
            List<IntegrationError.Builder> result = IntegrationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IntegrationError.BuilderImpl> errors) {
            this.errors = IntegrationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IntegrationError> errors) {
            this.errors = IntegrationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IntegrationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IntegrationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> IntegrationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ModifyIntegrationResponse build() {
            return new ModifyIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
