/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIntegrationsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeIntegrationsRequest.Builder, DescribeIntegrationsRequest> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationArn").getter(getter(DescribeIntegrationsRequest::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeIntegrationsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeIntegrationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DescribeIntegrationsFilter>> FILTERS_FIELD = SdkField
            .<List<DescribeIntegrationsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeIntegrationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DescribeIntegrationsFilter")
                            .memberFieldInfo(
                                    SdkField.<DescribeIntegrationsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeIntegrationsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DescribeIntegrationsFilter").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD, FILTERS_FIELD));

    private final String integrationArn;

    private final Integer maxRecords;

    private final String marker;

    private final List<DescribeIntegrationsFilter> filters;

    private DescribeIntegrationsRequest(BuilderImpl builder) {
        super(builder);
        this.integrationArn = builder.integrationArn;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The unique identifier of the integration.
     * </p>
     * 
     * @return The unique identifier of the integration.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeIntegrations</code> request. If this parameter
     * is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeIntegrations</code> request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies one or more resources to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A filter that specifies one or more resources to return.
     */
    public final List<DescribeIntegrationsFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIntegrationsRequest)) {
            return false;
        }
        DescribeIntegrationsRequest other = (DescribeIntegrationsRequest) obj;
        return Objects.equals(integrationArn(), other.integrationArn()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIntegrationsRequest").add("IntegrationArn", integrationArn())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIntegrationsRequest, T> g) {
        return obj -> g.apply((DescribeIntegrationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeIntegrationsRequest> {
        /**
         * <p>
         * The unique identifier of the integration.
         * </p>
         * 
         * @param integrationArn
         *        The unique identifier of the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeIntegrations</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeIntegrations</code> request. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A filter that specifies one or more resources to return.
         * </p>
         * 
         * @param filters
         *        A filter that specifies one or more resources to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DescribeIntegrationsFilter> filters);

        /**
         * <p>
         * A filter that specifies one or more resources to return.
         * </p>
         * 
         * @param filters
         *        A filter that specifies one or more resources to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DescribeIntegrationsFilter... filters);

        /**
         * <p>
         * A filter that specifies one or more resources to return.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.DescribeIntegrationsFilter.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.DescribeIntegrationsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.DescribeIntegrationsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<DescribeIntegrationsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.DescribeIntegrationsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<DescribeIntegrationsFilter>)
         */
        Builder filters(Consumer<DescribeIntegrationsFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String integrationArn;

        private Integer maxRecords;

        private String marker;

        private List<DescribeIntegrationsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIntegrationsRequest model) {
            super(model);
            integrationArn(model.integrationArn);
            maxRecords(model.maxRecords);
            marker(model.marker);
            filters(model.filters);
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DescribeIntegrationsFilter.Builder> getFilters() {
            List<DescribeIntegrationsFilter.Builder> result = DescribeIntegrationsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DescribeIntegrationsFilter.BuilderImpl> filters) {
            this.filters = DescribeIntegrationsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DescribeIntegrationsFilter> filters) {
            this.filters = DescribeIntegrationsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DescribeIntegrationsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DescribeIntegrationsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DescribeIntegrationsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIntegrationsRequest build() {
            return new DescribeIntegrationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
