/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AuthorizedTokenIssuerListCopier {
    static List<AuthorizedTokenIssuer> copy(Collection<? extends AuthorizedTokenIssuer> authorizedTokenIssuerListParam) {
        List<AuthorizedTokenIssuer> list;
        if (authorizedTokenIssuerListParam == null || authorizedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AuthorizedTokenIssuer> modifiableList = new ArrayList<>(authorizedTokenIssuerListParam.size());
            authorizedTokenIssuerListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AuthorizedTokenIssuer> copyFromBuilder(
            Collection<? extends AuthorizedTokenIssuer.Builder> authorizedTokenIssuerListParam) {
        List<AuthorizedTokenIssuer> list;
        if (authorizedTokenIssuerListParam == null || authorizedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AuthorizedTokenIssuer> modifiableList = new ArrayList<>(authorizedTokenIssuerListParam.size());
            authorizedTokenIssuerListParam.forEach(entry -> {
                AuthorizedTokenIssuer member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AuthorizedTokenIssuer.Builder> copyToBuilder(
            Collection<? extends AuthorizedTokenIssuer> authorizedTokenIssuerListParam) {
        List<AuthorizedTokenIssuer.Builder> list;
        if (authorizedTokenIssuerListParam == null || authorizedTokenIssuerListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AuthorizedTokenIssuer.Builder> modifiableList = new ArrayList<>(authorizedTokenIssuerListParam.size());
            authorizedTokenIssuerListParam.forEach(entry -> {
                AuthorizedTokenIssuer.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
