/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.redshift.internal.RedshiftServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AccessToClusterDeniedException;
import software.amazon.awssdk.services.redshift.model.AccessToSnapshotDeniedException;
import software.amazon.awssdk.services.redshift.model.AddPartnerRequest;
import software.amazon.awssdk.services.redshift.model.AddPartnerResponse;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthenticationProfileQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteRequestSizeExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsLimitExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BucketNotFoundException;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterOnLatestRevisionException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ConflictPolicyUpdateException;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CopyToRegionDisabledException;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.CreateRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.CreateRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.CustomCnameAssociationException;
import software.amazon.awssdk.services.redshift.model.CustomDomainAssociationNotFoundException;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.DeletePartnerRequest;
import software.amazon.awssdk.services.redshift.model.DeletePartnerResponse;
import software.amazon.awssdk.services.redshift.model.DeleteRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DependentServiceAccessDeniedException;
import software.amazon.awssdk.services.redshift.model.DependentServiceRequestThrottlingException;
import software.amazon.awssdk.services.redshift.model.DependentServiceUnavailableException;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribePartnersRequest;
import software.amazon.awssdk.services.redshift.model.DescribePartnersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorizationsPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EndpointNotFoundException;
import software.amazon.awssdk.services.redshift.model.EndpointsPerAuthorizationLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EndpointsPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeRequest;
import software.amazon.awssdk.services.redshift.model.FailoverPrimaryComputeResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.InProgressTableRestoreQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IncompatibleOrderableOptionsException;
import software.amazon.awssdk.services.redshift.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.redshift.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.redshift.model.IntegrationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.IntegrationConflictOperationException;
import software.amazon.awssdk.services.redshift.model.IntegrationConflictStateException;
import software.amazon.awssdk.services.redshift.model.IntegrationNotFoundException;
import software.amazon.awssdk.services.redshift.model.IntegrationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IntegrationSourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.IntegrationTargetNotFoundException;
import software.amazon.awssdk.services.redshift.model.InvalidAuthenticationProfileRequestException;
import software.amazon.awssdk.services.redshift.model.InvalidAuthorizationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterParameterGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSecurityGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotScheduleStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterTrackException;
import software.amazon.awssdk.services.redshift.model.InvalidDataShareException;
import software.amazon.awssdk.services.redshift.model.InvalidElasticIpException;
import software.amazon.awssdk.services.redshift.model.InvalidEndpointStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmClientCertificateStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmConfigurationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidNamespaceException;
import software.amazon.awssdk.services.redshift.model.InvalidPolicyException;
import software.amazon.awssdk.services.redshift.model.InvalidReservedNodeStateException;
import software.amazon.awssdk.services.redshift.model.InvalidRestoreException;
import software.amazon.awssdk.services.redshift.model.InvalidRetentionPeriodException;
import software.amazon.awssdk.services.redshift.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.redshift.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduleException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduledActionException;
import software.amazon.awssdk.services.redshift.model.InvalidSnapshotCopyGrantStateException;
import software.amazon.awssdk.services.redshift.model.InvalidSubnetException;
import software.amazon.awssdk.services.redshift.model.InvalidSubscriptionStateException;
import software.amazon.awssdk.services.redshift.model.InvalidTableRestoreArgumentException;
import software.amazon.awssdk.services.redshift.model.InvalidTagException;
import software.amazon.awssdk.services.redshift.model.InvalidUsageLimitException;
import software.amazon.awssdk.services.redshift.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.redshift.model.Ipv6CidrBlockNotFoundException;
import software.amazon.awssdk.services.redshift.model.LimitExceededException;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyRedshiftIdcApplicationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyRedshiftIdcApplicationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.PartnerNotFoundException;
import software.amazon.awssdk.services.redshift.model.PauseClusterRequest;
import software.amazon.awssdk.services.redshift.model.PauseClusterResponse;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.redshift.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationNotExistsException;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplicationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.RejectDataShareRequest;
import software.amazon.awssdk.services.redshift.model.RejectDataShareResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyMigratedException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.ResizeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ResumeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResumeClusterResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionNotFoundException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyEnabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleUpdateInProgressException;
import software.amazon.awssdk.services.redshift.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.redshift.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.redshift.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.redshift.model.SourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.redshift.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.redshift.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionEventIdNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionSeverityNotFoundException;
import software.amazon.awssdk.services.redshift.model.TableLimitExceededException;
import software.amazon.awssdk.services.redshift.model.TableRestoreNotFoundException;
import software.amazon.awssdk.services.redshift.model.TagLimitExceededException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedPartnerIntegrationException;
import software.amazon.awssdk.services.redshift.model.UnknownSnapshotCopyRegionException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOperationException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOptionException;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse;
import software.amazon.awssdk.services.redshift.model.UsageLimitAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.UsageLimitNotFoundException;
import software.amazon.awssdk.services.redshift.transform.AcceptReservedNodeExchangeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AddPartnerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AssociateDataShareConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.AuthorizeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchDeleteClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.BatchModifyClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CancelResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CopyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.CreateUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeauthorizeDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmClientCertificateRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteHsmConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeletePartnerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotCopyGrantRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DeleteUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeAuthenticationProfilesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterDbRevisionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterTracksRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClusterVersionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeCustomDomainAssociationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesForConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesForProducerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDataSharesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEndpointAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmClientCertificatesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeHsmConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeInboundIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeLoggingStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeNodeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeOrderableClusterOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribePartnersRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeRedshiftIdcApplicationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeExchangeStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeReservedNodesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeResizeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeScheduledActionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotCopyGrantsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeSnapshotSchedulesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeStorageRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTableRestoreStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DescribeUsageLimitsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.DisassociateDataShareConsumerRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableLoggingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.EnableSnapshotCopyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.FailoverPrimaryComputeRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetClusterCredentialsWithIamRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeConfigurationOptionsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetReservedNodeExchangeOfferingsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyAquaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterDbRevisionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterIamRolesRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyClusterSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyCustomDomainAssociationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyIntegrationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyRedshiftIdcApplicationRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyScheduledActionRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotCopyRetentionPeriodRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifySnapshotScheduleRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ModifyUsageLimitRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PauseClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PurchaseReservedNodeOfferingRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RebootClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RejectDataShareRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResetClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResizeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RestoreTableFromClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.ResumeClusterRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeClusterSecurityGroupIngressRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RevokeSnapshotAccessRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.RotateEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.redshift.transform.UpdatePartnerStatusRequestMarshaller;
import software.amazon.awssdk.services.redshift.waiters.RedshiftAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link RedshiftAsyncClient}.
 *
 * @see RedshiftAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRedshiftAsyncClient implements RedshiftAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedshiftAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final AsyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultRedshiftAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type,
     * or number of nodes) and no additional costs.
     * </p>
     *
     * @param acceptReservedNodeExchangeRequest
     * @return A Java Future containing the result of the AcceptReservedNodeExchange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AcceptReservedNodeExchange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptReservedNodeExchangeResponse> acceptReservedNodeExchange(
            AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptReservedNodeExchangeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptReservedNodeExchangeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptReservedNodeExchange");

            HttpResponseHandler<AcceptReservedNodeExchangeResponse> responseHandler = protocolFactory
                    .createResponseHandler(AcceptReservedNodeExchangeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AcceptReservedNodeExchangeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptReservedNodeExchangeRequest, AcceptReservedNodeExchangeResponse>()
                            .withOperationName("AcceptReservedNodeExchange").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptReservedNodeExchangeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptReservedNodeExchangeRequest));
            CompletableFuture<AcceptReservedNodeExchangeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the
     * specified database. To complete the integration, you also set up the integration on the partner website.
     * </p>
     *
     * @param addPartnerRequest
     * @return A Java Future containing the result of the AddPartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AddPartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AddPartner" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddPartnerResponse> addPartner(AddPartnerRequest addPartnerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addPartnerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addPartnerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddPartner");

            HttpResponseHandler<AddPartnerResponse> responseHandler = protocolFactory
                    .createResponseHandler(AddPartnerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AddPartnerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddPartnerRequest, AddPartnerResponse>().withOperationName("AddPartner")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddPartnerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addPartnerRequest));
            CompletableFuture<AddPartnerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the
     * specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     * </p>
     *
     * @param associateDataShareConsumerRequest
     * @return A Java Future containing the result of the AssociateDataShareConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AssociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AssociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDataShareConsumerResponse> associateDataShareConsumer(
            AssociateDataShareConsumerRequest associateDataShareConsumerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDataShareConsumerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDataShareConsumerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDataShareConsumer");

            HttpResponseHandler<AssociateDataShareConsumerResponse> responseHandler = protocolFactory
                    .createResponseHandler(AssociateDataShareConsumerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AssociateDataShareConsumerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDataShareConsumerRequest, AssociateDataShareConsumerResponse>()
                            .withOperationName("AssociateDataShareConsumer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateDataShareConsumerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateDataShareConsumerRequest));
            CompletableFuture<AssociateDataShareConsumerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application
     * accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to
     * either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group.
     * You can add as many as 20 ingress rules to an Amazon Redshift security group.
     * </p>
     * <p>
     * If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and
     * <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same
     * Amazon Web Services Region.
     * </p>
     * <p>
     * If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see
     * the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
     * Inter-Domain Routing</a>.
     * </p>
     * <p>
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the
     * EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
     * Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeClusterSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeClusterSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeClusterSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> authorizeClusterSecurityGroupIngress(
            AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeClusterSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                authorizeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeClusterSecurityGroupIngress");

            HttpResponseHandler<AuthorizeClusterSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeClusterSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeClusterSecurityGroupIngressRequest, AuthorizeClusterSecurityGroupIngressResponse>()
                            .withOperationName("AuthorizeClusterSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeClusterSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeClusterSecurityGroupIngressRequest));
            CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or
     * managing entities. To authorize a datashare for a data consumer, the producer account must have the correct
     * access permissions.
     * </p>
     *
     * @param authorizeDataShareRequest
     * @return A Java Future containing the result of the AuthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeDataShareResponse> authorizeDataShare(AuthorizeDataShareRequest authorizeDataShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeDataShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeDataShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeDataShare");

            HttpResponseHandler<AuthorizeDataShareResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeDataShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeDataShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeDataShareRequest, AuthorizeDataShareResponse>()
                            .withOperationName("AuthorizeDataShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeDataShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeDataShareRequest));
            CompletableFuture<AuthorizeDataShareResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants access to a cluster.
     * </p>
     *
     * @param authorizeEndpointAccessRequest
     * @return A Java Future containing the result of the AuthorizeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>EndpointAuthorizationsPerClusterLimitExceededException The number of endpoint authorizations per
     *         cluster has exceeded its limit.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>EndpointAuthorizationAlreadyExistsException The authorization already exists for this endpoint.</li>
     *         <li>InvalidAuthorizationStateException The status of the authorization is not valid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeEndpointAccessResponse> authorizeEndpointAccess(
            AuthorizeEndpointAccessRequest authorizeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeEndpointAccess");

            HttpResponseHandler<AuthorizeEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeEndpointAccessRequest, AuthorizeEndpointAccessResponse>()
                            .withOperationName("AuthorizeEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeEndpointAccessRequest));
            CompletableFuture<AuthorizeEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeSnapshotAccessRequest
     * @return A Java Future containing the result of the AuthorizeSnapshotAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeSnapshotAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AuthorizeSnapshotAccessResponse> authorizeSnapshotAccess(
            AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeSnapshotAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeSnapshotAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeSnapshotAccess");

            HttpResponseHandler<AuthorizeSnapshotAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(AuthorizeSnapshotAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<AuthorizeSnapshotAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeSnapshotAccessRequest, AuthorizeSnapshotAccessResponse>()
                            .withOperationName("AuthorizeSnapshotAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AuthorizeSnapshotAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeSnapshotAccessRequest));
            CompletableFuture<AuthorizeSnapshotAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a set of cluster snapshots.
     * </p>
     *
     * @param batchDeleteClusterSnapshotsRequest
     * @return A Java Future containing the result of the BatchDeleteClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BatchDeleteRequestSizeExceededException The maximum number for a batch delete of snapshots has been
     *         reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchDeleteClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteClusterSnapshotsResponse> batchDeleteClusterSnapshots(
            BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteClusterSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteClusterSnapshots");

            HttpResponseHandler<BatchDeleteClusterSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchDeleteClusterSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BatchDeleteClusterSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteClusterSnapshotsRequest, BatchDeleteClusterSnapshotsResponse>()
                            .withOperationName("BatchDeleteClusterSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteClusterSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteClusterSnapshotsRequest));
            CompletableFuture<BatchDeleteClusterSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a set of cluster snapshots.
     * </p>
     *
     * @param batchModifyClusterSnapshotsRequest
     * @return A Java Future containing the result of the BatchModifyClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>BatchModifyClusterSnapshotsLimitExceededException The maximum number for snapshot identifiers has
     *         been reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchModifyClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchModifyClusterSnapshotsResponse> batchModifyClusterSnapshots(
            BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchModifyClusterSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchModifyClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchModifyClusterSnapshots");

            HttpResponseHandler<BatchModifyClusterSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(BatchModifyClusterSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<BatchModifyClusterSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchModifyClusterSnapshotsRequest, BatchModifyClusterSnapshotsResponse>()
                            .withOperationName("BatchModifyClusterSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchModifyClusterSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchModifyClusterSnapshotsRequest));
            CompletableFuture<BatchModifyClusterSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a resize operation for a cluster.
     * </p>
     *
     * @param cancelResizeRequest
     * @return A Java Future containing the result of the CancelResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CancelResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelResizeResponse> cancelResize(CancelResizeRequest cancelResizeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelResizeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelResizeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelResize");

            HttpResponseHandler<CancelResizeResponse> responseHandler = protocolFactory
                    .createResponseHandler(CancelResizeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CancelResizeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelResizeRequest, CancelResizeResponse>()
                            .withOperationName("CancelResize").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelResizeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelResizeRequest));
            CompletableFuture<CancelResizeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated
     * snapshot and it must be in the available state.
     * </p>
     * <p>
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
     * retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an
     * automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained
     * until you delete them.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param copyClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(
            CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyClusterSnapshot");

            HttpResponseHandler<CopyClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CopyClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CopyClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyClusterSnapshotRequest, CopyClusterSnapshotResponse>()
                            .withOperationName("CopyClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CopyClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(copyClusterSnapshotRequest));
            CompletableFuture<CopyClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an authentication profile with the specified parameters.
     * </p>
     *
     * @param createAuthenticationProfileRequest
     * @return A Java Future containing the result of the CreateAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationProfileAlreadyExistsException The authentication profile already exists.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAuthenticationProfileResponse> createAuthenticationProfile(
            CreateAuthenticationProfileRequest createAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuthenticationProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthenticationProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthenticationProfile");

            HttpResponseHandler<CreateAuthenticationProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateAuthenticationProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateAuthenticationProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAuthenticationProfileRequest, CreateAuthenticationProfileResponse>()
                            .withOperationName("CreateAuthenticationProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAuthenticationProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAuthenticationProfileRequest));
            CompletableFuture<CreateAuthenticationProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cluster with the specified parameters.
     * </p>
     * <p>
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster
     * subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more
     * information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterQuotaExceededException The request would exceed the allowed number of cluster instances for
     *         this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidVpcNetworkStateException The cluster subnet group does not cover all Availability Zones.</li>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>RedshiftIdcApplicationNotExistsException The application you attempted to find doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCluster");

            HttpResponseHandler<CreateClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterRequest, CreateClusterResponse>()
                            .withOperationName("CreateCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterRequest));
            CompletableFuture<CreateClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift parameter group.
     * </p>
     * <p>
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group
     * when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster
     * is created by using <a>ModifyCluster</a>.
     * </p>
     * <p>
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the
     * cluster. For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterParameterGroupQuotaExceededException The request would result in the user exceeding the
     *         allowed number of cluster parameter groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterParameterGroupAlreadyExistsException A cluster parameter group with the same name already
     *         exists.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterParameterGroupResponse> createClusterParameterGroup(
            CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClusterParameterGroup");

            HttpResponseHandler<CreateClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterParameterGroupRequest, CreateClusterParameterGroupResponse>()
                            .withOperationName("CreateClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterParameterGroupRequest));
            CompletableFuture<CreateClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSecurityGroupRequest
     * @return A Java Future containing the result of the CreateClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSecurityGroupAlreadyExistsException A cluster security group with the same name already
     *         exists.</li>
     *         <li>ClusterSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster security groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterSecurityGroupResponse> createClusterSecurityGroup(
            CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClusterSecurityGroup");

            HttpResponseHandler<CreateClusterSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClusterSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClusterSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterSecurityGroupRequest, CreateClusterSecurityGroupResponse>()
                            .withOperationName("CreateClusterSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterSecurityGroupRequest));
            CompletableFuture<CreateClusterSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(
            CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClusterSnapshot");

            HttpResponseHandler<CreateClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterSnapshotRequest, CreateClusterSnapshotResponse>()
                            .withOperationName("CreateClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterSnapshotRequest));
            CompletableFuture<CreateClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing
     * Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     * </p>
     * <p>
     * For information about subnet groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift
     * Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSubnetGroupRequest
     * @return A Java Future containing the result of the CreateClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSubnetGroupAlreadyExistsException A <i>ClusterSubnetGroupName</i> is already used by an
     *         existing cluster subnet group.</li>
     *         <li>ClusterSubnetGroupQuotaExceededException The request would result in user exceeding the allowed
     *         number of cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterSubnetGroupResponse> createClusterSubnetGroup(
            CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClusterSubnetGroup");

            HttpResponseHandler<CreateClusterSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateClusterSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateClusterSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterSubnetGroupRequest, CreateClusterSubnetGroupResponse>()
                            .withOperationName("CreateClusterSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterSubnetGroupRequest));
            CompletableFuture<CreateClusterSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Used to create a custom domain name for a cluster. Properties include the custom domain name, the cluster the
     * custom domain is associated with, and the certificate Amazon Resource Name (ARN).
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomDomainAssociation");

            HttpResponseHandler<CreateCustomDomainAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateCustomDomainAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDomainAssociationRequest, CreateCustomDomainAssociationResponse>()
                            .withOperationName("CreateCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCustomDomainAssociationRequest));
            CompletableFuture<CreateCustomDomainAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToClusterDeniedException You are not authorized to access the cluster.</li>
     *         <li>EndpointsPerClusterLimitExceededException The number of Redshift-managed VPC endpoints per cluster
     *         has exceeded its limit.</li>
     *         <li>EndpointsPerAuthorizationLimitExceededException The number of Redshift-managed VPC endpoints per
     *         authorization has exceeded its limit.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>EndpointAlreadyExistsException The account already has a Redshift-managed VPC endpoint with the given
     *         identifier.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            CreateEndpointAccessRequest createEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointAccess");

            HttpResponseHandler<CreateEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointAccessRequest, CreateEndpointAccessResponse>()
                            .withOperationName("CreateEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEndpointAccessRequest));
            CompletableFuture<CreateEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of
     * an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API.
     * To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is
     * displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities.
     * Notifications will be sent for all events you want that match those criteria. For example, you can specify source
     * type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
     * ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup
     * categories for the specified clusters.
     * </p>
     * <p>
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier =
     * my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source
     * type but do not specify a source identifier, you will receive notice of the events for the objects of that type
     * in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you
     * will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services
     * account. You must specify a source type if you specify a source ID.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException The request would exceed the allowed number of event
     *         subscriptions for this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubscriptionAlreadyExistException There is already an existing event notification subscription with
     *         the specified name.</li>
     *         <li>SnsInvalidTopicException Amazon SNS has responded that there is a problem with the specified Amazon
     *         SNS topic.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the specified Amazon SNS topic.</li>
     *         <li>SnsTopicArnNotFoundException An Amazon SNS topic with the specified Amazon Resource Name (ARN) does
     *         not exist.</li>
     *         <li>SubscriptionEventIdNotFoundException An Amazon Redshift event with the specified event ID does not
     *         exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The value specified for the event category was not one of the
     *         allowed values, or it specified a category that does not apply to the specified source type. The allowed
     *         values are Configuration, Management, Monitoring, and Security.</li>
     *         <li>SubscriptionSeverityNotFoundException The value specified for the event severity was not one of the
     *         allowed values, or it specified a severity that does not apply to the specified source type. The allowed
     *         values are ERROR and INFO.</li>
     *         <li>SourceNotFoundException The specified Amazon Redshift event source could not be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");

            HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventSubscriptionRequest));
            CompletableFuture<CreateEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in
     * order to store and retrieve the keys used to encrypt the cluster databases.
     * </p>
     * <p>
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate,
     * you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and
     * use encryption keys in the HSM. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware
     * Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createHsmClientCertificateRequest
     * @return A Java Future containing the result of the CreateHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HsmClientCertificateAlreadyExistsException There is already an existing Amazon Redshift HSM client
     *         certificate with the specified identifier.</li>
     *         <li>HsmClientCertificateQuotaExceededException The quota for HSM client certificates has been reached.
     *         For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHsmClientCertificateResponse> createHsmClientCertificate(
            CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHsmClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHsmClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHsmClientCertificate");

            HttpResponseHandler<CreateHsmClientCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateHsmClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateHsmClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHsmClientCertificateRequest, CreateHsmClientCertificateResponse>()
                            .withOperationName("CreateHsmClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHsmClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHsmClientCertificateRequest));
            CompletableFuture<CreateHsmClientCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and
     * use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can
     * specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     * </p>
     * <p>
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more
     * information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware
     * Security Modules</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param createHsmConfigurationRequest
     * @return A Java Future containing the result of the CreateHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HsmConfigurationAlreadyExistsException There is already an existing Amazon Redshift HSM configuration
     *         with the specified identifier.</li>
     *         <li>HsmConfigurationQuotaExceededException The quota for HSM configurations has been reached. For
     *         information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHsmConfigurationResponse> createHsmConfiguration(
            CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHsmConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHsmConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHsmConfiguration");

            HttpResponseHandler<CreateHsmConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateHsmConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateHsmConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHsmConfigurationRequest, CreateHsmConfigurationResponse>()
                            .withOperationName("CreateHsmConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHsmConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHsmConfigurationRequest));
            CompletableFuture<CreateHsmConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a zero-ETL integration or S3 event integration with Amazon Redshift.
     * </p>
     *
     * @param createIntegrationRequest
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationAlreadyExistsException The integration you are trying to create already exists.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. This typically occurs when there are multiple requests being made to the same
     *         resource at the same time, and these requests conflict with each other.</li>
     *         <li>IntegrationQuotaExceededException You can't create any more zero-ETL or S3 event integrations because
     *         the quota has been reached.</li>
     *         <li>IntegrationSourceNotFoundException The specified integration source can't be found.</li>
     *         <li>IntegrationTargetNotFoundException The specified integration target can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateIntegration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIntegrationResponse> createIntegration(CreateIntegrationRequest createIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegration");

            HttpResponseHandler<CreateIntegrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIntegrationRequest, CreateIntegrationResponse>()
                            .withOperationName("CreateIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIntegrationRequest));
            CompletableFuture<CreateIntegrationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Redshift application for use with IAM Identity Center.
     * </p>
     *
     * @param createRedshiftIdcApplicationRequest
     * @return A Java Future containing the result of the CreateRedshiftIdcApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RedshiftIdcApplicationAlreadyExistsException The application you attempted to add already exists.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceAccessDeniedException A dependent service denied access for the integration.</li>
     *         <li>RedshiftIdcApplicationQuotaExceededException The maximum number of Redshift IAM Identity Center
     *         applications was exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateRedshiftIdcApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateRedshiftIdcApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRedshiftIdcApplicationResponse> createRedshiftIdcApplication(
            CreateRedshiftIdcApplicationRequest createRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRedshiftIdcApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRedshiftIdcApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRedshiftIdcApplication");

            HttpResponseHandler<CreateRedshiftIdcApplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateRedshiftIdcApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateRedshiftIdcApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRedshiftIdcApplicationRequest, CreateRedshiftIdcApplicationResponse>()
                            .withOperationName("CreateRedshiftIdcApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRedshiftIdcApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRedshiftIdcApplicationRequest));
            CompletableFuture<CreateRedshiftIdcApplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
     * </p>
     *
     * @param createScheduledActionRequest
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ScheduledActionAlreadyExistsException The scheduled action already exists.</li>
     *         <li>ScheduledActionQuotaExceededException The quota for scheduled actions exceeded.</li>
     *         <li>ScheduledActionTypeUnsupportedException The action type specified for a scheduled action is not
     *         supported.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>InvalidScheduledActionException The scheduled action is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            CreateScheduledActionRequest createScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScheduledAction");

            HttpResponseHandler<CreateScheduledActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateScheduledActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateScheduledActionRequest, CreateScheduledActionResponse>()
                            .withOperationName("CreateScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createScheduledActionRequest));
            CompletableFuture<CreateScheduledActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management
     * Service (KMS) to encrypt copied snapshots in a destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createSnapshotCopyGrantRequest
     *        The result of the <code>CreateSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the CreateSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SnapshotCopyGrantAlreadyExistsException The snapshot copy grant can't be created because a grant with
     *         the same name already exists.</li>
     *         <li>SnapshotCopyGrantQuotaExceededException The Amazon Web Services account has exceeded the maximum
     *         number of snapshot copy grants in this region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotCopyGrantResponse> createSnapshotCopyGrant(
            CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotCopyGrantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotCopyGrantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshotCopyGrant");

            HttpResponseHandler<CreateSnapshotCopyGrantResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotCopyGrantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotCopyGrantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotCopyGrantRequest, CreateSnapshotCopyGrantResponse>()
                            .withOperationName("CreateSnapshotCopyGrant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotCopyGrantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotCopyGrantRequest));
            CompletableFuture<CreateSnapshotCopyGrantResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup
     * schedule.
     * </p>
     *
     * @param createSnapshotScheduleRequest
     * @return A Java Future containing the result of the CreateSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SnapshotScheduleAlreadyExistsException The specified snapshot schedule already exists.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>SnapshotScheduleQuotaExceededException You have exceeded the quota of snapshot schedules.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ScheduleDefinitionTypeUnsupportedException The definition you submitted is not supported.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotScheduleResponse> createSnapshotSchedule(
            CreateSnapshotScheduleRequest createSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshotSchedule");

            HttpResponseHandler<CreateSnapshotScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotScheduleRequest, CreateSnapshotScheduleResponse>()
                            .withOperationName("CreateSnapshotSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotScheduleRequest));
            CompletableFuture<CreateSnapshotScheduleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to a cluster.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an
     * error and the attempt will fail.
     * </p>
     * <p>
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new
     * value.
     * </p>
     *
     * @param createTagsRequest
     *        Contains the output from the <code>CreateTags</code> action.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>().withOperationName("CreateTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTagsRequest));
            CompletableFuture<CreateTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UsageLimitAlreadyExistsException The usage limit already exists.</li>
     *         <li>InvalidUsageLimitException The usage limit is not valid.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUsageLimit");

            HttpResponseHandler<CreateUsageLimitResponse> responseHandler = protocolFactory
                    .createResponseHandler(CreateUsageLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<CreateUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUsageLimitRequest, CreateUsageLimitResponse>()
                            .withOperationName("CreateUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUsageLimitRequest));
            CompletableFuture<CreateUsageLimitResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * From a datashare producer account, removes authorization from the specified datashare.
     * </p>
     *
     * @param deauthorizeDataShareRequest
     * @return A Java Future containing the result of the DeauthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeauthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeauthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeauthorizeDataShareResponse> deauthorizeDataShare(
            DeauthorizeDataShareRequest deauthorizeDataShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deauthorizeDataShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deauthorizeDataShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeauthorizeDataShare");

            HttpResponseHandler<DeauthorizeDataShareResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeauthorizeDataShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeauthorizeDataShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeauthorizeDataShareRequest, DeauthorizeDataShareResponse>()
                            .withOperationName("DeauthorizeDataShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeauthorizeDataShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deauthorizeDataShareRequest));
            CompletableFuture<DeauthorizeDataShareResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an authentication profile.
     * </p>
     *
     * @param deleteAuthenticationProfileRequest
     * @return A Java Future containing the result of the DeleteAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAuthenticationProfileResponse> deleteAuthenticationProfile(
            DeleteAuthenticationProfileRequest deleteAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuthenticationProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthenticationProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthenticationProfile");

            HttpResponseHandler<DeleteAuthenticationProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteAuthenticationProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteAuthenticationProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAuthenticationProfileRequest, DeleteAuthenticationProfileResponse>()
                            .withOperationName("DeleteAuthenticationProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAuthenticationProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAuthenticationProfileRequest));
            CompletableFuture<DeleteAuthenticationProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the
     * web service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status
     * of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about
     * managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to
     * <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
     * snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be
     * "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the
     * cluster.
     * </p>
     * <p>
     * For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCluster");

            HttpResponseHandler<DeleteClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterRequest, DeleteClusterResponse>()
                            .withOperationName("DeleteCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterRequest));
            CompletableFuture<DeleteClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified Amazon Redshift parameter group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a parameter group if it is associated with a cluster.
     * </p>
     * </note>
     *
     * @param deleteClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterParameterGroupResponse> deleteClusterParameterGroup(
            DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClusterParameterGroup");

            HttpResponseHandler<DeleteClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterParameterGroupRequest, DeleteClusterParameterGroupResponse>()
                            .withOperationName("DeleteClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterParameterGroupRequest));
            CompletableFuture<DeleteClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Redshift security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security
     * group.
     * </p>
     * </note>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterSecurityGroupResponse> deleteClusterSecurityGroup(
            DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClusterSecurityGroup");

            HttpResponseHandler<DeleteClusterSecurityGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClusterSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClusterSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterSecurityGroupRequest, DeleteClusterSecurityGroupResponse>()
                            .withOperationName("DeleteClusterSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterSecurityGroupRequest));
            CompletableFuture<DeleteClusterSecurityGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other
     * users authorized to access the snapshot.
     * </p>
     * <p>
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift
     * does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If
     * other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can
     * delete the snapshot.
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(
            DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClusterSnapshot");

            HttpResponseHandler<DeleteClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterSnapshotRequest, DeleteClusterSnapshotResponse>()
                            .withOperationName("DeleteClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterSnapshotRequest));
            CompletableFuture<DeleteClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified cluster subnet group.
     * </p>
     *
     * @param deleteClusterSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidClusterSubnetStateException The state of the subnet is invalid.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterSubnetGroupResponse> deleteClusterSubnetGroup(
            DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClusterSubnetGroup");

            HttpResponseHandler<DeleteClusterSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteClusterSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteClusterSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterSubnetGroupRequest, DeleteClusterSubnetGroupResponse>()
                            .withOperationName("DeleteClusterSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterSubnetGroupRequest));
            CompletableFuture<DeleteClusterSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Contains information about deleting a custom domain association for a cluster.
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomDomainAssociation");

            HttpResponseHandler<DeleteCustomDomainAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteCustomDomainAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDomainAssociationRequest, DeleteCustomDomainAssociationResponse>()
                            .withOperationName("DeleteCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCustomDomainAssociationRequest));
            CompletableFuture<DeleteCustomDomainAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointAccess");

            HttpResponseHandler<DeleteEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointAccessRequest, DeleteEndpointAccessResponse>()
                            .withOperationName("DeleteEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEndpointAccessRequest));
            CompletableFuture<DeleteEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Redshift event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidSubscriptionStateException The subscription request is invalid because it is a duplicate
     *         request. This subscription request is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");

            HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventSubscriptionRequest));
            CompletableFuture<DeleteEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified HSM client certificate.
     * </p>
     *
     * @param deleteHsmClientCertificateRequest
     * @return A Java Future containing the result of the DeleteHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidHsmClientCertificateStateException The specified HSM client certificate is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHsmClientCertificateResponse> deleteHsmClientCertificate(
            DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHsmClientCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHsmClientCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHsmClientCertificate");

            HttpResponseHandler<DeleteHsmClientCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteHsmClientCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteHsmClientCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHsmClientCertificateRequest, DeleteHsmClientCertificateResponse>()
                            .withOperationName("DeleteHsmClientCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHsmClientCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHsmClientCertificateRequest));
            CompletableFuture<DeleteHsmClientCertificateResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Amazon Redshift HSM configuration.
     * </p>
     *
     * @param deleteHsmConfigurationRequest
     * @return A Java Future containing the result of the DeleteHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidHsmConfigurationStateException The specified HSM configuration is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHsmConfigurationResponse> deleteHsmConfiguration(
            DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHsmConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHsmConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHsmConfiguration");

            HttpResponseHandler<DeleteHsmConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteHsmConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteHsmConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteHsmConfigurationRequest, DeleteHsmConfigurationResponse>()
                            .withOperationName("DeleteHsmConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteHsmConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteHsmConfigurationRequest));
            CompletableFuture<DeleteHsmConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a zero-ETL integration or S3 event integration with Amazon Redshift.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The integration can't be found.</li>
     *         <li>IntegrationConflictStateException The integration is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. This typically occurs when there are multiple requests being made to the same
     *         resource at the same time, and these requests conflict with each other.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteIntegration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");

            HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                            .withOperationName("DeleteIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIntegrationRequest));
            CompletableFuture<DeleteIntegrationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted
     * at the partner's website.
     * </p>
     *
     * @param deletePartnerRequest
     * @return A Java Future containing the result of the DeletePartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeletePartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeletePartner" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePartnerResponse> deletePartner(DeletePartnerRequest deletePartnerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePartnerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePartnerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePartner");

            HttpResponseHandler<DeletePartnerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeletePartnerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeletePartnerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePartnerRequest, DeletePartnerResponse>()
                            .withOperationName("DeletePartner").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePartnerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePartnerRequest));
            CompletableFuture<DeletePartnerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Redshift IAM Identity Center application.
     * </p>
     *
     * @param deleteRedshiftIdcApplicationRequest
     * @return A Java Future containing the result of the DeleteRedshiftIdcApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RedshiftIdcApplicationNotExistsException The application you attempted to find doesn't exist.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceAccessDeniedException A dependent service denied access for the integration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteRedshiftIdcApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteRedshiftIdcApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRedshiftIdcApplicationResponse> deleteRedshiftIdcApplication(
            DeleteRedshiftIdcApplicationRequest deleteRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRedshiftIdcApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRedshiftIdcApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRedshiftIdcApplication");

            HttpResponseHandler<DeleteRedshiftIdcApplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteRedshiftIdcApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteRedshiftIdcApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRedshiftIdcApplicationRequest, DeleteRedshiftIdcApplicationResponse>()
                            .withOperationName("DeleteRedshiftIdcApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRedshiftIdcApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRedshiftIdcApplicationRequest));
            CompletableFuture<DeleteRedshiftIdcApplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the resource policy for a specified resource.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                            .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourcePolicyRequest));
            CompletableFuture<DeleteResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScheduledAction");

            HttpResponseHandler<DeleteScheduledActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteScheduledActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScheduledActionRequest, DeleteScheduledActionResponse>()
                            .withOperationName("DeleteScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteScheduledActionRequest));
            CompletableFuture<DeleteScheduledActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified snapshot copy grant.
     * </p>
     *
     * @param deleteSnapshotCopyGrantRequest
     *        The result of the <code>DeleteSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the DeleteSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidSnapshotCopyGrantStateException The snapshot copy grant can't be deleted because it is used by
     *         one or more clusters.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotCopyGrantResponse> deleteSnapshotCopyGrant(
            DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotCopyGrantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotCopyGrantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshotCopyGrant");

            HttpResponseHandler<DeleteSnapshotCopyGrantResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSnapshotCopyGrantResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSnapshotCopyGrantResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotCopyGrantRequest, DeleteSnapshotCopyGrantResponse>()
                            .withOperationName("DeleteSnapshotCopyGrant").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotCopyGrantRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotCopyGrantRequest));
            CompletableFuture<DeleteSnapshotCopyGrantResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a snapshot schedule.
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     * @return A Java Future containing the result of the DeleteSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(
            DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshotSchedule");

            HttpResponseHandler<DeleteSnapshotScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotScheduleRequest, DeleteSnapshotScheduleResponse>()
                            .withOperationName("DeleteSnapshotSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotScheduleRequest));
            CompletableFuture<DeleteSnapshotScheduleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or
     * tags.
     * </p>
     *
     * @param deleteTagsRequest
     *        Contains the output from the <code>DeleteTags</code> action.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTagsRequest));
            CompletableFuture<DeleteTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a usage limit from a cluster.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UsageLimitNotFoundException The usage limit identifier can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUsageLimit");

            HttpResponseHandler<DeleteUsageLimitResponse> responseHandler = protocolFactory
                    .createResponseHandler(DeleteUsageLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DeleteUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUsageLimitRequest, DeleteUsageLimitResponse>()
                            .withOperationName("DeleteUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUsageLimitRequest));
            CompletableFuture<DeleteUsageLimitResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");

            HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAccountAttributesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAccountAttributesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountAttributesRequest));
            CompletableFuture<DescribeAccountAttributesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an authentication profile.
     * </p>
     *
     * @param describeAuthenticationProfilesRequest
     * @return A Java Future containing the result of the DescribeAuthenticationProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAuthenticationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAuthenticationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAuthenticationProfilesResponse> describeAuthenticationProfiles(
            DescribeAuthenticationProfilesRequest describeAuthenticationProfilesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuthenticationProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAuthenticationProfilesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuthenticationProfiles");

            HttpResponseHandler<DescribeAuthenticationProfilesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeAuthenticationProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeAuthenticationProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAuthenticationProfilesRequest, DescribeAuthenticationProfilesResponse>()
                            .withOperationName("DescribeAuthenticationProfiles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAuthenticationProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAuthenticationProfilesRequest));
            CompletableFuture<DescribeAuthenticationProfilesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     * @return A Java Future containing the result of the DescribeClusterDbRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions(
            DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterDbRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterDbRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterDbRevisions");

            HttpResponseHandler<DescribeClusterDbRevisionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterDbRevisionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterDbRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterDbRevisionsRequest, DescribeClusterDbRevisionsResponse>()
                            .withOperationName("DescribeClusterDbRevisions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterDbRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterDbRevisionsRequest));
            CompletableFuture<DescribeClusterDbRevisionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups(
            DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterParameterGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClusterParameterGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterParameterGroups");

            HttpResponseHandler<DescribeClusterParameterGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterParameterGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterParameterGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterParameterGroupsRequest, DescribeClusterParameterGroupsResponse>()
                            .withOperationName("DescribeClusterParameterGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterParameterGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterParameterGroupsRequest));
            CompletableFuture<DescribeClusterParameterGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterParametersRequest
     * @return A Java Future containing the result of the DescribeClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterParametersResponse> describeClusterParameters(
            DescribeClusterParametersRequest describeClusterParametersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterParameters");

            HttpResponseHandler<DescribeClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterParametersRequest, DescribeClusterParametersResponse>()
                            .withOperationName("DescribeClusterParameters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterParametersRequest));
            CompletableFuture<DescribeClusterParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterSecurityGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterSecurityGroupsResponse> describeClusterSecurityGroups(
            DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClusterSecurityGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterSecurityGroups");

            HttpResponseHandler<DescribeClusterSecurityGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterSecurityGroupsRequest, DescribeClusterSecurityGroupsResponse>()
                            .withOperationName("DescribeClusterSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterSecurityGroupsRequest));
            CompletableFuture<DescribeClusterSecurityGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots(
            DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterSnapshots");

            HttpResponseHandler<DescribeClusterSnapshotsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResponse>()
                            .withOperationName("DescribeClusterSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterSnapshotsRequest));
            CompletableFuture<DescribeClusterSnapshotsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups(
            DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterSubnetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterSubnetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterSubnetGroups");

            HttpResponseHandler<DescribeClusterSubnetGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterSubnetGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterSubnetGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterSubnetGroupsRequest, DescribeClusterSubnetGroupsResponse>()
                            .withOperationName("DescribeClusterSubnetGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterSubnetGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterSubnetGroupsRequest));
            CompletableFuture<DescribeClusterSubnetGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     *
     * @param describeClusterTracksRequest
     * @return A Java Future containing the result of the DescribeClusterTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks(
            DescribeClusterTracksRequest describeClusterTracksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterTracksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterTracksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterTracks");

            HttpResponseHandler<DescribeClusterTracksResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterTracksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterTracksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterTracksRequest, DescribeClusterTracksResponse>()
                            .withOperationName("DescribeClusterTracks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterTracksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterTracksRequest));
            CompletableFuture<DescribeClusterTracksResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterVersionsRequest
     * @return A Java Future containing the result of the DescribeClusterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions(
            DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusterVersions");

            HttpResponseHandler<DescribeClusterVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClusterVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClusterVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterVersionsRequest, DescribeClusterVersionsResponse>()
                            .withOperationName("DescribeClusterVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterVersionsRequest));
            CompletableFuture<DescribeClusterVersionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClustersRequest
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClusters");

            HttpResponseHandler<DescribeClustersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClustersRequest, DescribeClustersResponse>()
                            .withOperationName("DescribeClusters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClustersRequest));
            CompletableFuture<DescribeClustersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Contains information about custom domain associations for a cluster.
     * </p>
     *
     * @param describeCustomDomainAssociationsRequest
     * @return A Java Future containing the result of the DescribeCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeCustomDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCustomDomainAssociationsResponse> describeCustomDomainAssociations(
            DescribeCustomDomainAssociationsRequest describeCustomDomainAssociationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomDomainAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomDomainAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomDomainAssociations");

            HttpResponseHandler<DescribeCustomDomainAssociationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeCustomDomainAssociationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeCustomDomainAssociationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomDomainAssociationsRequest, DescribeCustomDomainAssociationsResponse>()
                            .withOperationName("DescribeCustomDomainAssociations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCustomDomainAssociationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCustomDomainAssociationsRequest));
            CompletableFuture<DescribeCustomDomainAssociationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shows the status of any inbound or outbound datashares available in the specified account.
     * </p>
     *
     * @param describeDataSharesRequest
     * @return A Java Future containing the result of the DescribeDataShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataShares" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSharesResponse> describeDataShares(DescribeDataSharesRequest describeDataSharesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSharesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataShares");

            HttpResponseHandler<DescribeDataSharesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDataSharesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDataSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSharesRequest, DescribeDataSharesResponse>()
                            .withOperationName("DescribeDataShares").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSharesRequest));
            CompletableFuture<DescribeDataSharesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     * </p>
     *
     * @param describeDataSharesForConsumerRequest
     * @return A Java Future containing the result of the DescribeDataSharesForConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSharesForConsumerResponse> describeDataSharesForConsumer(
            DescribeDataSharesForConsumerRequest describeDataSharesForConsumerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSharesForConsumerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSharesForConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSharesForConsumer");

            HttpResponseHandler<DescribeDataSharesForConsumerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDataSharesForConsumerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDataSharesForConsumerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSharesForConsumerRequest, DescribeDataSharesForConsumerResponse>()
                            .withOperationName("DescribeDataSharesForConsumer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSharesForConsumerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSharesForConsumerRequest));
            CompletableFuture<DescribeDataSharesForConsumerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     * </p>
     *
     * @param describeDataSharesForProducerRequest
     * @return A Java Future containing the result of the DescribeDataSharesForProducer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForProducer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForProducer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSharesForProducerResponse> describeDataSharesForProducer(
            DescribeDataSharesForProducerRequest describeDataSharesForProducerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSharesForProducerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSharesForProducerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSharesForProducer");

            HttpResponseHandler<DescribeDataSharesForProducerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDataSharesForProducerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDataSharesForProducerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSharesForProducerRequest, DescribeDataSharesForProducerResponse>()
                            .withOperationName("DescribeDataSharesForProducer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDataSharesForProducerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDataSharesForProducerRequest));
            CompletableFuture<DescribeDataSharesForProducerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDefaultClusterParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDefaultClusterParametersResponse> describeDefaultClusterParameters(
            DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDefaultClusterParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDefaultClusterParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDefaultClusterParameters");

            HttpResponseHandler<DescribeDefaultClusterParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeDefaultClusterParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeDefaultClusterParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDefaultClusterParametersRequest, DescribeDefaultClusterParametersResponse>()
                            .withOperationName("DescribeDefaultClusterParameters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDefaultClusterParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDefaultClusterParametersRequest));
            CompletableFuture<DescribeDefaultClusterParametersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param describeEndpointAccessRequest
     * @return A Java Future containing the result of the DescribeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointAccessResponse> describeEndpointAccess(
            DescribeEndpointAccessRequest describeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointAccess");

            HttpResponseHandler<DescribeEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointAccessRequest, DescribeEndpointAccessResponse>()
                            .withOperationName("DescribeEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointAccessRequest));
            CompletableFuture<DescribeEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an endpoint authorization.
     * </p>
     *
     * @param describeEndpointAuthorizationRequest
     * @return A Java Future containing the result of the DescribeEndpointAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointAuthorizationResponse> describeEndpointAuthorization(
            DescribeEndpointAuthorizationRequest describeEndpointAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEndpointAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointAuthorization");

            HttpResponseHandler<DescribeEndpointAuthorizationResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEndpointAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEndpointAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointAuthorizationRequest, DescribeEndpointAuthorizationResponse>()
                            .withOperationName("DescribeEndpointAuthorization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEndpointAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEndpointAuthorizationRequest));
            CompletableFuture<DescribeEndpointAuthorizationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventCategoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");

            HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventCategoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventCategoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventCategoriesRequest));
            CompletableFuture<DescribeEventCategoriesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");

            HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventSubscriptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventSubscriptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventSubscriptionsRequest));
            CompletableFuture<DescribeEventSubscriptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                            .withOperationName("DescribeEvents").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventsRequest));
            CompletableFuture<DescribeEventsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     * @return A Java Future containing the result of the DescribeHsmClientCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates(
            DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHsmClientCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeHsmClientCertificatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHsmClientCertificates");

            HttpResponseHandler<DescribeHsmClientCertificatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeHsmClientCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeHsmClientCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHsmClientCertificatesRequest, DescribeHsmClientCertificatesResponse>()
                            .withOperationName("DescribeHsmClientCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHsmClientCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHsmClientCertificatesRequest));
            CompletableFuture<DescribeHsmClientCertificatesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     * @return A Java Future containing the result of the DescribeHsmConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations(
            DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHsmConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHsmConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHsmConfigurations");

            HttpResponseHandler<DescribeHsmConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeHsmConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeHsmConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHsmConfigurationsRequest, DescribeHsmConfigurationsResponse>()
                            .withOperationName("DescribeHsmConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHsmConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHsmConfigurationsRequest));
            CompletableFuture<DescribeHsmConfigurationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of inbound integrations.
     * </p>
     *
     * @param describeInboundIntegrationsRequest
     * @return A Java Future containing the result of the DescribeInboundIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The integration can't be found.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeInboundIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeInboundIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInboundIntegrationsResponse> describeInboundIntegrations(
            DescribeInboundIntegrationsRequest describeInboundIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInboundIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInboundIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundIntegrations");

            HttpResponseHandler<DescribeInboundIntegrationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeInboundIntegrationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeInboundIntegrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundIntegrationsRequest, DescribeInboundIntegrationsResponse>()
                            .withOperationName("DescribeInboundIntegrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInboundIntegrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInboundIntegrationsRequest));
            CompletableFuture<DescribeInboundIntegrationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more zero-ETL or S3 event integrations with Amazon Redshift.
     * </p>
     *
     * @param describeIntegrationsRequest
     * @return A Java Future containing the result of the DescribeIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The integration can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeIntegrations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(
            DescribeIntegrationsRequest describeIntegrationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIntegrations");

            HttpResponseHandler<DescribeIntegrationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeIntegrationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeIntegrationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIntegrationsRequest, DescribeIntegrationsResponse>()
                            .withOperationName("DescribeIntegrations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeIntegrationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeIntegrationsRequest));
            CompletableFuture<DescribeIntegrationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon
     * Redshift cluster.
     * </p>
     *
     * @param describeLoggingStatusRequest
     * @return A Java Future containing the result of the DescribeLoggingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeLoggingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLoggingStatusResponse> describeLoggingStatus(
            DescribeLoggingStatusRequest describeLoggingStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoggingStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoggingStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoggingStatus");

            HttpResponseHandler<DescribeLoggingStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeLoggingStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeLoggingStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLoggingStatusRequest, DescribeLoggingStatusResponse>()
                            .withOperationName("DescribeLoggingStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLoggingStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLoggingStatusRequest));
            CompletableFuture<DescribeLoggingStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the
     * specified action type.
     * </p>
     *
     * @param describeNodeConfigurationOptionsRequest
     * @return A Java Future containing the result of the DescribeNodeConfigurationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeNodeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNodeConfigurationOptionsResponse> describeNodeConfigurationOptions(
            DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNodeConfigurationOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeNodeConfigurationOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNodeConfigurationOptions");

            HttpResponseHandler<DescribeNodeConfigurationOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeNodeConfigurationOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeNodeConfigurationOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNodeConfigurationOptionsRequest, DescribeNodeConfigurationOptionsResponse>()
                            .withOperationName("DescribeNodeConfigurationOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeNodeConfigurationOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNodeConfigurationOptionsRequest));
            CompletableFuture<DescribeNodeConfigurationOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableClusterOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions(
            DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrderableClusterOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableClusterOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableClusterOptions");

            HttpResponseHandler<DescribeOrderableClusterOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeOrderableClusterOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeOrderableClusterOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableClusterOptionsRequest, DescribeOrderableClusterOptionsResponse>()
                            .withOperationName("DescribeOrderableClusterOptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrderableClusterOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrderableClusterOptionsRequest));
            CompletableFuture<DescribeOrderableClusterOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the partner integrations defined for a cluster.
     * </p>
     *
     * @param describePartnersRequest
     * @return A Java Future containing the result of the DescribePartners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribePartners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribePartners" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePartnersResponse> describePartners(DescribePartnersRequest describePartnersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePartnersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePartnersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePartners");

            HttpResponseHandler<DescribePartnersResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribePartnersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribePartnersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePartnersRequest, DescribePartnersResponse>()
                            .withOperationName("DescribePartners").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribePartnersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePartnersRequest));
            CompletableFuture<DescribePartnersResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Amazon Redshift IAM Identity Center applications.
     * </p>
     *
     * @param describeRedshiftIdcApplicationsRequest
     * @return A Java Future containing the result of the DescribeRedshiftIdcApplications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RedshiftIdcApplicationNotExistsException The application you attempted to find doesn't exist.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceAccessDeniedException A dependent service denied access for the integration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeRedshiftIdcApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeRedshiftIdcApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRedshiftIdcApplicationsResponse> describeRedshiftIdcApplications(
            DescribeRedshiftIdcApplicationsRequest describeRedshiftIdcApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRedshiftIdcApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeRedshiftIdcApplicationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRedshiftIdcApplications");

            HttpResponseHandler<DescribeRedshiftIdcApplicationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeRedshiftIdcApplicationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeRedshiftIdcApplicationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRedshiftIdcApplicationsRequest, DescribeRedshiftIdcApplicationsResponse>()
                            .withOperationName("DescribeRedshiftIdcApplications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRedshiftIdcApplicationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRedshiftIdcApplicationsRequest));
            CompletableFuture<DescribeRedshiftIdcApplicationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such
     * values as in progress and requested.
     * </p>
     *
     * @param describeReservedNodeExchangeStatusRequest
     * @return A Java Future containing the result of the DescribeReservedNodeExchangeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>ReservedNodeExchangeNotFoundException The reserved-node exchange status wasn't found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeExchangeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeExchangeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedNodeExchangeStatusResponse> describeReservedNodeExchangeStatus(
            DescribeReservedNodeExchangeStatusRequest describeReservedNodeExchangeStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedNodeExchangeStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedNodeExchangeStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedNodeExchangeStatus");

            HttpResponseHandler<DescribeReservedNodeExchangeStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedNodeExchangeStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedNodeExchangeStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedNodeExchangeStatusRequest, DescribeReservedNodeExchangeStatusResponse>()
                            .withOperationName("DescribeReservedNodeExchangeStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReservedNodeExchangeStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedNodeExchangeStatusRequest));
            CompletableFuture<DescribeReservedNodeExchangeStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     * @return A Java Future containing the result of the DescribeReservedNodeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings(
            DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedNodeOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedNodeOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedNodeOfferings");

            HttpResponseHandler<DescribeReservedNodeOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedNodeOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedNodeOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedNodeOfferingsRequest, DescribeReservedNodeOfferingsResponse>()
                            .withOperationName("DescribeReservedNodeOfferings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReservedNodeOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedNodeOfferingsRequest));
            CompletableFuture<DescribeReservedNodeOfferingsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return A Java Future containing the result of the DescribeReservedNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(
            DescribeReservedNodesRequest describeReservedNodesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedNodesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservedNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedNodes");

            HttpResponseHandler<DescribeReservedNodesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeReservedNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeReservedNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedNodesRequest, DescribeReservedNodesResponse>()
                            .withOperationName("DescribeReservedNodes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReservedNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedNodesRequest));
            CompletableFuture<DescribeReservedNodesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever
     * been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was
     * initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize.
     * </p>
     * <p>
     * A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes
     * for the cluster.
     * </p>
     *
     * @param describeResizeRequest
     * @return A Java Future containing the result of the DescribeResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResizeResponse> describeResize(DescribeResizeRequest describeResizeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResizeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResizeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResize");

            HttpResponseHandler<DescribeResizeResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeResizeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeResizeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResizeRequest, DescribeResizeResponse>()
                            .withOperationName("DescribeResize").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResizeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResizeRequest));
            CompletableFuture<DescribeResizeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes properties of scheduled actions.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScheduledActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScheduledActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeScheduledActions");

            HttpResponseHandler<DescribeScheduledActionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeScheduledActionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeScheduledActionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledActionsRequest, DescribeScheduledActionsResponse>()
                            .withOperationName("DescribeScheduledActions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeScheduledActionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeScheduledActionsRequest));
            CompletableFuture<DescribeScheduledActionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return A Java Future containing the result of the DescribeSnapshotCopyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants(
            DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotCopyGrantsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotCopyGrantsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshotCopyGrants");

            HttpResponseHandler<DescribeSnapshotCopyGrantsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSnapshotCopyGrantsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSnapshotCopyGrantsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotCopyGrantsRequest, DescribeSnapshotCopyGrantsResponse>()
                            .withOperationName("DescribeSnapshotCopyGrants").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSnapshotCopyGrantsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSnapshotCopyGrantsRequest));
            CompletableFuture<DescribeSnapshotCopyGrantsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     * @return A Java Future containing the result of the DescribeSnapshotSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules(
            DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotSchedulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotSchedulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshotSchedules");

            HttpResponseHandler<DescribeSnapshotSchedulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeSnapshotSchedulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeSnapshotSchedulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotSchedulesRequest, DescribeSnapshotSchedulesResponse>()
                            .withOperationName("DescribeSnapshotSchedules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSnapshotSchedulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSnapshotSchedulesRequest));
            CompletableFuture<DescribeSnapshotSchedulesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns account level backups storage size and provisional storage.
     * </p>
     *
     * @param describeStorageRequest
     * @return A Java Future containing the result of the DescribeStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeStorageResponse> describeStorage(DescribeStorageRequest describeStorageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStorageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStorageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStorage");

            HttpResponseHandler<DescribeStorageResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeStorageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeStorageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeStorageRequest, DescribeStorageResponse>()
                            .withOperationName("DescribeStorage").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeStorageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeStorageRequest));
            CompletableFuture<DescribeStorageResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     * @return A Java Future containing the result of the DescribeTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TableRestoreNotFoundException The specified <code>TableRestoreRequestId</code> value was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTableRestoreStatusResponse> describeTableRestoreStatus(
            DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTableRestoreStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTableRestoreStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTableRestoreStatus");

            HttpResponseHandler<DescribeTableRestoreStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTableRestoreStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTableRestoreStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTableRestoreStatusRequest, DescribeTableRestoreStatusResponse>()
                            .withOperationName("DescribeTableRestoreStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTableRestoreStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTableRestoreStatusRequest));
            CompletableFuture<DescribeTableRestoreStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                            .withOperationName("DescribeTags").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTagsRequest));
            CompletableFuture<DescribeTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier,
     * cluster identifier, and feature type parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects
     * for the current account in the current region are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster
     * and feature are returned.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeUsageLimitsRequest
     * @return A Java Future containing the result of the DescribeUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeUsageLimits" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUsageLimitsResponse> describeUsageLimits(
            DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUsageLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUsageLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUsageLimits");

            HttpResponseHandler<DescribeUsageLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(DescribeUsageLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DescribeUsageLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUsageLimitsRequest, DescribeUsageLimitsResponse>()
                            .withOperationName("DescribeUsageLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUsageLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUsageLimitsRequest));
            CompletableFuture<DescribeUsageLimitsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param disableLoggingRequest
     * @return A Java Future containing the result of the DisableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableLoggingResponse> disableLogging(DisableLoggingRequest disableLoggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableLoggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableLogging");

            HttpResponseHandler<DisableLoggingResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisableLoggingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisableLoggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableLoggingRequest, DisableLoggingResponse>()
                            .withOperationName("DisableLogging").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableLoggingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableLoggingRequest));
            CompletableFuture<DisableLoggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     * </p>
     * <p>
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use
     * <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the key in the
     * destination region.
     * </p>
     *
     * @param disableSnapshotCopyRequest
     * @return A Java Future containing the result of the DisableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotCopyAlreadyDisabledException The cluster already has cross-region snapshot copy disabled.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableSnapshotCopyResponse> disableSnapshotCopy(
            DisableSnapshotCopyRequest disableSnapshotCopyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableSnapshotCopyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableSnapshotCopyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSnapshotCopy");

            HttpResponseHandler<DisableSnapshotCopyResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisableSnapshotCopyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisableSnapshotCopyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableSnapshotCopyRequest, DisableSnapshotCopyResponse>()
                            .withOperationName("DisableSnapshotCopy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableSnapshotCopyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableSnapshotCopyRequest));
            CompletableFuture<DisableSnapshotCopyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * From a datashare consumer account, remove association for the specified datashare.
     * </p>
     *
     * @param disassociateDataShareConsumerRequest
     * @return A Java Future containing the result of the DisassociateDataShareConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisassociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisassociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateDataShareConsumerResponse> disassociateDataShareConsumer(
            DisassociateDataShareConsumerRequest disassociateDataShareConsumerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateDataShareConsumerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateDataShareConsumerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateDataShareConsumer");

            HttpResponseHandler<DisassociateDataShareConsumerResponse> responseHandler = protocolFactory
                    .createResponseHandler(DisassociateDataShareConsumerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<DisassociateDataShareConsumerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateDataShareConsumerRequest, DisassociateDataShareConsumerResponse>()
                            .withOperationName("DisassociateDataShareConsumer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateDataShareConsumerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateDataShareConsumerRequest));
            CompletableFuture<DisassociateDataShareConsumerResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param enableLoggingRequest
     * @return A Java Future containing the result of the EnableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>BucketNotFoundException Could not find the specified S3 bucket.</li>
     *         <li>InsufficientS3BucketPolicyException The cluster does not have read bucket or put object permissions
     *         on the S3 bucket specified when enabling logging.</li>
     *         <li>InvalidS3KeyPrefixException The string specified for the logging S3 key prefix does not comply with
     *         the documented constraints.</li>
     *         <li>InvalidS3BucketNameException The S3 bucket name is invalid. For more information about naming rules,
     *         go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
     *         Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableLoggingResponse> enableLogging(EnableLoggingRequest enableLoggingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableLoggingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableLoggingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableLogging");

            HttpResponseHandler<EnableLoggingResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableLoggingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EnableLoggingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableLoggingRequest, EnableLoggingResponse>()
                            .withOperationName("EnableLogging").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableLoggingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableLoggingRequest));
            CompletableFuture<EnableLoggingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     * </p>
     *
     * @param enableSnapshotCopyRequest
     * @return A Java Future containing the result of the EnableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IncompatibleOrderableOptionsException The specified options are incompatible.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CopyToRegionDisabledException Cross-region snapshot copy was temporarily disabled. Try your request
     *         again.</li>
     *         <li>SnapshotCopyAlreadyEnabledException The cluster already has cross-region snapshot copy enabled.</li>
     *         <li>UnknownSnapshotCopyRegionException The specified region is incorrect or does not exist.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableSnapshotCopyResponse> enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableSnapshotCopyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableSnapshotCopyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSnapshotCopy");

            HttpResponseHandler<EnableSnapshotCopyResponse> responseHandler = protocolFactory
                    .createResponseHandler(EnableSnapshotCopyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<EnableSnapshotCopyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableSnapshotCopyRequest, EnableSnapshotCopyResponse>()
                            .withOperationName("EnableSnapshotCopy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableSnapshotCopyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableSnapshotCopyRequest));
            CompletableFuture<EnableSnapshotCopyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Fails over the primary compute unit of the specified Multi-AZ cluster to another Availability Zone.
     * </p>
     *
     * @param failoverPrimaryComputeRequest
     * @return A Java Future containing the result of the FailoverPrimaryCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.FailoverPrimaryCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/FailoverPrimaryCompute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<FailoverPrimaryComputeResponse> failoverPrimaryCompute(
            FailoverPrimaryComputeRequest failoverPrimaryComputeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(failoverPrimaryComputeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, failoverPrimaryComputeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FailoverPrimaryCompute");

            HttpResponseHandler<FailoverPrimaryComputeResponse> responseHandler = protocolFactory
                    .createResponseHandler(FailoverPrimaryComputeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<FailoverPrimaryComputeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<FailoverPrimaryComputeRequest, FailoverPrimaryComputeResponse>()
                            .withOperationName("FailoverPrimaryCompute").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new FailoverPrimaryComputeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(failoverPrimaryComputeRequest));
            CompletableFuture<FailoverPrimaryComputeResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift
     * database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is
     * <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally
     * specify one or more database user groups that the user will join at log on. By default, the temporary credentials
     * expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds
     * (60 minutes). For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
     * to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy
     * attached that allows access to all necessary actions and resources. For more information about permissions, see
     * <a href=
     * "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources"
     * >Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
     * <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>.
     * </p>
     * <p>
     * In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include
     * the <code>redshift:CreateClusterUser</code> permission.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource
     * <code>dbname</code> for the specified database name.
     * </p>
     *
     * @param getClusterCredentialsRequest
     *        The request parameters to get cluster credentials.
     * @return A Java Future containing the result of the GetClusterCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetClusterCredentialsResponse> getClusterCredentials(
            GetClusterCredentialsRequest getClusterCredentialsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getClusterCredentialsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClusterCredentialsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClusterCredentials");

            HttpResponseHandler<GetClusterCredentialsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetClusterCredentialsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetClusterCredentialsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClusterCredentialsRequest, GetClusterCredentialsResponse>()
                            .withOperationName("GetClusterCredentials").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetClusterCredentialsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getClusterCredentialsRequest));
            CompletableFuture<GetClusterCredentialsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift
     * database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more
     * information about IAM identities, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html">IAM
     * Identities (users, user groups, and roles)</a> in the Amazon Web Services Identity and Access Management User
     * Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that
     * allows access to all necessary actions and resources. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
     * identity-based policies (IAM policies)</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param getClusterCredentialsWithIamRequest
     * @return A Java Future containing the result of the GetClusterCredentialsWithIAM operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentialsWithIAM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentialsWithIAM"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetClusterCredentialsWithIamResponse> getClusterCredentialsWithIAM(
            GetClusterCredentialsWithIamRequest getClusterCredentialsWithIamRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getClusterCredentialsWithIamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClusterCredentialsWithIamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClusterCredentialsWithIAM");

            HttpResponseHandler<GetClusterCredentialsWithIamResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetClusterCredentialsWithIamResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetClusterCredentialsWithIamResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClusterCredentialsWithIamRequest, GetClusterCredentialsWithIamResponse>()
                            .withOperationName("GetClusterCredentialsWithIAM").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetClusterCredentialsWithIamRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getClusterCredentialsWithIamRequest));
            CompletableFuture<GetClusterCredentialsWithIamResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the configuration options for the reserved-node exchange. These options include information about the source
     * reserved node and target reserved node offering. Details include the node type, the price, the node count, and
     * the offering type.
     * </p>
     *
     * @param getReservedNodeExchangeConfigurationOptionsRequest
     * @return A Java Future containing the result of the GetReservedNodeExchangeConfigurationOptions operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeConfigurationOptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> getReservedNodeExchangeConfigurationOptions(
            GetReservedNodeExchangeConfigurationOptionsRequest getReservedNodeExchangeConfigurationOptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getReservedNodeExchangeConfigurationOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getReservedNodeExchangeConfigurationOptionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReservedNodeExchangeConfigurationOptions");

            HttpResponseHandler<GetReservedNodeExchangeConfigurationOptionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetReservedNodeExchangeConfigurationOptionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReservedNodeExchangeConfigurationOptionsRequest, GetReservedNodeExchangeConfigurationOptionsResponse>()
                            .withOperationName("GetReservedNodeExchangeConfigurationOptions")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReservedNodeExchangeConfigurationOptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getReservedNodeExchangeConfigurationOptionsRequest));
            CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     * @return A Java Future containing the result of the GetReservedNodeExchangeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReservedNodeExchangeOfferingsResponse> getReservedNodeExchangeOfferings(
            GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReservedNodeExchangeOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getReservedNodeExchangeOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReservedNodeExchangeOfferings");

            HttpResponseHandler<GetReservedNodeExchangeOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetReservedNodeExchangeOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetReservedNodeExchangeOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReservedNodeExchangeOfferingsRequest, GetReservedNodeExchangeOfferingsResponse>()
                            .withOperationName("GetReservedNodeExchangeOfferings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReservedNodeExchangeOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getReservedNodeExchangeOfferingsRequest));
            CompletableFuture<GetReservedNodeExchangeOfferingsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the resource policy for a specified resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPolicyException The resource policy isn't valid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");

            HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(GetResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<GetResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                            .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResourcePolicyRequest));
            CompletableFuture<GetResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the Amazon Redshift Advisor recommendations for one or multiple Amazon Redshift clusters in an Amazon Web
     * Services account.
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ListRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecommendationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecommendationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecommendations");

            HttpResponseHandler<ListRecommendationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(ListRecommendationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ListRecommendationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecommendationsRequest, ListRecommendationsResponse>()
                            .withOperationName("ListRecommendations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecommendationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecommendationsRequest));
            CompletableFuture<ListRecommendationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This operation is retired. Calling this operation does not change AQUA configuration. Amazon Redshift
     * automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     *
     * @param modifyAquaConfigurationRequest
     * @return A Java Future containing the result of the ModifyAquaConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAquaConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAquaConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyAquaConfigurationResponse> modifyAquaConfiguration(
            ModifyAquaConfigurationRequest modifyAquaConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyAquaConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyAquaConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyAquaConfiguration");

            HttpResponseHandler<ModifyAquaConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyAquaConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyAquaConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyAquaConfigurationRequest, ModifyAquaConfigurationResponse>()
                            .withOperationName("ModifyAquaConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyAquaConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyAquaConfigurationRequest));
            CompletableFuture<ModifyAquaConfigurationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an authentication profile.
     * </p>
     *
     * @param modifyAuthenticationProfileRequest
     * @return A Java Future containing the result of the ModifyAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyAuthenticationProfileResponse> modifyAuthenticationProfile(
            ModifyAuthenticationProfileRequest modifyAuthenticationProfileRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyAuthenticationProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyAuthenticationProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyAuthenticationProfile");

            HttpResponseHandler<ModifyAuthenticationProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyAuthenticationProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyAuthenticationProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyAuthenticationProfileRequest, ModifyAuthenticationProfileResponse>()
                            .withOperationName("ModifyAuthenticationProfile").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyAuthenticationProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyAuthenticationProfileRequest));
            CompletableFuture<ModifyAuthenticationProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a cluster.
     * </p>
     * <p>
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster,
     * you must specify both the number of nodes and the node type even if one of the parameters does not change.
     * </p>
     * <p>
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password
     * or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter
     * group requires a reboot for parameters to take effect. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterRequest
     * @return A Java Future containing the result of the ModifyCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>UnsupportedOptionException A request option was specified that is not supported.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TableLimitExceededException The number of tables in the cluster exceeds the limit for the requested
     *         new cluster node type.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCluster");

            HttpResponseHandler<ModifyClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterRequest, ModifyClusterResponse>()
                            .withOperationName("ModifyCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterRequest));
            CompletableFuture<ModifyClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running
     * in a cluster.
     * </p>
     *
     * @param modifyClusterDbRevisionRequest
     * @return A Java Future containing the result of the ModifyClusterDbRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterOnLatestRevisionException Cluster is already on the latest database revision.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterDbRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterDbRevisionResponse> modifyClusterDbRevision(
            ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterDbRevisionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterDbRevisionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterDbRevision");

            HttpResponseHandler<ModifyClusterDbRevisionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterDbRevisionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterDbRevisionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterDbRevisionRequest, ModifyClusterDbRevisionResponse>()
                            .withOperationName("ModifyClusterDbRevision").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterDbRevisionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterDbRevisionRequest));
            CompletableFuture<ModifyClusterDbRevisionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
     * Amazon Web Services services.
     * </p>
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the
     * <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterIamRolesRequest
     * @return A Java Future containing the result of the ModifyClusterIamRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterIamRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterIamRolesResponse> modifyClusterIamRoles(
            ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterIamRolesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterIamRolesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterIamRoles");

            HttpResponseHandler<ModifyClusterIamRolesResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterIamRolesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterIamRolesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterIamRolesRequest, ModifyClusterIamRolesResponse>()
                            .withOperationName("ModifyClusterIamRoles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterIamRolesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterIamRolesRequest));
            CompletableFuture<ModifyClusterIamRolesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the maintenance settings of a cluster.
     * </p>
     *
     * @param modifyClusterMaintenanceRequest
     * @return A Java Future containing the result of the ModifyClusterMaintenance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterMaintenance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterMaintenanceResponse> modifyClusterMaintenance(
            ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterMaintenanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterMaintenanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterMaintenance");

            HttpResponseHandler<ModifyClusterMaintenanceResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterMaintenanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterMaintenanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterMaintenanceRequest, ModifyClusterMaintenanceResponse>()
                            .withOperationName("ModifyClusterMaintenance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterMaintenanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterMaintenanceRequest));
            CompletableFuture<ModifyClusterMaintenanceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterParameterGroupRequest
     *        Describes a modify cluster parameter group operation.
     * @return A Java Future containing the result of the ModifyClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterParameterGroupResponse> modifyClusterParameterGroup(
            ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterParameterGroup");

            HttpResponseHandler<ModifyClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterParameterGroupRequest, ModifyClusterParameterGroupResponse>()
                            .withOperationName("ModifyClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterParameterGroupRequest));
            CompletableFuture<ModifyClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings for a snapshot.
     * </p>
     * <p>
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     * </p>
     *
     * @param modifyClusterSnapshotRequest
     * @return A Java Future containing the result of the ModifyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterSnapshotResponse> modifyClusterSnapshot(
            ModifyClusterSnapshotRequest modifyClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterSnapshot");

            HttpResponseHandler<ModifyClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterSnapshotRequest, ModifyClusterSnapshotResponse>()
                            .withOperationName("ModifyClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterSnapshotRequest));
            CompletableFuture<ModifyClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a snapshot schedule for a cluster.
     * </p>
     *
     * @param modifyClusterSnapshotScheduleRequest
     * @return A Java Future containing the result of the ModifyClusterSnapshotSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterSnapshotScheduleResponse> modifyClusterSnapshotSchedule(
            ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterSnapshotScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyClusterSnapshotScheduleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterSnapshotSchedule");

            HttpResponseHandler<ModifyClusterSnapshotScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterSnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterSnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterSnapshotScheduleRequest, ModifyClusterSnapshotScheduleResponse>()
                            .withOperationName("ModifyClusterSnapshotSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterSnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterSnapshotScheduleRequest));
            CompletableFuture<ModifyClusterSnapshotScheduleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing
     * list of subnets with the new list of subnets.
     * </p>
     *
     * @param modifyClusterSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubnetAlreadyInUseException A specified subnet is already in use by another cluster.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyClusterSubnetGroupResponse> modifyClusterSubnetGroup(
            ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClusterSubnetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClusterSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClusterSubnetGroup");

            HttpResponseHandler<ModifyClusterSubnetGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyClusterSubnetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyClusterSubnetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyClusterSubnetGroupRequest, ModifyClusterSubnetGroupResponse>()
                            .withOperationName("ModifyClusterSubnetGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyClusterSubnetGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyClusterSubnetGroupRequest));
            CompletableFuture<ModifyClusterSubnetGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Contains information for changing a custom domain association.
     * </p>
     *
     * @param modifyCustomDomainAssociationRequest
     * @return A Java Future containing the result of the ModifyCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyCustomDomainAssociationResponse> modifyCustomDomainAssociation(
            ModifyCustomDomainAssociationRequest modifyCustomDomainAssociationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCustomDomainAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyCustomDomainAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCustomDomainAssociation");

            HttpResponseHandler<ModifyCustomDomainAssociationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyCustomDomainAssociationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyCustomDomainAssociationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyCustomDomainAssociationRequest, ModifyCustomDomainAssociationResponse>()
                            .withOperationName("ModifyCustomDomainAssociation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyCustomDomainAssociationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyCustomDomainAssociationRequest));
            CompletableFuture<ModifyCustomDomainAssociationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param modifyEndpointAccessRequest
     * @return A Java Future containing the result of the ModifyEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyEndpointAccessResponse> modifyEndpointAccess(
            ModifyEndpointAccessRequest modifyEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEndpointAccess");

            HttpResponseHandler<ModifyEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyEndpointAccessRequest, ModifyEndpointAccessResponse>()
                            .withOperationName("ModifyEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyEndpointAccessRequest));
            CompletableFuture<ModifyEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an existing Amazon Redshift event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>SnsInvalidTopicException Amazon SNS has responded that there is a problem with the specified Amazon
     *         SNS topic.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the specified Amazon SNS topic.</li>
     *         <li>SnsTopicArnNotFoundException An Amazon SNS topic with the specified Amazon Resource Name (ARN) does
     *         not exist.</li>
     *         <li>SubscriptionEventIdNotFoundException An Amazon Redshift event with the specified event ID does not
     *         exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The value specified for the event category was not one of the
     *         allowed values, or it specified a category that does not apply to the specified source type. The allowed
     *         values are Configuration, Management, Monitoring, and Security.</li>
     *         <li>SubscriptionSeverityNotFoundException The value specified for the event severity was not one of the
     *         allowed values, or it specified a severity that does not apply to the specified source type. The allowed
     *         values are ERROR and INFO.</li>
     *         <li>SourceNotFoundException The specified Amazon Redshift event source could not be found.</li>
     *         <li>InvalidSubscriptionStateException The subscription request is invalid because it is a duplicate
     *         request. This subscription request is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyEventSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEventSubscription");

            HttpResponseHandler<ModifyEventSubscriptionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyEventSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyEventSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse>()
                            .withOperationName("ModifyEventSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyEventSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyEventSubscriptionRequest));
            CompletableFuture<ModifyEventSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a zero-ETL integration or S3 event integration with Amazon Redshift.
     * </p>
     *
     * @param modifyIntegrationRequest
     * @return A Java Future containing the result of the ModifyIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The integration can't be found.</li>
     *         <li>IntegrationConflictStateException The integration is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. This typically occurs when there are multiple requests being made to the same
     *         resource at the same time, and these requests conflict with each other.</li>
     *         <li>IntegrationAlreadyExistsException The integration you are trying to create already exists.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyIntegration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyIntegrationResponse> modifyIntegration(ModifyIntegrationRequest modifyIntegrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyIntegration");

            HttpResponseHandler<ModifyIntegrationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyIntegrationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyIntegrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyIntegrationRequest, ModifyIntegrationResponse>()
                            .withOperationName("ModifyIntegration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyIntegrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyIntegrationRequest));
            CompletableFuture<ModifyIntegrationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes an existing Amazon Redshift IAM Identity Center application.
     * </p>
     *
     * @param modifyRedshiftIdcApplicationRequest
     * @return A Java Future containing the result of the ModifyRedshiftIdcApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>RedshiftIdcApplicationNotExistsException The application you attempted to find doesn't exist.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceAccessDeniedException A dependent service denied access for the integration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyRedshiftIdcApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyRedshiftIdcApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyRedshiftIdcApplicationResponse> modifyRedshiftIdcApplication(
            ModifyRedshiftIdcApplicationRequest modifyRedshiftIdcApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyRedshiftIdcApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyRedshiftIdcApplicationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyRedshiftIdcApplication");

            HttpResponseHandler<ModifyRedshiftIdcApplicationResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyRedshiftIdcApplicationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyRedshiftIdcApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyRedshiftIdcApplicationRequest, ModifyRedshiftIdcApplicationResponse>()
                            .withOperationName("ModifyRedshiftIdcApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyRedshiftIdcApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyRedshiftIdcApplicationRequest));
            CompletableFuture<ModifyRedshiftIdcApplicationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a scheduled action.
     * </p>
     *
     * @param modifyScheduledActionRequest
     * @return A Java Future containing the result of the ModifyScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>ScheduledActionTypeUnsupportedException The action type specified for a scheduled action is not
     *         supported.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>InvalidScheduledActionException The scheduled action is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyScheduledActionResponse> modifyScheduledAction(
            ModifyScheduledActionRequest modifyScheduledActionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyScheduledActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyScheduledActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyScheduledAction");

            HttpResponseHandler<ModifyScheduledActionResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyScheduledActionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyScheduledActionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyScheduledActionRequest, ModifyScheduledActionResponse>()
                            .withOperationName("ModifyScheduledAction").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyScheduledActionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyScheduledActionRequest));
            CompletableFuture<ModifyScheduledActionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are
     * copied from the source Amazon Web Services Region. By default, this operation only changes the retention period
     * of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are
     * updated with the new retention period. You can set the manual option to change only the retention periods of
     * copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention
     * period.
     * </p>
     *
     * @param modifySnapshotCopyRetentionPeriodRequest
     * @return A Java Future containing the result of the ModifySnapshotCopyRetentionPeriod operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotCopyDisabledException Cross-region snapshot copy was temporarily disabled. Try your request
     *         again.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifySnapshotCopyRetentionPeriod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifySnapshotCopyRetentionPeriodResponse> modifySnapshotCopyRetentionPeriod(
            ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifySnapshotCopyRetentionPeriodRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifySnapshotCopyRetentionPeriodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySnapshotCopyRetentionPeriod");

            HttpResponseHandler<ModifySnapshotCopyRetentionPeriodResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifySnapshotCopyRetentionPeriodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifySnapshotCopyRetentionPeriodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifySnapshotCopyRetentionPeriodRequest, ModifySnapshotCopyRetentionPeriodResponse>()
                            .withOperationName("ModifySnapshotCopyRetentionPeriod").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifySnapshotCopyRetentionPeriodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifySnapshotCopyRetentionPeriodRequest));
            CompletableFuture<ModifySnapshotCopyRetentionPeriodResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     * </p>
     *
     * @param modifySnapshotScheduleRequest
     * @return A Java Future containing the result of the ModifySnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>SnapshotScheduleUpdateInProgressException The specified snapshot schedule is already being updated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifySnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ModifySnapshotScheduleResponse> modifySnapshotSchedule(
            ModifySnapshotScheduleRequest modifySnapshotScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifySnapshotScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifySnapshotScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySnapshotSchedule");

            HttpResponseHandler<ModifySnapshotScheduleResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifySnapshotScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifySnapshotScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifySnapshotScheduleRequest, ModifySnapshotScheduleResponse>()
                            .withOperationName("ModifySnapshotSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifySnapshotScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifySnapshotScheduleRequest));
            CompletableFuture<ModifySnapshotScheduleResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
     * </p>
     *
     * @param modifyUsageLimitRequest
     * @return A Java Future containing the result of the ModifyUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidUsageLimitException The usage limit is not valid.</li>
     *         <li>UsageLimitNotFoundException The usage limit identifier can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ModifyUsageLimitResponse> modifyUsageLimit(ModifyUsageLimitRequest modifyUsageLimitRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyUsageLimitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyUsageLimitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyUsageLimit");

            HttpResponseHandler<ModifyUsageLimitResponse> responseHandler = protocolFactory
                    .createResponseHandler(ModifyUsageLimitResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ModifyUsageLimitResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ModifyUsageLimitRequest, ModifyUsageLimitResponse>()
                            .withOperationName("ModifyUsageLimit").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ModifyUsageLimitRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(modifyUsageLimitRequest));
            CompletableFuture<ModifyUsageLimitResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Pauses a cluster.
     * </p>
     *
     * @param pauseClusterRequest
     *        Describes a pause cluster operation. For example, a scheduled action to run the <code>PauseCluster</code>
     *        API operation.
     * @return A Java Future containing the result of the PauseCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.PauseCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PauseCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PauseClusterResponse> pauseCluster(PauseClusterRequest pauseClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(pauseClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, pauseClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PauseCluster");

            HttpResponseHandler<PauseClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(PauseClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PauseClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PauseClusterRequest, PauseClusterResponse>()
                            .withOperationName("PauseCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PauseClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(pauseClusterRequest));
            CompletableFuture<PauseClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You
     * can purchase one or more of the offerings. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain
     * the available reserved node offerings. You can call this API by providing a specific reserved node offering and
     * the number of nodes you want to reserve.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param purchaseReservedNodeOfferingRequest
     * @return A Java Future containing the result of the PurchaseReservedNodeOffering operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>ReservedNodeQuotaExceededException Request would exceed the user's compute node quota. For
     *         information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.PurchaseReservedNodeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseReservedNodeOfferingResponse> purchaseReservedNodeOffering(
            PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseReservedNodeOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseReservedNodeOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedNodeOffering");

            HttpResponseHandler<PurchaseReservedNodeOfferingResponse> responseHandler = protocolFactory
                    .createResponseHandler(PurchaseReservedNodeOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PurchaseReservedNodeOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedNodeOfferingRequest, PurchaseReservedNodeOfferingResponse>()
                            .withOperationName("PurchaseReservedNodeOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PurchaseReservedNodeOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(purchaseReservedNodeOfferingRequest));
            CompletableFuture<PurchaseReservedNodeOfferingResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource policy for a specified resource.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidPolicyException The resource policy isn't valid.</li>
     *         <li>ConflictPolicyUpdateException There is a conflict while updating the resource policy.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");

            HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory
                    .createResponseHandler(PutResourcePolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<PutResourcePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                            .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putResourcePolicyRequest));
            CompletableFuture<PutResourcePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster,
     * during which the cluster status is set to <code>rebooting</code>. A cluster event is created when the reboot is
     * completed. Any pending cluster modifications (see <a>ModifyCluster</a>) are applied at this reboot. For more
     * information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param rebootClusterRequest
     * @return A Java Future containing the result of the RebootCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RebootCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootClusterResponse> rebootCluster(RebootClusterRequest rebootClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootCluster");

            HttpResponseHandler<RebootClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(RebootClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RebootClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootClusterRequest, RebootClusterResponse>()
                            .withOperationName("RebootCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RebootClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rebootClusterRequest));
            CompletableFuture<RebootClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * From a datashare consumer account, rejects the specified datashare.
     * </p>
     *
     * @param rejectDataShareRequest
     * @return A Java Future containing the result of the RejectDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RejectDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RejectDataShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RejectDataShareResponse> rejectDataShare(RejectDataShareRequest rejectDataShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectDataShareRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectDataShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectDataShare");

            HttpResponseHandler<RejectDataShareResponse> responseHandler = protocolFactory
                    .createResponseHandler(RejectDataShareResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RejectDataShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectDataShareRequest, RejectDataShareResponse>()
                            .withOperationName("RejectDataShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectDataShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectDataShareRequest));
            CompletableFuture<RejectDataShareResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values
     * of the parameters to "engine-default". To reset the entire parameter group specify the <i>ResetAllParameters</i>
     * parameter. For parameter changes to take effect you must reboot any associated clusters.
     * </p>
     *
     * @param resetClusterParameterGroupRequest
     * @return A Java Future containing the result of the ResetClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ResetClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetClusterParameterGroupResponse> resetClusterParameterGroup(
            ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetClusterParameterGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetClusterParameterGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetClusterParameterGroup");

            HttpResponseHandler<ResetClusterParameterGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResetClusterParameterGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResetClusterParameterGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetClusterParameterGroupRequest, ResetClusterParameterGroupResponse>()
                            .withOperationName("ResetClusterParameterGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResetClusterParameterGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetClusterParameterGroupRequest));
            CompletableFuture<ResetClusterParameterGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The
     * default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read
     * and write operations more quickly than with the classic resize method.
     * </p>
     * <p>
     * Elastic resize operations have the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only resize clusters of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * dc2.large
     * </p>
     * </li>
     * <li>
     * <p>
     * dc2.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ra3.large
     * </p>
     * </li>
     * <li>
     * <p>
     * ra3.xlplus
     * </p>
     * </li>
     * <li>
     * <p>
     * ra3.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ra3.16xlarge
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The type of nodes that you add must match the node type for the cluster.
     * </p>
     * </li>
     * </ul>
     *
     * @param resizeClusterRequest
     *        Describes a resize cluster operation. For example, a scheduled action to run the
     *        <code>ResizeCluster</code> API operation.
     * @return A Java Future containing the result of the ResizeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>UnsupportedOptionException A request option was specified that is not supported.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ResizeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResizeClusterResponse> resizeCluster(ResizeClusterRequest resizeClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resizeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resizeClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResizeCluster");

            HttpResponseHandler<ResizeClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResizeClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResizeClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResizeClusterRequest, ResizeClusterResponse>()
                            .withOperationName("ResizeCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResizeClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resizeClusterRequest));
            CompletableFuture<ResizeClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same
     * configuration as the original cluster from which the snapshot was created, except that the new cluster is created
     * with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use
     * the <a>ModifyCluster</a> API to associate a different security group and different parameter group with the
     * restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the
     * same size during restore.
     * </p>
     * <p>
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param restoreFromClusterSnapshotRequest
     * @return A Java Future containing the result of the RestoreFromClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>ClusterQuotaExceededException The request would exceed the allowed number of cluster instances for
     *         this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>InvalidRestoreException The restore is invalid.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>InvalidVpcNetworkStateException The cluster subnet group does not cover all Availability Zones.</li>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>Ipv6CidrBlockNotFoundException There are no subnets in your VPC with associated IPv6 CIDR blocks. To
     *         use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RestoreFromClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreFromClusterSnapshotResponse> restoreFromClusterSnapshot(
            RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreFromClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreFromClusterSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreFromClusterSnapshot");

            HttpResponseHandler<RestoreFromClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreFromClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreFromClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreFromClusterSnapshotRequest, RestoreFromClusterSnapshotResponse>()
                            .withOperationName("RestoreFromClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreFromClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreFromClusterSnapshotRequest));
            CompletableFuture<RestoreFromClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the
     * Amazon Redshift cluster that the snapshot was taken from.
     * </p>
     * <p>
     * You cannot use <code>RestoreTableFromClusterSnapshot</code> to restore a table with the same name as an existing
     * table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored
     * table. If you want to replace your original table with a new, restored table, then rename or drop your original
     * table before you call <code>RestoreTableFromClusterSnapshot</code>. When you have renamed your original table,
     * then you can pass the original name of the table as the <code>NewTableName</code> parameter value in the call to
     * <code>RestoreTableFromClusterSnapshot</code>. This way, you can replace the original table with the table created
     * from the snapshot.
     * </p>
     * <p>
     * You can't use this operation to restore tables with <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved
     * sort keys</a>.
     * </p>
     *
     * @param restoreTableFromClusterSnapshotRequest
     * @return A Java Future containing the result of the RestoreTableFromClusterSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InProgressTableRestoreQuotaExceededException You have exceeded the allowed number of table restore
     *         requests. Wait for your current table restore requests to complete before making a new request.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>InvalidTableRestoreArgumentException The value specified for the <code>sourceDatabaseName</code>,
     *         <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a combination of these,
     *         doesn't exist in the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RestoreTableFromClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreTableFromClusterSnapshotResponse> restoreTableFromClusterSnapshot(
            RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreTableFromClusterSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                restoreTableFromClusterSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreTableFromClusterSnapshot");

            HttpResponseHandler<RestoreTableFromClusterSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(RestoreTableFromClusterSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RestoreTableFromClusterSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreTableFromClusterSnapshotRequest, RestoreTableFromClusterSnapshotResponse>()
                            .withOperationName("RestoreTableFromClusterSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestoreTableFromClusterSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restoreTableFromClusterSnapshotRequest));
            CompletableFuture<RestoreTableFromClusterSnapshotResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resumes a paused cluster.
     * </p>
     *
     * @param resumeClusterRequest
     *        Describes a resume cluster operation. For example, a scheduled action to run the
     *        <code>ResumeCluster</code> API operation.
     * @return A Java Future containing the result of the ResumeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ResumeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResumeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResumeClusterResponse> resumeCluster(ResumeClusterRequest resumeClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resumeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeCluster");

            HttpResponseHandler<ResumeClusterResponse> responseHandler = protocolFactory
                    .createResponseHandler(ResumeClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<ResumeClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResumeClusterRequest, ResumeClusterResponse>()
                            .withOperationName("ResumeCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResumeClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resumeClusterRequest));
            CompletableFuture<ResumeClusterResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2
     * security group. To add an ingress rule, see <a>AuthorizeClusterSecurityGroupIngress</a>. For information about
     * managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param revokeClusterSecurityGroupIngressRequest
     * @return A Java Future containing the result of the RevokeClusterSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or EC2 security group is not authorized
     *         for the specified cluster security group.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RevokeClusterSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeClusterSecurityGroupIngressResponse> revokeClusterSecurityGroupIngress(
            RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeClusterSecurityGroupIngressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                revokeClusterSecurityGroupIngressRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeClusterSecurityGroupIngress");

            HttpResponseHandler<RevokeClusterSecurityGroupIngressResponse> responseHandler = protocolFactory
                    .createResponseHandler(RevokeClusterSecurityGroupIngressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RevokeClusterSecurityGroupIngressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeClusterSecurityGroupIngressRequest, RevokeClusterSecurityGroupIngressResponse>()
                            .withOperationName("RevokeClusterSecurityGroupIngress").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeClusterSecurityGroupIngressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeClusterSecurityGroupIngressRequest));
            CompletableFuture<RevokeClusterSecurityGroupIngressResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes access to a cluster.
     * </p>
     *
     * @param revokeEndpointAccessRequest
     * @return A Java Future containing the result of the RevokeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>EndpointAuthorizationNotFoundException The authorization for this endpoint can't be found.</li>
     *         <li>InvalidAuthorizationStateException The status of the authorization is not valid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RevokeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeEndpointAccessResponse> revokeEndpointAccess(
            RevokeEndpointAccessRequest revokeEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeEndpointAccess");

            HttpResponseHandler<RevokeEndpointAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(RevokeEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RevokeEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeEndpointAccessRequest, RevokeEndpointAccessResponse>()
                            .withOperationName("RevokeEndpointAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeEndpointAccessRequest));
            CompletableFuture<RevokeEndpointAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the
     * account is currently restoring the snapshot, the restore will run to completion.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param revokeSnapshotAccessRequest
     * @return A Java Future containing the result of the RevokeSnapshotAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or EC2 security group is not authorized
     *         for the specified cluster security group.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RevokeSnapshotAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeSnapshotAccessResponse> revokeSnapshotAccess(
            RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeSnapshotAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeSnapshotAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeSnapshotAccess");

            HttpResponseHandler<RevokeSnapshotAccessResponse> responseHandler = protocolFactory
                    .createResponseHandler(RevokeSnapshotAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RevokeSnapshotAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeSnapshotAccessRequest, RevokeSnapshotAccessResponse>()
                            .withOperationName("RevokeSnapshotAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RevokeSnapshotAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeSnapshotAccessRequest));
            CompletableFuture<RevokeSnapshotAccessResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Rotates the encryption keys for a cluster.
     * </p>
     *
     * @param rotateEncryptionKeyRequest
     * @return A Java Future containing the result of the RotateEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.RotateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RotateEncryptionKeyResponse> rotateEncryptionKey(
            RotateEncryptionKeyRequest rotateEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rotateEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rotateEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RotateEncryptionKey");

            HttpResponseHandler<RotateEncryptionKeyResponse> responseHandler = protocolFactory
                    .createResponseHandler(RotateEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<RotateEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RotateEncryptionKeyRequest, RotateEncryptionKeyResponse>()
                            .withOperationName("RotateEncryptionKey").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RotateEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rotateEncryptionKeyRequest));
            CompletableFuture<RotateEncryptionKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a partner integration.
     * </p>
     *
     * @param updatePartnerStatusRequest
     * @return A Java Future containing the result of the UpdatePartnerStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.UpdatePartnerStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/UpdatePartnerStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePartnerStatusResponse> updatePartnerStatus(
            UpdatePartnerStatusRequest updatePartnerStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePartnerStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePartnerStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Redshift");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePartnerStatus");

            HttpResponseHandler<UpdatePartnerStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(UpdatePartnerStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();

            CompletableFuture<UpdatePartnerStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePartnerStatusRequest, UpdatePartnerStatusResponse>()
                            .withOperationName("UpdatePartnerStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdatePartnerStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePartnerStatusRequest));
            CompletableFuture<UpdatePartnerStatusResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            return CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public RedshiftAsyncWaiter waiter() {
        return RedshiftAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final RedshiftServiceClientConfiguration serviceClientConfiguration() {
        return new RedshiftServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHsmConfigurationStateFault")
                                .exceptionBuilderSupplier(InvalidHsmConfigurationStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotScheduleAlreadyExists")
                                .exceptionBuilderSupplier(SnapshotScheduleAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotScheduleQuotaExceeded")
                                .exceptionBuilderSupplier(SnapshotScheduleQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubscriptionStateFault")
                                .exceptionBuilderSupplier(InvalidSubscriptionStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedPartnerIntegration")
                                .exceptionBuilderSupplier(UnauthorizedPartnerIntegrationException::builder).httpStatusCode(401)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUsageLimit")
                                .exceptionBuilderSupplier(InvalidUsageLimitException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationNotFoundFault")
                                .exceptionBuilderSupplier(IntegrationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRestore")
                                .exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(406).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyDisabledFault")
                                .exceptionBuilderSupplier(SnapshotCopyDisabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeExchangeNotFond")
                                .exceptionBuilderSupplier(ReservedNodeExchangeNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationQuotaExceeded")
                                .exceptionBuilderSupplier(RedshiftIdcApplicationQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSubnetGroupQuotaExceeded")
                                .exceptionBuilderSupplier(ClusterSubnetGroupQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("Ipv6CidrBlockNotFoundFault")
                                .exceptionBuilderSupplier(Ipv6CidrBlockNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSchedule")
                                .exceptionBuilderSupplier(InvalidScheduleException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependentServiceRequestThrottlingFault")
                                .exceptionBuilderSupplier(DependentServiceRequestThrottlingException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault")
                                .exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationNotExists")
                                .exceptionBuilderSupplier(RedshiftIdcApplicationNotExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BucketNotFoundFault")
                                .exceptionBuilderSupplier(BucketNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededFault")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAlreadyExists")
                                .exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PartnerNotFound")
                                .exceptionBuilderSupplier(PartnerNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScheduledActionQuotaExceeded")
                                .exceptionBuilderSupplier(ScheduledActionQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTableRestoreArgument")
                                .exceptionBuilderSupplier(InvalidTableRestoreArgumentException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyGrantAlreadyExistsFault")
                                .exceptionBuilderSupplier(SnapshotCopyGrantAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyGrantQuotaExceededFault")
                                .exceptionBuilderSupplier(SnapshotCopyGrantQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterNotFound")
                                .exceptionBuilderSupplier(ClusterNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterQuotaExceeded")
                                .exceptionBuilderSupplier(ClusterQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperation")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationConflictOperationFault")
                                .exceptionBuilderSupplier(IntegrationConflictOperationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScheduledActionAlreadyExists")
                                .exceptionBuilderSupplier(ScheduledActionAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterState")
                                .exceptionBuilderSupplier(InvalidClusterStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSubnetQuotaExceededFault")
                                .exceptionBuilderSupplier(ClusterSubnetQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterParameterGroupState")
                                .exceptionBuilderSupplier(InvalidClusterParameterGroupStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSubnetGroupNotFoundFault")
                                .exceptionBuilderSupplier(ClusterSubnetGroupNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyDisabledFault")
                                .exceptionBuilderSupplier(SnapshotCopyAlreadyDisabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSnapshotQuotaExceeded")
                                .exceptionBuilderSupplier(ClusterSnapshotQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependentServiceAccessDenied")
                                .exceptionBuilderSupplier(DependentServiceAccessDeniedException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(EndpointAuthorizationAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterAlreadyExists")
                                .exceptionBuilderSupplier(ClusterAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictPolicyUpdateFault")
                                .exceptionBuilderSupplier(ConflictPolicyUpdateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound")
                                .exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NumberOfNodesQuotaExceeded")
                                .exceptionBuilderSupplier(NumberOfNodesQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSecurityGroupAlreadyExists")
                                .exceptionBuilderSupplier(ClusterSecurityGroupAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationQuotaExceeded")
                                .exceptionBuilderSupplier(AuthorizationQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeOfferingNotFound")
                                .exceptionBuilderSupplier(ReservedNodeOfferingNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointNotFound")
                                .exceptionBuilderSupplier(EndpointNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InProgressTableRestoreQuotaExceededFault")
                                .exceptionBuilderSupplier(InProgressTableRestoreQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessToSnapshotDenied")
                                .exceptionBuilderSupplier(AccessToSnapshotDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidElasticIpFault")
                                .exceptionBuilderSupplier(InvalidElasticIpException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResizeNotFound")
                                .exceptionBuilderSupplier(ResizeNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScheduleDefinitionTypeUnsupported")
                                .exceptionBuilderSupplier(ScheduleDefinitionTypeUnsupportedException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagFault")
                                .exceptionBuilderSupplier(InvalidTagException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmClientCertificateAlreadyExistsFault")
                                .exceptionBuilderSupplier(HsmClientCertificateAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScheduledActionTypeUnsupported")
                                .exceptionBuilderSupplier(ScheduledActionTypeUnsupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterParameterGroupQuotaExceeded")
                                .exceptionBuilderSupplier(ClusterParameterGroupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyFault")
                                .exceptionBuilderSupplier(InvalidPolicyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedOperation")
                                .exceptionBuilderSupplier(UnauthorizedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthenticationProfileNotFoundFault")
                                .exceptionBuilderSupplier(AuthenticationProfileNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotScheduleNotFound")
                                .exceptionBuilderSupplier(SnapshotScheduleNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyExists")
                                .exceptionBuilderSupplier(ReservedNodeAlreadyExistsException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3BucketNameFault")
                                .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOptionFault")
                                .exceptionBuilderSupplier(UnsupportedOptionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientClusterCapacity")
                                .exceptionBuilderSupplier(InsufficientClusterCapacityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSubnetGroupAlreadyExists")
                                .exceptionBuilderSupplier(ClusterSubnetGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TagLimitExceededFault")
                                .exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotState")
                                .exceptionBuilderSupplier(InvalidClusterSnapshotStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyFault")
                                .exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchDeleteRequestSizeExceeded")
                                .exceptionBuilderSupplier(BatchDeleteRequestSizeExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixFault")
                                .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationNotFound")
                                .exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationSourceNotFoundFault")
                                .exceptionBuilderSupplier(IntegrationSourceNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ScheduledActionNotFound")
                                .exceptionBuilderSupplier(ScheduledActionNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionEventIdNotFound")
                                .exceptionBuilderSupplier(SubscriptionEventIdNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterSnapshotScheduleState")
                                .exceptionBuilderSupplier(InvalidClusterSnapshotScheduleStateException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAuthorizationNotFound")
                                .exceptionBuilderSupplier(EndpointAuthorizationNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterTrack")
                                .exceptionBuilderSupplier(InvalidClusterTrackException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionSeverityNotFound")
                                .exceptionBuilderSupplier(SubscriptionSeverityNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNamespaceFault")
                                .exceptionBuilderSupplier(InvalidNamespaceException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessToClusterDenied")
                                .exceptionBuilderSupplier(AccessToClusterDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CopyToRegionDisabledFault")
                                .exceptionBuilderSupplier(CopyToRegionDisabledException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound")
                                .exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationQuotaExceededFault")
                                .exceptionBuilderSupplier(IntegrationQuotaExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidEndpointState")
                                .exceptionBuilderSupplier(InvalidEndpointStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnknownSnapshotCopyRegionFault")
                                .exceptionBuilderSupplier(UnknownSnapshotCopyRegionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TableRestoreNotFoundFault")
                                .exceptionBuilderSupplier(TableRestoreNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmConfigurationQuotaExceededFault")
                                .exceptionBuilderSupplier(HsmConfigurationQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyGrantNotFoundFault")
                                .exceptionBuilderSupplier(SnapshotCopyGrantNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeAlreadyMigrated")
                                .exceptionBuilderSupplier(ReservedNodeAlreadyMigratedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmClientCertificateNotFoundFault")
                                .exceptionBuilderSupplier(HsmClientCertificateNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotCopyAlreadyEnabledFault")
                                .exceptionBuilderSupplier(SnapshotCopyAlreadyEnabledException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmConfigurationAlreadyExistsFault")
                                .exceptionBuilderSupplier(HsmConfigurationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomCnameAssociationFault")
                                .exceptionBuilderSupplier(CustomCnameAssociationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionNotFound")
                                .exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationTargetNotFoundFault")
                                .exceptionBuilderSupplier(IntegrationTargetNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidReservedNodeState")
                                .exceptionBuilderSupplier(InvalidReservedNodeStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomDomainAssociationNotFoundFault")
                                .exceptionBuilderSupplier(CustomDomainAssociationNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependentServiceUnavailableFault")
                                .exceptionBuilderSupplier(DependentServiceUnavailableException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationConflictStateFault")
                                .exceptionBuilderSupplier(IntegrationConflictStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IntegrationAlreadyExistsFault")
                                .exceptionBuilderSupplier(IntegrationAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthorizationState")
                                .exceptionBuilderSupplier(InvalidAuthorizationStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSecurityGroupNotFound")
                                .exceptionBuilderSupplier(ClusterSecurityGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmConfigurationNotFoundFault")
                                .exceptionBuilderSupplier(HsmConfigurationNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NumberOfNodesPerClusterLimitExceeded")
                                .exceptionBuilderSupplier(NumberOfNodesPerClusterLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthenticationProfileQuotaExceededFault")
                                .exceptionBuilderSupplier(AuthenticationProfileQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAuthorizationsPerClusterLimitExceeded")
                                .exceptionBuilderSupplier(EndpointAuthorizationsPerClusterLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSnapshotAlreadyExists")
                                .exceptionBuilderSupplier(ClusterSnapshotAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRetentionPeriodFault")
                                .exceptionBuilderSupplier(InvalidRetentionPeriodException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthenticationProfileAlreadyExistsFault")
                                .exceptionBuilderSupplier(AuthenticationProfileAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointsPerAuthorizationLimitExceeded")
                                .exceptionBuilderSupplier(EndpointsPerAuthorizationLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UsageLimitNotFound")
                                .exceptionBuilderSupplier(UsageLimitNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TableLimitExceeded")
                                .exceptionBuilderSupplier(TableLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapshotScheduleUpdateInProgress")
                                .exceptionBuilderSupplier(SnapshotScheduleUpdateInProgressException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSnapshotCopyGrantStateFault")
                                .exceptionBuilderSupplier(InvalidSnapshotCopyGrantStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSInvalidTopic")
                                .exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHsmClientCertificateStateFault")
                                .exceptionBuilderSupplier(InvalidHsmClientCertificateStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterSubnetGroupStateFault")
                                .exceptionBuilderSupplier(InvalidClusterSubnetGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterOnLatestRevision")
                                .exceptionBuilderSupplier(ClusterOnLatestRevisionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterSnapshotNotFound")
                                .exceptionBuilderSupplier(ClusterSnapshotNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDataShareFault")
                                .exceptionBuilderSupplier(InvalidDataShareException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchModifyClusterSnapshotsLimitExceededFault")
                                .exceptionBuilderSupplier(BatchModifyClusterSnapshotsLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HsmClientCertificateQuotaExceededFault")
                                .exceptionBuilderSupplier(HsmClientCertificateQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterSecurityGroupState")
                                .exceptionBuilderSupplier(InvalidClusterSecurityGroupStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeQuotaExceeded")
                                .exceptionBuilderSupplier(ReservedNodeQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthenticationProfileRequestFault")
                                .exceptionBuilderSupplier(InvalidAuthenticationProfileRequestException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSNoAuthorization")
                                .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidClusterSubnetStateFault")
                                .exceptionBuilderSupplier(InvalidClusterSubnetStateException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist")
                                .exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNodeNotFound")
                                .exceptionBuilderSupplier(ReservedNodeNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidScheduledAction")
                                .exceptionBuilderSupplier(InvalidScheduledActionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleOrderableOptions")
                                .exceptionBuilderSupplier(IncompatibleOrderableOptionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RedshiftIdcApplicationAlreadyExists")
                                .exceptionBuilderSupplier(RedshiftIdcApplicationAlreadyExistsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointsPerClusterLimitExceeded")
                                .exceptionBuilderSupplier(EndpointsPerClusterLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UsageLimitAlreadyExists")
                                .exceptionBuilderSupplier(UsageLimitAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SourceNotFound")
                                .exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterParameterGroupNotFound")
                                .exceptionBuilderSupplier(ClusterParameterGroupNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuotaExceeded.ClusterSecurityGroup")
                                .exceptionBuilderSupplier(ClusterSecurityGroupQuotaExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded")
                                .exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AuthorizationAlreadyExists")
                                .exceptionBuilderSupplier(AuthorizationAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ClusterParameterGroupAlreadyExists")
                                .exceptionBuilderSupplier(ClusterParameterGroupAlreadyExistsException::builder)
                                .httpStatusCode(400).build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(RedshiftException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        RedshiftServiceClientConfigurationBuilder serviceConfigBuilder = new RedshiftServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
