/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreFromClusterSnapshotRequest extends RedshiftRequest implements
        ToCopyableBuilder<RestoreFromClusterSnapshotRequest.Builder, RestoreFromClusterSnapshotRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(RestoreFromClusterSnapshotRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(RestoreFromClusterSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotArn").getter(getter(RestoreFromClusterSnapshotRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()).build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotClusterIdentifier").getter(getter(RestoreFromClusterSnapshotRequest::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreFromClusterSnapshotRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(RestoreFromClusterSnapshotRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowVersionUpgrade").getter(getter(RestoreFromClusterSnapshotRequest::allowVersionUpgrade))
            .setter(setter(Builder::allowVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build())
            .build();

    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSubnetGroupName").getter(getter(RestoreFromClusterSnapshotRequest::clusterSubnetGroupName))
            .setter(setter(Builder::clusterSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(RestoreFromClusterSnapshotRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(RestoreFromClusterSnapshotRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmClientCertificateIdentifier")
            .getter(getter(RestoreFromClusterSnapshotRequest::hsmClientCertificateIdentifier))
            .setter(setter(Builder::hsmClientCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmConfigurationIdentifier")
            .getter(getter(RestoreFromClusterSnapshotRequest::hsmConfigurationIdentifier))
            .setter(setter(Builder::hsmConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build())
            .build();

    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticIp").getter(getter(RestoreFromClusterSnapshotRequest::elasticIp))
            .setter(setter(Builder::elasticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()).build();

    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterParameterGroupName").getter(getter(RestoreFromClusterSnapshotRequest::clusterParameterGroupName))
            .setter(setter(Builder::clusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupName").build())
            .build();

    private static final SdkField<List<String>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClusterSecurityGroups")
            .getter(getter(RestoreFromClusterSnapshotRequest::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreFromClusterSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(RestoreFromClusterSnapshotRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomatedSnapshotRetentionPeriod")
            .getter(getter(RestoreFromClusterSnapshotRequest::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRetentionPeriod")
            .getter(getter(RestoreFromClusterSnapshotRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreFromClusterSnapshotRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(RestoreFromClusterSnapshotRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnhancedVpcRouting").getter(getter(RestoreFromClusterSnapshotRequest::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo").getter(getter(RestoreFromClusterSnapshotRequest::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()).build();

    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IamRoles")
            .getter(getter(RestoreFromClusterSnapshotRequest::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IamRoleArn")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IamRoleArn").build()).build()).build()).build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceTrackName").getter(getter(RestoreFromClusterSnapshotRequest::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotScheduleIdentifier")
            .getter(getter(RestoreFromClusterSnapshotRequest::snapshotScheduleIdentifier))
            .setter(setter(Builder::snapshotScheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(RestoreFromClusterSnapshotRequest::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<Boolean> AVAILABILITY_ZONE_RELOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvailabilityZoneRelocation")
            .getter(getter(RestoreFromClusterSnapshotRequest::availabilityZoneRelocation))
            .setter(setter(Builder::availabilityZoneRelocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneRelocation").build())
            .build();

    private static final SdkField<String> AQUA_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AquaConfigurationStatus")
            .getter(getter(RestoreFromClusterSnapshotRequest::aquaConfigurationStatusAsString))
            .setter(setter(Builder::aquaConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfigurationStatus").build())
            .build();

    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultIamRoleArn").getter(getter(RestoreFromClusterSnapshotRequest::defaultIamRoleArn))
            .setter(setter(Builder::defaultIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultIamRoleArn").build()).build();

    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeId").getter(getter(RestoreFromClusterSnapshotRequest::reservedNodeId))
            .setter(setter(Builder::reservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()).build();

    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetReservedNodeOfferingId")
            .getter(getter(RestoreFromClusterSnapshotRequest::targetReservedNodeOfferingId))
            .setter(setter(Builder::targetReservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId")
                    .build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(RestoreFromClusterSnapshotRequest::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_PASSWORD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManageMasterPassword").getter(getter(RestoreFromClusterSnapshotRequest::manageMasterPassword))
            .setter(setter(Builder::manageMasterPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterPassword").build())
            .build();

    private static final SdkField<String> MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MasterPasswordSecretKmsKeyId")
            .getter(getter(RestoreFromClusterSnapshotRequest::masterPasswordSecretKmsKeyId))
            .setter(setter(Builder::masterPasswordSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPasswordSecretKmsKeyId")
                    .build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(RestoreFromClusterSnapshotRequest::ipAddressType))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(RestoreFromClusterSnapshotRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, PORT_FIELD,
            AVAILABILITY_ZONE_FIELD, ALLOW_VERSION_UPGRADE_FIELD, CLUSTER_SUBNET_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            OWNER_ACCOUNT_FIELD, HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, ELASTIC_IP_FIELD,
            CLUSTER_PARAMETER_GROUP_NAME_FIELD, CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD,
            MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, KMS_KEY_ID_FIELD, NODE_TYPE_FIELD, ENHANCED_VPC_ROUTING_FIELD,
            ADDITIONAL_INFO_FIELD, IAM_ROLES_FIELD, MAINTENANCE_TRACK_NAME_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD,
            NUMBER_OF_NODES_FIELD, AVAILABILITY_ZONE_RELOCATION_FIELD, AQUA_CONFIGURATION_STATUS_FIELD,
            DEFAULT_IAM_ROLE_ARN_FIELD, RESERVED_NODE_ID_FIELD, TARGET_RESERVED_NODE_OFFERING_ID_FIELD, ENCRYPTED_FIELD,
            MANAGE_MASTER_PASSWORD_FIELD, MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD, IP_ADDRESS_TYPE_FIELD, MULTI_AZ_FIELD));

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String snapshotArn;

    private final String snapshotClusterIdentifier;

    private final Integer port;

    private final String availabilityZone;

    private final Boolean allowVersionUpgrade;

    private final String clusterSubnetGroupName;

    private final Boolean publiclyAccessible;

    private final String ownerAccount;

    private final String hsmClientCertificateIdentifier;

    private final String hsmConfigurationIdentifier;

    private final String elasticIp;

    private final String clusterParameterGroupName;

    private final List<String> clusterSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String preferredMaintenanceWindow;

    private final Integer automatedSnapshotRetentionPeriod;

    private final Integer manualSnapshotRetentionPeriod;

    private final String kmsKeyId;

    private final String nodeType;

    private final Boolean enhancedVpcRouting;

    private final String additionalInfo;

    private final List<String> iamRoles;

    private final String maintenanceTrackName;

    private final String snapshotScheduleIdentifier;

    private final Integer numberOfNodes;

    private final Boolean availabilityZoneRelocation;

    private final String aquaConfigurationStatus;

    private final String defaultIamRoleArn;

    private final String reservedNodeId;

    private final String targetReservedNodeOfferingId;

    private final Boolean encrypted;

    private final Boolean manageMasterPassword;

    private final String masterPasswordSecretKmsKeyId;

    private final String ipAddressType;

    private final Boolean multiAZ;

    private RestoreFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.ownerAccount = builder.ownerAccount;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.elasticIp = builder.elasticIp;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.nodeType = builder.nodeType;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.additionalInfo = builder.additionalInfo;
        this.iamRoles = builder.iamRoles;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.numberOfNodes = builder.numberOfNodes;
        this.availabilityZoneRelocation = builder.availabilityZoneRelocation;
        this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
        this.encrypted = builder.encrypted;
        this.manageMasterPassword = builder.manageMasterPassword;
        this.masterPasswordSecretKmsKeyId = builder.masterPasswordSecretKmsKeyId;
        this.ipAddressType = builder.ipAddressType;
        this.multiAZ = builder.multiAZ;
    }

    /**
     * <p>
     * The identifier of the cluster that will be created from restoring the snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Alphabetic characters must be lowercase.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be unique for all clusters within an Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the cluster that will be created from restoring the snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alphabetic characters must be lowercase.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be unique for all clusters within an Amazon Web Services account.
     *         </p>
     *         </li>
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. You must
     * specify this parameter or <code>snapshotArn</code>, but not both.
     * </p>
     * <p>
     * Example: <code>my-snapshot-id</code>
     * </p>
     * 
     * @return The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. You
     *         must specify this parameter or <code>snapshotArn</code>, but not both.</p>
     *         <p>
     *         Example: <code>my-snapshot-id</code>
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster. You must
     * specify this parameter or <code>snapshotIdentifier</code>, but not both.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster. You
     *         must specify this parameter or <code>snapshotIdentifier</code>, but not both.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a
     * policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * </p>
     * 
     * @return The name of the cluster the source snapshot was created from. This parameter is required if your IAM user
     *         has a policy containing a snapshot resource element that specifies anything other than * for the cluster
     *         name.
     */
    public final String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The port number on which the cluster accepts connections.
     * </p>
     * <p>
     * Default: The same port as the original cluster.
     * </p>
     * <p>
     * Valid values: For clusters with DC2 nodes, must be within the range <code>1150</code>-<code>65535</code>. For
     * clusters with ra3 nodes, must be within the ranges <code>5431</code>-<code>5455</code> or <code>8191</code>-
     * <code>8215</code>.
     * </p>
     * 
     * @return The port number on which the cluster accepts connections.</p>
     *         <p>
     *         Default: The same port as the original cluster.
     *         </p>
     *         <p>
     *         Valid values: For clusters with DC2 nodes, must be within the range <code>1150</code>-<code>65535</code>.
     *         For clusters with ra3 nodes, must be within the ranges <code>5431</code>-<code>5455</code> or
     *         <code>8191</code>-<code>8215</code>.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The Amazon EC2 Availability Zone in which to restore the cluster.
     * </p>
     * <p>
     * Default: A random, system-chosen Availability Zone.
     * </p>
     * <p>
     * Example: <code>us-east-2a</code>
     * </p>
     * 
     * @return The Amazon EC2 Availability Zone in which to restore the cluster.</p>
     *         <p>
     *         Default: A random, system-chosen Availability Zone.
     *         </p>
     *         <p>
     *         Example: <code>us-east-2a</code>
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift
     * engine that is running on the cluster.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon
     *         Redshift engine that is running on the cluster. </p>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean allowVersionUpgrade() {
        return allowVersionUpgrade;
    }

    /**
     * <p>
     * The name of the subnet group where you want to cluster restored.
     * </p>
     * <p>
     * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you
     * want the cluster restored.
     * </p>
     * 
     * @return The name of the subnet group where you want to cluster restored.</p>
     *         <p>
     *         A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name
     *         where you want the cluster restored.
     */
    public final String clusterSubnetGroupName() {
        return clusterSubnetGroupName;
    }

    /**
     * <p>
     * If <code>true</code>, the cluster can be accessed from a public network.
     * </p>
     * 
     * @return If <code>true</code>, the cluster can be accessed from a public network.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you
     * do not own, optional if you own the snapshot.
     * </p>
     * 
     * @return The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a
     *         snapshot you do not own, optional if you own the snapshot.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption
     * keys stored in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
     *         encryption keys stored in an HSM.
     */
    public final String hsmClientCertificateIdentifier() {
        return hsmClientCertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to
     * retrieve and store keys in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can
     *         use to retrieve and store keys in an HSM.
     */
    public final String hsmConfigurationIdentifier() {
        return hsmConfigurationIdentifier;
    }

    /**
     * <p>
     * The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly accessible
     * cluster with availability zone relocation turned on.
     * </p>
     * 
     * @return The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly
     *         accessible cluster with availability zone relocation turned on.
     */
    public final String elasticIp() {
        return elasticIp;
    }

    /**
     * <p>
     * The name of the parameter group to be associated with this cluster.
     * </p>
     * <p>
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group,
     * go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
     * Amazon Redshift Parameter Groups</a>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the parameter group to be associated with this cluster.</p>
     *         <p>
     *         Default: The default Amazon Redshift cluster parameter group. For information about the default parameter
     *         group, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
     *         Amazon Redshift Parameter Groups</a>.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String clusterParameterGroupName() {
        return clusterParameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterSecurityGroups() {
        return clusterSecurityGroups != null && !(clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security groups to be associated with this cluster.
     * </p>
     * <p>
     * Default: The default cluster security group for Amazon Redshift.
     * </p>
     * <p>
     * Cluster security groups only apply to clusters outside of VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSecurityGroups} method.
     * </p>
     * 
     * @return A list of security groups to be associated with this cluster.</p>
     *         <p>
     *         Default: The default cluster security group for Amazon Redshift.
     *         </p>
     *         <p>
     *         Cluster security groups only apply to clusters outside of VPCs.
     */
    public final List<String> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     * </p>
     * <p>
     * Default: The default VPC security group is associated with the cluster.
     * </p>
     * <p>
     * VPC security groups only apply to clusters in VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
     *         <p>
     *         Default: The default VPC security group is associated with the cluster.
     *         </p>
     *         <p>
     *         VPC security groups only apply to clusters in VPCs.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     * </p>
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * </p>
     * <p>
     * Default: The value selected for the cluster from which the snapshot was taken. For more information about the
     * time blocks for each region, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
     * >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Minimum 30-minute window.
     * </p>
     * 
     * @return The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
     *         <p>
     *         Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     *         </p>
     *         <p>
     *         Default: The value selected for the cluster from which the snapshot was taken. For more information about
     *         the time blocks for each region, see <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
     *         >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Minimum 30-minute window.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled.
     * Even if automated snapshots are disabled, you can still create manual snapshots when you want with
     * <a>CreateClusterSnapshot</a>.
     * </p>
     * <p>
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     * </p>
     * <p>
     * Default: The value selected for the cluster from which the snapshot was taken.
     * </p>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     * </p>
     * 
     * @return The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
     *         disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want
     *         with <a>CreateClusterSnapshot</a>. </p>
     *         <p>
     *         You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35
     *         days.
     *         </p>
     *         <p>
     *         Default: The value selected for the cluster from which the snapshot was taken.
     *         </p>
     *         <p>
     *         Constraints: Must be a value from 0 to 35.
     */
    public final Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     * indefinitely. This setting doesn't change the retention period of existing snapshots.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     *         indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public final Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored from a
     * shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an encrypted
     * cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from an encrypted
     * snapshot in the same account in order to change it. In that case, the restored cluster is encrypted with the new
     * KMS key ID.
     * </p>
     * 
     * @return The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored
     *         from a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to
     *         an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore
     *         from an encrypted snapshot in the same account in order to change it. In that case, the restored cluster
     *         is encrypted with the new KMS key ID.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The node type that the restored cluster will be provisioned with.
     * </p>
     * <p>
     * If you have a DC instance type, you must restore into that same instance type and size. In other words, you can
     * only restore a dc2.large node type into another dc2 type. For more information about node types, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
     * About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * 
     * @return The node type that the restored cluster will be provisioned with.</p>
     *         <p>
     *         If you have a DC instance type, you must restore into that same instance type and size. In other words,
     *         you can only restore a dc2.large node type into another dc2 type. For more information about node types,
     *         see <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"
     *         > About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
     *         Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamRoles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web
     * Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     * </p>
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the
     * <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamRoles} method.
     * </p>
     * 
     * @return A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
     *         Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     *         </p>
     *         <p>
     *         The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to
     *         <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and
     *         limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     */
    public final List<String> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the
     * <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the cluster
     * that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the
     * current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source
     * cluster are on different tracks.
     * </p>
     * 
     * @return The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot
     *         inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different
     *         track than the cluster that was the source for the snapshot. For example, suppose that you take a
     *         snapshot of a cluster that is on the current track and then change the cluster to be on the trailing
     *         track. In this case, the snapshot and the source cluster are on different tracks.
     */
    public final String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * A unique identifier for the snapshot schedule.
     * </p>
     * 
     * @return A unique identifier for the snapshot schedule.
     */
    public final String snapshotScheduleIdentifier() {
        return snapshotScheduleIdentifier;
    }

    /**
     * <p>
     * The number of nodes specified when provisioning the restored cluster.
     * </p>
     * 
     * @return The number of nodes specified when provisioning the restored cluster.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is
     * restored.
     * </p>
     * 
     * @return The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the
     *         cluster is restored.
     */
    public final Boolean availabilityZoneRelocation() {
        return availabilityZoneRelocation;
    }

    /**
     * <p>
     * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
     * determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
     *         determines whether to use AQUA (Advanced Query Accelerator).
     * @see AquaConfigurationStatus
     */
    public final AquaConfigurationStatus aquaConfigurationStatus() {
        return AquaConfigurationStatus.fromValue(aquaConfigurationStatus);
    }

    /**
     * <p>
     * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
     * determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
     *         determines whether to use AQUA (Advanced Query Accelerator).
     * @see AquaConfigurationStatus
     */
    public final String aquaConfigurationStatusAsString() {
        return aquaConfigurationStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last
     * modified while it was restored from a snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster
     *         was last modified while it was restored from a snapshot.
     */
    public final String defaultIamRoleArn() {
        return defaultIamRoleArn;
    }

    /**
     * <p>
     * The identifier of the target reserved node offering.
     * </p>
     * 
     * @return The identifier of the target reserved node offering.
     */
    public final String reservedNodeId() {
        return reservedNodeId;
    }

    /**
     * <p>
     * The identifier of the target reserved node offering.
     * </p>
     * 
     * @return The identifier of the target reserved node offering.
     */
    public final String targetReservedNodeOfferingId() {
        return targetReservedNodeOfferingId;
    }

    /**
     * <p>
     * Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service (KMS)
     * and a customer managed key.
     * </p>
     * 
     * @return Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service
     *         (KMS) and a customer managed key.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin credentials. If
     * <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses the admin credentials the cluster had
     * at the time the snapshot was taken.
     * </p>
     * 
     * @return If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin
     *         credentials. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses the admin
     *         credentials the cluster had at the time the snapshot was taken.
     */
    public final Boolean manageMasterPassword() {
        return manageMasterPassword;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
     * You can only use this parameter if <code>ManageMasterPassword</code> is true.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
     *         secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
     */
    public final String masterPasswordSecretKmsKeyId() {
        return masterPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The IP address type for the cluster. Possible values are <code>ipv4</code> and <code>dualstack</code>.
     * </p>
     * 
     * @return The IP address type for the cluster. Possible values are <code>ipv4</code> and <code>dualstack</code>.
     */
    public final String ipAddressType() {
        return ipAddressType;
    }

    /**
     * <p>
     * If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
     * </p>
     * 
     * @return If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterSecurityGroups() ? clusterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasIamRoles() ? iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneRelocation());
        hashCode = 31 * hashCode + Objects.hashCode(aquaConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreFromClusterSnapshotRequest other = (RestoreFromClusterSnapshotRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(allowVersionUpgrade(), other.allowVersionUpgrade())
                && Objects.equals(clusterSubnetGroupName(), other.clusterSubnetGroupName())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier())
                && Objects.equals(hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier())
                && Objects.equals(elasticIp(), other.elasticIp())
                && Objects.equals(clusterParameterGroupName(), other.clusterParameterGroupName())
                && hasClusterSecurityGroups() == other.hasClusterSecurityGroups()
                && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(additionalInfo(), other.additionalInfo()) && hasIamRoles() == other.hasIamRoles()
                && Objects.equals(iamRoles(), other.iamRoles())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(availabilityZoneRelocation(), other.availabilityZoneRelocation())
                && Objects.equals(aquaConfigurationStatusAsString(), other.aquaConfigurationStatusAsString())
                && Objects.equals(defaultIamRoleArn(), other.defaultIamRoleArn())
                && Objects.equals(reservedNodeId(), other.reservedNodeId())
                && Objects.equals(targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId())
                && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(manageMasterPassword(), other.manageMasterPassword())
                && Objects.equals(masterPasswordSecretKmsKeyId(), other.masterPasswordSecretKmsKeyId())
                && Objects.equals(ipAddressType(), other.ipAddressType()) && Objects.equals(multiAZ(), other.multiAZ());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreFromClusterSnapshotRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("SnapshotIdentifier", snapshotIdentifier()).add("SnapshotArn", snapshotArn())
                .add("SnapshotClusterIdentifier", snapshotClusterIdentifier()).add("Port", port())
                .add("AvailabilityZone", availabilityZone()).add("AllowVersionUpgrade", allowVersionUpgrade())
                .add("ClusterSubnetGroupName", clusterSubnetGroupName()).add("PubliclyAccessible", publiclyAccessible())
                .add("OwnerAccount", ownerAccount()).add("HsmClientCertificateIdentifier", hsmClientCertificateIdentifier())
                .add("HsmConfigurationIdentifier", hsmConfigurationIdentifier()).add("ElasticIp", elasticIp())
                .add("ClusterParameterGroupName", clusterParameterGroupName())
                .add("ClusterSecurityGroups", hasClusterSecurityGroups() ? clusterSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod()).add("KmsKeyId", kmsKeyId())
                .add("NodeType", nodeType()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("AdditionalInfo", additionalInfo()).add("IamRoles", hasIamRoles() ? iamRoles() : null)
                .add("MaintenanceTrackName", maintenanceTrackName())
                .add("SnapshotScheduleIdentifier", snapshotScheduleIdentifier()).add("NumberOfNodes", numberOfNodes())
                .add("AvailabilityZoneRelocation", availabilityZoneRelocation())
                .add("AquaConfigurationStatus", aquaConfigurationStatusAsString()).add("DefaultIamRoleArn", defaultIamRoleArn())
                .add("ReservedNodeId", reservedNodeId()).add("TargetReservedNodeOfferingId", targetReservedNodeOfferingId())
                .add("Encrypted", encrypted()).add("ManageMasterPassword", manageMasterPassword())
                .add("MasterPasswordSecretKmsKeyId", masterPasswordSecretKmsKeyId()).add("IpAddressType", ipAddressType())
                .add("MultiAZ", multiAZ()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AllowVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowVersionUpgrade()));
        case "ClusterSubnetGroupName":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroupName()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "HsmClientCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(hsmClientCertificateIdentifier()));
        case "HsmConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(hsmConfigurationIdentifier()));
        case "ElasticIp":
            return Optional.ofNullable(clazz.cast(elasticIp()));
        case "ClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(clusterParameterGroupName()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "IamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "SnapshotScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotScheduleIdentifier()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "AvailabilityZoneRelocation":
            return Optional.ofNullable(clazz.cast(availabilityZoneRelocation()));
        case "AquaConfigurationStatus":
            return Optional.ofNullable(clazz.cast(aquaConfigurationStatusAsString()));
        case "DefaultIamRoleArn":
            return Optional.ofNullable(clazz.cast(defaultIamRoleArn()));
        case "ReservedNodeId":
            return Optional.ofNullable(clazz.cast(reservedNodeId()));
        case "TargetReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(targetReservedNodeOfferingId()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "ManageMasterPassword":
            return Optional.ofNullable(clazz.cast(manageMasterPassword()));
        case "MasterPasswordSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterPasswordSecretKmsKeyId()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromClusterSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreFromClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreFromClusterSnapshotRequest> {
        /**
         * <p>
         * The identifier of the cluster that will be created from restoring the snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Alphabetic characters must be lowercase.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be unique for all clusters within an Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster that will be created from restoring the snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alphabetic characters must be lowercase.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be unique for all clusters within an Amazon Web Services account.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. You must
         * specify this parameter or <code>snapshotArn</code>, but not both.
         * </p>
         * <p>
         * Example: <code>my-snapshot-id</code>
         * </p>
         * 
         * @param snapshotIdentifier
         *        The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.
         *        You must specify this parameter or <code>snapshotArn</code>, but not both.</p>
         *        <p>
         *        Example: <code>my-snapshot-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster. You
         * must specify this parameter or <code>snapshotIdentifier</code>, but not both.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster.
         *        You must specify this parameter or <code>snapshotIdentifier</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has
         * a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         * </p>
         * 
         * @param snapshotClusterIdentifier
         *        The name of the cluster the source snapshot was created from. This parameter is required if your IAM
         *        user has a policy containing a snapshot resource element that specifies anything other than * for the
         *        cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);

        /**
         * <p>
         * The port number on which the cluster accepts connections.
         * </p>
         * <p>
         * Default: The same port as the original cluster.
         * </p>
         * <p>
         * Valid values: For clusters with DC2 nodes, must be within the range <code>1150</code>-<code>65535</code>. For
         * clusters with ra3 nodes, must be within the ranges <code>5431</code>-<code>5455</code> or <code>8191</code>-
         * <code>8215</code>.
         * </p>
         * 
         * @param port
         *        The port number on which the cluster accepts connections.</p>
         *        <p>
         *        Default: The same port as the original cluster.
         *        </p>
         *        <p>
         *        Valid values: For clusters with DC2 nodes, must be within the range <code>1150</code>-
         *        <code>65535</code>. For clusters with ra3 nodes, must be within the ranges <code>5431</code>-
         *        <code>5455</code> or <code>8191</code>-<code>8215</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Amazon EC2 Availability Zone in which to restore the cluster.
         * </p>
         * <p>
         * Default: A random, system-chosen Availability Zone.
         * </p>
         * <p>
         * Example: <code>us-east-2a</code>
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon EC2 Availability Zone in which to restore the cluster.</p>
         *        <p>
         *        Default: A random, system-chosen Availability Zone.
         *        </p>
         *        <p>
         *        Example: <code>us-east-2a</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon
         * Redshift engine that is running on the cluster.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param allowVersionUpgrade
         *        If <code>true</code>, major version upgrades can be applied during the maintenance window to the
         *        Amazon Redshift engine that is running on the cluster. </p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowVersionUpgrade(Boolean allowVersionUpgrade);

        /**
         * <p>
         * The name of the subnet group where you want to cluster restored.
         * </p>
         * <p>
         * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where
         * you want the cluster restored.
         * </p>
         * 
         * @param clusterSubnetGroupName
         *        The name of the subnet group where you want to cluster restored.</p>
         *        <p>
         *        A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group
         *        name where you want the cluster restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroupName(String clusterSubnetGroupName);

        /**
         * <p>
         * If <code>true</code>, the cluster can be accessed from a public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        If <code>true</code>, the cluster can be accessed from a public network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot
         * you do not own, optional if you own the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a
         *        snapshot you do not own, optional if you own the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         * encryption keys stored in an HSM.
         * </p>
         * 
         * @param hsmClientCertificateIdentifier
         *        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         *        encryption keys stored in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier);

        /**
         * <p>
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use
         * to retrieve and store keys in an HSM.
         * </p>
         * 
         * @param hsmConfigurationIdentifier
         *        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster
         *        can use to retrieve and store keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier);

        /**
         * <p>
         * The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly accessible
         * cluster with availability zone relocation turned on.
         * </p>
         * 
         * @param elasticIp
         *        The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly
         *        accessible cluster with availability zone relocation turned on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        /**
         * <p>
         * The name of the parameter group to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter
         * group, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with
         * Amazon Redshift Parameter Groups</a>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterParameterGroupName
         *        The name of the parameter group to be associated with this cluster.</p>
         *        <p>
         *        Default: The default Amazon Redshift cluster parameter group. For information about the default
         *        parameter group, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working
         *        with Amazon Redshift Parameter Groups</a>.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroupName(String clusterParameterGroupName);

        /**
         * <p>
         * A list of security groups to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default cluster security group for Amazon Redshift.
         * </p>
         * <p>
         * Cluster security groups only apply to clusters outside of VPCs.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of security groups to be associated with this cluster.</p>
         *        <p>
         *        Default: The default cluster security group for Amazon Redshift.
         *        </p>
         *        <p>
         *        Cluster security groups only apply to clusters outside of VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups);

        /**
         * <p>
         * A list of security groups to be associated with this cluster.
         * </p>
         * <p>
         * Default: The default cluster security group for Amazon Redshift.
         * </p>
         * <p>
         * Cluster security groups only apply to clusters outside of VPCs.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of security groups to be associated with this cluster.</p>
         *        <p>
         *        Default: The default cluster security group for Amazon Redshift.
         *        </p>
         *        <p>
         *        Cluster security groups only apply to clusters outside of VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(String... clusterSecurityGroups);

        /**
         * <p>
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * </p>
         * <p>
         * Default: The default VPC security group is associated with the cluster.
         * </p>
         * <p>
         * VPC security groups only apply to clusters in VPCs.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
         *        <p>
         *        Default: The default VPC security group is associated with the cluster.
         *        </p>
         *        <p>
         *        VPC security groups only apply to clusters in VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         * </p>
         * <p>
         * Default: The default VPC security group is associated with the cluster.
         * </p>
         * <p>
         * VPC security groups only apply to clusters in VPCs.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
         *        <p>
         *        Default: The default VPC security group is associated with the cluster.
         *        </p>
         *        <p>
         *        VPC security groups only apply to clusters in VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The weekly time range (in UTC) during which automated cluster maintenance can occur.
         * </p>
         * <p>
         * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         * </p>
         * <p>
         * Default: The value selected for the cluster from which the snapshot was taken. For more information about the
         * time blocks for each region, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
         * >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Minimum 30-minute window.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
         *        <p>
         *        Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *        </p>
         *        <p>
         *        Default: The value selected for the cluster from which the snapshot was taken. For more information
         *        about the time blocks for each region, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows"
         *        >Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Minimum 30-minute window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         * disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with
         * <a>CreateClusterSnapshot</a>.
         * </p>
         * <p>
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * </p>
         * <p>
         * Default: The value selected for the cluster from which the snapshot was taken.
         * </p>
         * <p>
         * Constraints: Must be a value from 0 to 35.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         *        disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you
         *        want with <a>CreateClusterSnapshot</a>. </p>
         *        <p>
         *        You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35
         *        days.
         *        </p>
         *        <p>
         *        Default: The value selected for the cluster from which the snapshot was taken.
         *        </p>
         *        <p>
         *        Constraints: Must be a value from 0 to 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         * indefinitely. This setting doesn't change the retention period of existing snapshots.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         *        indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored from
         * a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an
         * encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from
         * an encrypted snapshot in the same account in order to change it. In that case, the restored cluster is
         * encrypted with the new KMS key ID.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster
         *        restored from a shared snapshot. You can also provide the key ID when you restore from an unencrypted
         *        snapshot to an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID
         *        when you restore from an encrypted snapshot in the same account in order to change it. In that case,
         *        the restored cluster is encrypted with the new KMS key ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The node type that the restored cluster will be provisioned with.
         * </p>
         * <p>
         * If you have a DC instance type, you must restore into that same instance type and size. In other words, you
         * can only restore a dc2.large node type into another dc2 type. For more information about node types, see <a
         * href
         * ="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
         * About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param nodeType
         *        The node type that the restored cluster will be provisioned with.</p>
         *        <p>
         *        If you have a DC instance type, you must restore into that same instance type and size. In other
         *        words, you can only restore a dc2.large node type into another dc2 type. For more information about
         *        node types, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"
         *        > About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon
         * Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         * </p>
         * <p>
         * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in
         * the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param iamRoles
         *        A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
         *        Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN)
         *        format. </p>
         *        <p>
         *        The maximum number of IAM roles that you can associate is subject to a quota. For more information, go
         *        to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and
         *        limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<String> iamRoles);

        /**
         * <p>
         * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon
         * Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         * </p>
         * <p>
         * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in
         * the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param iamRoles
         *        A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
         *        Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN)
         *        format. </p>
         *        <p>
         *        The maximum number of IAM roles that you can associate is subject to a quota. For more information, go
         *        to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and
         *        limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(String... iamRoles);

        /**
         * <p>
         * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits
         * the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the
         * cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that
         * is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot
         * and the source cluster are on different tracks.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot
         *        inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a
         *        different track than the cluster that was the source for the snapshot. For example, suppose that you
         *        take a snapshot of a cluster that is on the current track and then change the cluster to be on the
         *        trailing track. In this case, the snapshot and the source cluster are on different tracks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * A unique identifier for the snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleIdentifier
         *        A unique identifier for the snapshot schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier);

        /**
         * <p>
         * The number of nodes specified when provisioning the restored cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of nodes specified when provisioning the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster
         * is restored.
         * </p>
         * 
         * @param availabilityZoneRelocation
         *        The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the
         *        cluster is restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation);

        /**
         * <p>
         * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
         * determines whether to use AQUA (Advanced Query Accelerator).
         * </p>
         * 
         * @param aquaConfigurationStatus
         *        This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift
         *        automatically determines whether to use AQUA (Advanced Query Accelerator).
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(String aquaConfigurationStatus);

        /**
         * <p>
         * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically
         * determines whether to use AQUA (Advanced Query Accelerator).
         * </p>
         * 
         * @param aquaConfigurationStatus
         *        This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift
         *        automatically determines whether to use AQUA (Advanced Query Accelerator).
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was
         * last modified while it was restored from a snapshot.
         * </p>
         * 
         * @param defaultIamRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the
         *        cluster was last modified while it was restored from a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultIamRoleArn(String defaultIamRoleArn);

        /**
         * <p>
         * The identifier of the target reserved node offering.
         * </p>
         * 
         * @param reservedNodeId
         *        The identifier of the target reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeId(String reservedNodeId);

        /**
         * <p>
         * The identifier of the target reserved node offering.
         * </p>
         * 
         * @param targetReservedNodeOfferingId
         *        The identifier of the target reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId);

        /**
         * <p>
         * Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service
         * (KMS) and a customer managed key.
         * </p>
         * 
         * @param encrypted
         *        Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management
         *        Service (KMS) and a customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin
         * credentials. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses the admin
         * credentials the cluster had at the time the snapshot was taken.
         * </p>
         * 
         * @param manageMasterPassword
         *        If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin
         *        credentials. If <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses the admin
         *        credentials the cluster had at the time the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterPassword(Boolean manageMasterPassword);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
         * secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
         * </p>
         * 
         * @param masterPasswordSecretKmsKeyId
         *        The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin
         *        credentials secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId);

        /**
         * <p>
         * The IP address type for the cluster. Possible values are <code>ipv4</code> and <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the cluster. Possible values are <code>ipv4</code> and <code>dualstack</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
         * </p>
         * 
         * @param multiAZ
         *        If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String snapshotArn;

        private String snapshotClusterIdentifier;

        private Integer port;

        private String availabilityZone;

        private Boolean allowVersionUpgrade;

        private String clusterSubnetGroupName;

        private Boolean publiclyAccessible;

        private String ownerAccount;

        private String hsmClientCertificateIdentifier;

        private String hsmConfigurationIdentifier;

        private String elasticIp;

        private String clusterParameterGroupName;

        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private Integer automatedSnapshotRetentionPeriod;

        private Integer manualSnapshotRetentionPeriod;

        private String kmsKeyId;

        private String nodeType;

        private Boolean enhancedVpcRouting;

        private String additionalInfo;

        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private String maintenanceTrackName;

        private String snapshotScheduleIdentifier;

        private Integer numberOfNodes;

        private Boolean availabilityZoneRelocation;

        private String aquaConfigurationStatus;

        private String defaultIamRoleArn;

        private String reservedNodeId;

        private String targetReservedNodeOfferingId;

        private Boolean encrypted;

        private Boolean manageMasterPassword;

        private String masterPasswordSecretKmsKeyId;

        private String ipAddressType;

        private Boolean multiAZ;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromClusterSnapshotRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotArn(model.snapshotArn);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            port(model.port);
            availabilityZone(model.availabilityZone);
            allowVersionUpgrade(model.allowVersionUpgrade);
            clusterSubnetGroupName(model.clusterSubnetGroupName);
            publiclyAccessible(model.publiclyAccessible);
            ownerAccount(model.ownerAccount);
            hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            elasticIp(model.elasticIp);
            clusterParameterGroupName(model.clusterParameterGroupName);
            clusterSecurityGroups(model.clusterSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            kmsKeyId(model.kmsKeyId);
            nodeType(model.nodeType);
            enhancedVpcRouting(model.enhancedVpcRouting);
            additionalInfo(model.additionalInfo);
            iamRoles(model.iamRoles);
            maintenanceTrackName(model.maintenanceTrackName);
            snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            numberOfNodes(model.numberOfNodes);
            availabilityZoneRelocation(model.availabilityZoneRelocation);
            aquaConfigurationStatus(model.aquaConfigurationStatus);
            defaultIamRoleArn(model.defaultIamRoleArn);
            reservedNodeId(model.reservedNodeId);
            targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
            encrypted(model.encrypted);
            manageMasterPassword(model.manageMasterPassword);
            masterPasswordSecretKmsKeyId(model.masterPasswordSecretKmsKeyId);
            ipAddressType(model.ipAddressType);
            multiAZ(model.multiAZ);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Boolean getAllowVersionUpgrade() {
            return allowVersionUpgrade;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final String getClusterSubnetGroupName() {
            return clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getHsmClientCertificateIdentifier() {
            return hsmClientCertificateIdentifier;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final String getHsmConfigurationIdentifier() {
            return hsmConfigurationIdentifier;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final String getClusterParameterGroupName() {
            return clusterParameterGroupName;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final Collection<String> getClusterSecurityGroups() {
            if (clusterSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return clusterSecurityGroups;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final String getSnapshotScheduleIdentifier() {
            return snapshotScheduleIdentifier;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        @Override
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Boolean getAvailabilityZoneRelocation() {
            return availabilityZoneRelocation;
        }

        public final void setAvailabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
        }

        @Override
        public final Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        public final String getAquaConfigurationStatus() {
            return aquaConfigurationStatus;
        }

        public final void setAquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
        }

        @Override
        public final Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        @Override
        public final Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus) {
            this.aquaConfigurationStatus(aquaConfigurationStatus == null ? null : aquaConfigurationStatus.toString());
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final String getReservedNodeId() {
            return reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Boolean getManageMasterPassword() {
            return manageMasterPassword;
        }

        public final void setManageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
        }

        @Override
        public final Builder manageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
            return this;
        }

        public final String getMasterPasswordSecretKmsKeyId() {
            return masterPasswordSecretKmsKeyId;
        }

        public final void setMasterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromClusterSnapshotRequest build() {
            return new RestoreFromClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
