/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCustomDomainAssociationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyCustomDomainAssociationRequest> {
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomainName").getter(ModifyCustomDomainAssociationRequest.getter(ModifyCustomDomainAssociationRequest::customDomainName)).setter(ModifyCustomDomainAssociationRequest.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomainCertificateArn").getter(ModifyCustomDomainAssociationRequest.getter(ModifyCustomDomainAssociationRequest::customDomainCertificateArn)).setter(ModifyCustomDomainAssociationRequest.setter(Builder::customDomainCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainCertificateArn").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyCustomDomainAssociationRequest.getter(ModifyCustomDomainAssociationRequest::clusterIdentifier)).setter(ModifyCustomDomainAssociationRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOMAIN_NAME_FIELD, CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CLUSTER_IDENTIFIER_FIELD));
    private final String customDomainName;
    private final String customDomainCertificateArn;
    private final String clusterIdentifier;

    private ModifyCustomDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.customDomainName = builder.customDomainName;
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.clusterIdentifier = builder.clusterIdentifier;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final String customDomainCertificateArn() {
        return this.customDomainCertificateArn;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCustomDomainAssociationRequest)) {
            return false;
        }
        ModifyCustomDomainAssociationRequest other = (ModifyCustomDomainAssociationRequest)((Object)obj);
        return Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.customDomainCertificateArn(), other.customDomainCertificateArn()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCustomDomainAssociationRequest").add("CustomDomainName", (Object)this.customDomainName()).add("CustomDomainCertificateArn", (Object)this.customDomainCertificateArn()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "CustomDomainCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.customDomainCertificateArn()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCustomDomainAssociationRequest, T> g) {
        return obj -> g.apply((ModifyCustomDomainAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String customDomainName;
        private String customDomainCertificateArn;
        private String clusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCustomDomainAssociationRequest model) {
            super(model);
            this.customDomainName(model.customDomainName);
            this.customDomainCertificateArn(model.customDomainCertificateArn);
            this.clusterIdentifier(model.clusterIdentifier);
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getCustomDomainCertificateArn() {
            return this.customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCustomDomainAssociationRequest build() {
            return new ModifyCustomDomainAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCustomDomainAssociationRequest> {
        public Builder customDomainName(String var1);

        public Builder customDomainCertificateArn(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

