/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes cluster attributes that are in a pending state. A change to one or more the attributes was requested and is
 * in progress or will be applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedValues.Builder, PendingModifiedValues> {
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(PendingModifiedValues::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(PendingModifiedValues::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(PendingModifiedValues::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(PendingModifiedValues::clusterType)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()).build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterVersion").getter(getter(PendingModifiedValues::clusterVersion))
            .setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomatedSnapshotRetentionPeriod")
            .getter(getter(PendingModifiedValues::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(PendingModifiedValues::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(PendingModifiedValues::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnhancedVpcRouting").getter(getter(PendingModifiedValues::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceTrackName").getter(getter(PendingModifiedValues::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(PendingModifiedValues::encryptionType))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_USER_PASSWORD_FIELD,
            NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLUSTER_TYPE_FIELD, CLUSTER_VERSION_FIELD,
            AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, CLUSTER_IDENTIFIER_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            ENHANCED_VPC_ROUTING_FIELD, MAINTENANCE_TRACK_NAME_FIELD, ENCRYPTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String masterUserPassword;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final String clusterType;

    private final String clusterVersion;

    private final Integer automatedSnapshotRetentionPeriod;

    private final String clusterIdentifier;

    private final Boolean publiclyAccessible;

    private final Boolean enhancedVpcRouting;

    private final String maintenanceTrackName;

    private final String encryptionType;

    private PendingModifiedValues(BuilderImpl builder) {
        this.masterUserPassword = builder.masterUserPassword;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterType = builder.clusterType;
        this.clusterVersion = builder.clusterVersion;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The pending or in-progress change of the admin user password for the cluster.
     * </p>
     * 
     * @return The pending or in-progress change of the admin user password for the cluster.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The pending or in-progress change of the cluster's node type.
     * </p>
     * 
     * @return The pending or in-progress change of the cluster's node type.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The pending or in-progress change of the number of nodes in the cluster.
     * </p>
     * 
     * @return The pending or in-progress change of the number of nodes in the cluster.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The pending or in-progress change of the cluster type.
     * </p>
     * 
     * @return The pending or in-progress change of the cluster type.
     */
    public final String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * The pending or in-progress change of the service version.
     * </p>
     * 
     * @return The pending or in-progress change of the service version.
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The pending or in-progress change of the automated snapshot retention period.
     * </p>
     * 
     * @return The pending or in-progress change of the automated snapshot retention period.
     */
    public final Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The pending or in-progress change of the new identifier for the cluster.
     * </p>
     * 
     * @return The pending or in-progress change of the new identifier for the cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The pending or in-progress change of the ability to connect to the cluster from the public network.
     * </p>
     * 
     * @return The pending or in-progress change of the ability to connect to the cluster from the public network.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
     *         Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The name of the maintenance track that the cluster will change to during the next maintenance window.
     * </p>
     * 
     * @return The name of the maintenance track that the cluster will change to during the next maintenance window.
     */
    public final String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The encryption type for a cluster. Possible values are: KMS and None.
     * </p>
     * 
     * @return The encryption type for a cluster. Possible values are: KMS and None.
     */
    public final String encryptionType() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues) obj;
        return Objects.equals(masterUserPassword(), other.masterUserPassword()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes()) && Objects.equals(clusterType(), other.clusterType())
                && Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(encryptionType(), other.encryptionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingModifiedValues")
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes()).add("ClusterType", clusterType())
                .add("ClusterVersion", clusterVersion())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("ClusterIdentifier", clusterIdentifier()).add("PubliclyAccessible", publiclyAccessible())
                .add("EnhancedVpcRouting", enhancedVpcRouting()).add("MaintenanceTrackName", maintenanceTrackName())
                .add("EncryptionType", encryptionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedValues> {
        /**
         * <p>
         * The pending or in-progress change of the admin user password for the cluster.
         * </p>
         * 
         * @param masterUserPassword
         *        The pending or in-progress change of the admin user password for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The pending or in-progress change of the cluster's node type.
         * </p>
         * 
         * @param nodeType
         *        The pending or in-progress change of the cluster's node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The pending or in-progress change of the number of nodes in the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The pending or in-progress change of the number of nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The pending or in-progress change of the cluster type.
         * </p>
         * 
         * @param clusterType
         *        The pending or in-progress change of the cluster type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * The pending or in-progress change of the service version.
         * </p>
         * 
         * @param clusterVersion
         *        The pending or in-progress change of the service version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The pending or in-progress change of the automated snapshot retention period.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The pending or in-progress change of the automated snapshot retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The pending or in-progress change of the new identifier for the cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        The pending or in-progress change of the new identifier for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The pending or in-progress change of the ability to connect to the cluster from the public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        The pending or in-progress change of the ability to connect to the cluster from the public network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The name of the maintenance track that the cluster will change to during the next maintenance window.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track that the cluster will change to during the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The encryption type for a cluster. Possible values are: KMS and None.
         * </p>
         * 
         * @param encryptionType
         *        The encryption type for a cluster. Possible values are: KMS and None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionType(String encryptionType);
    }

    static final class BuilderImpl implements Builder {
        private String masterUserPassword;

        private String nodeType;

        private Integer numberOfNodes;

        private String clusterType;

        private String clusterVersion;

        private Integer automatedSnapshotRetentionPeriod;

        private String clusterIdentifier;

        private Boolean publiclyAccessible;

        private Boolean enhancedVpcRouting;

        private String maintenanceTrackName;

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            masterUserPassword(model.masterUserPassword);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            clusterType(model.clusterType);
            clusterVersion(model.clusterVersion);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            clusterIdentifier(model.clusterIdentifier);
            publiclyAccessible(model.publiclyAccessible);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maintenanceTrackName(model.maintenanceTrackName);
            encryptionType(model.encryptionType);
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
