/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyClusterRequest.Builder, ModifyClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyClusterRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterType").getter(getter(ModifyClusterRequest::clusterType)).setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(ModifyClusterRequest::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(ModifyClusterRequest::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<List<String>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ClusterSecurityGroups")
            .getter(getter(ModifyClusterRequest::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSecurityGroupName")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSecurityGroupName").build()).build()).build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(ModifyClusterRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(ModifyClusterRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterParameterGroupName").getter(getter(ModifyClusterRequest::clusterParameterGroupName))
            .setter(setter(Builder::clusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupName").build())
            .build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomatedSnapshotRetentionPeriod")
            .getter(getter(ModifyClusterRequest::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManualSnapshotRetentionPeriod")
            .getter(getter(ModifyClusterRequest::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ModifyClusterRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterVersion").getter(getter(ModifyClusterRequest::clusterVersion))
            .setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowVersionUpgrade").getter(getter(ModifyClusterRequest::allowVersionUpgrade))
            .setter(setter(Builder::allowVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build())
            .build();

    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmClientCertificateIdentifier")
            .getter(getter(ModifyClusterRequest::hsmClientCertificateIdentifier))
            .setter(setter(Builder::hsmClientCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HsmConfigurationIdentifier")
            .getter(getter(ModifyClusterRequest::hsmConfigurationIdentifier))
            .setter(setter(Builder::hsmConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build())
            .build();

    private static final SdkField<String> NEW_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewClusterIdentifier").getter(getter(ModifyClusterRequest::newClusterIdentifier))
            .setter(setter(Builder::newClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewClusterIdentifier").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(ModifyClusterRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticIp").getter(getter(ModifyClusterRequest::elasticIp)).setter(setter(Builder::elasticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnhancedVpcRouting").getter(getter(ModifyClusterRequest::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceTrackName").getter(getter(ModifyClusterRequest::maintenanceTrackName))
            .setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(ModifyClusterRequest::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ModifyClusterRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> AVAILABILITY_ZONE_RELOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AvailabilityZoneRelocation")
            .getter(getter(ModifyClusterRequest::availabilityZoneRelocation))
            .setter(setter(Builder::availabilityZoneRelocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneRelocation").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ModifyClusterRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(ModifyClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Boolean> MANAGE_MASTER_PASSWORD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ManageMasterPassword").getter(getter(ModifyClusterRequest::manageMasterPassword))
            .setter(setter(Builder::manageMasterPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterPassword").build())
            .build();

    private static final SdkField<String> MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MasterPasswordSecretKmsKeyId")
            .getter(getter(ModifyClusterRequest::masterPasswordSecretKmsKeyId))
            .setter(setter(Builder::masterPasswordSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterPasswordSecretKmsKeyId")
                    .build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(ModifyClusterRequest::ipAddressType))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ModifyClusterRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            CLUSTER_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLUSTER_SECURITY_GROUPS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, MASTER_USER_PASSWORD_FIELD, CLUSTER_PARAMETER_GROUP_NAME_FIELD,
            AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, CLUSTER_VERSION_FIELD, ALLOW_VERSION_UPGRADE_FIELD,
            HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, NEW_CLUSTER_IDENTIFIER_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, ELASTIC_IP_FIELD, ENHANCED_VPC_ROUTING_FIELD, MAINTENANCE_TRACK_NAME_FIELD,
            ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, AVAILABILITY_ZONE_RELOCATION_FIELD, AVAILABILITY_ZONE_FIELD, PORT_FIELD,
            MANAGE_MASTER_PASSWORD_FIELD, MASTER_PASSWORD_SECRET_KMS_KEY_ID_FIELD, IP_ADDRESS_TYPE_FIELD, MULTI_AZ_FIELD));

    private final String clusterIdentifier;

    private final String clusterType;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final List<String> clusterSecurityGroups;

    private final List<String> vpcSecurityGroupIds;

    private final String masterUserPassword;

    private final String clusterParameterGroupName;

    private final Integer automatedSnapshotRetentionPeriod;

    private final Integer manualSnapshotRetentionPeriod;

    private final String preferredMaintenanceWindow;

    private final String clusterVersion;

    private final Boolean allowVersionUpgrade;

    private final String hsmClientCertificateIdentifier;

    private final String hsmConfigurationIdentifier;

    private final String newClusterIdentifier;

    private final Boolean publiclyAccessible;

    private final String elasticIp;

    private final Boolean enhancedVpcRouting;

    private final String maintenanceTrackName;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final Boolean availabilityZoneRelocation;

    private final String availabilityZone;

    private final Integer port;

    private final Boolean manageMasterPassword;

    private final String masterPasswordSecretKmsKeyId;

    private final String ipAddressType;

    private final Boolean multiAZ;

    private ModifyClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.masterUserPassword = builder.masterUserPassword;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.newClusterIdentifier = builder.newClusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.elasticIp = builder.elasticIp;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.availabilityZoneRelocation = builder.availabilityZoneRelocation;
        this.availabilityZone = builder.availabilityZone;
        this.port = builder.port;
        this.manageMasterPassword = builder.manageMasterPassword;
        this.masterPasswordSecretKmsKeyId = builder.masterPasswordSecretKmsKeyId;
        this.ipAddressType = builder.ipAddressType;
        this.multiAZ = builder.multiAZ;
    }

    /**
     * <p>
     * The unique identifier of the cluster to be modified.
     * </p>
     * <p>
     * Example: <code>examplecluster</code>
     * </p>
     * 
     * @return The unique identifier of the cluster to be modified.</p>
     *         <p>
     *         Example: <code>examplecluster</code>
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The new cluster type.
     * </p>
     * <p>
     * When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon
     * Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the
     * old cluster is deleted and your connection is switched to the new cluster. You can use <a>DescribeResize</a> to
     * track the progress of the resize request.
     * </p>
     * <p>
     * Valid Values: <code> multi-node | single-node </code>
     * </p>
     * 
     * @return The new cluster type.</p>
     *         <p>
     *         When you submit your cluster resize request, your existing cluster goes into a read-only mode. After
     *         Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a
     *         period while the old cluster is deleted and your connection is switched to the new cluster. You can use
     *         <a>DescribeResize</a> to track the progress of the resize request.
     *         </p>
     *         <p>
     *         Valid Values: <code> multi-node | single-node </code>
     */
    public final String clusterType() {
        return clusterType;
    }

    /**
     * <p>
     * The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes
     * parameter.
     * </p>
     * <p>
     * For more information about resizing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon
     * Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> |
     * <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> |
     * <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
     * </p>
     * 
     * @return The new node type of the cluster. If you specify a new node type, you must also specify the number of
     *         nodes parameter.</p>
     *         <p>
     *         For more information about resizing clusters, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in
     *         Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     *         </p>
     *         <p>
     *         Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> |
     *         <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> |
     *         <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type
     * parameter.
     * </p>
     * <p>
     * For more information about resizing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon
     * Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * Valid Values: Integer greater than <code>0</code>.
     * </p>
     * 
     * @return The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the
     *         node type parameter.</p>
     *         <p>
     *         For more information about resizing clusters, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in
     *         Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     *         </p>
     *         <p>
     *         Valid Values: Integer greater than <code>0</code>.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterSecurityGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterSecurityGroups() {
        return clusterSecurityGroups != null && !(clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon
     * as possible.
     * </p>
     * <p>
     * Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked
     * from the cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 alphanumeric characters or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterSecurityGroups} method.
     * </p>
     * 
     * @return A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied
     *         as soon as possible.</p>
     *         <p>
     *         Security groups currently associated with the cluster, and not in the list of groups to apply, will be
     *         revoked from the cluster.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 alphanumeric characters or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     */
    public final List<String> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is
     * asynchronously applied as soon as possible.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is
     *         asynchronously applied as soon as possible.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The new password for the cluster admin user. This change is asynchronously applied as soon as possible. Between
     * the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in
     * the <code>PendingModifiedValues</code> element of the operation response.
     * </p>
     * <p>
     * You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is <code>true</code>.
     * </p>
     * <note>
     * <p>
     * Operations never return the password, so this operation provides a way to regain access to the admin user account
     * for a cluster if the password is lost.
     * </p>
     * </note>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be between 8 and 64 characters in length.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain at least one uppercase letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain at least one lowercase letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain one number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote), <code>"</code>
     * (double quote), <code>\</code>, <code>/</code>, or <code>@</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The new password for the cluster admin user. This change is asynchronously applied as soon as possible.
     *         Between the time of the request and the completion of the request, the <code>MasterUserPassword</code>
     *         element exists in the <code>PendingModifiedValues</code> element of the operation response. </p>
     *         <p>
     *         You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is <code>true</code>.
     *         </p>
     *         <note>
     *         <p>
     *         Operations never return the password, so this operation provides a way to regain access to the admin user
     *         account for a cluster if the password is lost.
     *         </p>
     *         </note>
     *         <p>
     *         Default: Uses existing setting.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be between 8 and 64 characters in length.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain at least one uppercase letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain at least one lowercase letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain one number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote),
     *         <code>"</code> (double quote), <code>\</code>, <code>/</code>, or <code>@</code>.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster
     * is rebooted. To reboot a cluster use <a>RebootCluster</a>.
     * </p>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * <p>
     * Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster
     * version.
     * </p>
     * 
     * @return The name of the cluster parameter group to apply to this cluster. This change is applied only after the
     *         cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
     *         <p>
     *         Default: Uses existing setting.
     *         </p>
     *         <p>
     *         Constraints: The cluster parameter group must be in the same parameter group family that matches the
     *         cluster version.
     */
    public final String clusterParameterGroupName() {
        return clusterParameterGroupName;
    }

    /**
     * <p>
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled.
     * Even if automated snapshots are disabled, you can still create manual snapshots when you want with
     * <a>CreateClusterSnapshot</a>.
     * </p>
     * <p>
     * If you decrease the automated snapshot retention period from its current value, existing automated snapshots that
     * fall outside of the new retention period will be immediately deleted.
     * </p>
     * <p>
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     * </p>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * <p>
     * Constraints: Must be a value from 0 to 35.
     * </p>
     * 
     * @return The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
     *         disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want
     *         with <a>CreateClusterSnapshot</a>. </p>
     *         <p>
     *         If you decrease the automated snapshot retention period from its current value, existing automated
     *         snapshots that fall outside of the new retention period will be immediately deleted.
     *         </p>
     *         <p>
     *         You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35
     *         days.
     *         </p>
     *         <p>
     *         Default: Uses existing setting.
     *         </p>
     *         <p>
     *         Constraints: Must be a value from 0 to 35.
     */
    public final Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual
     * snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of existing
     * manual snapshots.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * <p>
     * The default value is -1.
     * </p>
     * 
     * @return The default for number of days that a newly created manual snapshot is retained. If the value is -1, the
     *         manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods
     *         of existing manual snapshots.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     *         </p>
     *         <p>
     *         The default value is -1.
     */
    public final Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is
     * necessary during the window, it may result in an outage.
     * </p>
     * <p>
     * This maintenance window change is made immediately. If the new maintenance window indicates the current time,
     * there must be at least 120 minutes between the current time and end of the window in order to ensure that pending
     * changes are applied.
     * </p>
     * <p>
     * Default: Uses existing setting.
     * </p>
     * <p>
     * Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes.
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system
     *         maintenance is necessary during the window, it may result in an outage.</p>
     *         <p>
     *         This maintenance window change is made immediately. If the new maintenance window indicates the current
     *         time, there must be at least 120 minutes between the current time and end of the window in order to
     *         ensure that pending changes are applied.
     *         </p>
     *         <p>
     *         Default: Uses existing setting.
     *         </p>
     *         <p>
     *         Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The new version number of the Amazon Redshift engine to upgrade to.
     * </p>
     * <p>
     * For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter
     * group in the cluster parameter group family for the new version must be specified. The new cluster parameter
     * group can be the default for that cluster parameter group family. For more information about parameters and
     * parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * Example: <code>1.0</code>
     * </p>
     * 
     * @return The new version number of the Amazon Redshift engine to upgrade to.</p>
     *         <p>
     *         For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster
     *         parameter group in the cluster parameter group family for the new version must be specified. The new
     *         cluster parameter group can be the default for that cluster parameter group family. For more information
     *         about parameters and parameter groups, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
     *         Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     *         </p>
     *         <p>
     *         Example: <code>1.0</code>
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance
     * window.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If <code>true</code>, major version upgrades will be applied automatically to the cluster during the
     *         maintenance window. </p>
     *         <p>
     *         Default: <code>false</code>
     */
    public final Boolean allowVersionUpgrade() {
        return allowVersionUpgrade;
    }

    /**
     * <p>
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption
     * keys stored in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
     *         encryption keys stored in an HSM.
     */
    public final String hsmClientCertificateIdentifier() {
        return hsmClientCertificateIdentifier;
    }

    /**
     * <p>
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to
     * retrieve and store keys in an HSM.
     * </p>
     * 
     * @return Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can
     *         use to retrieve and store keys in an HSM.
     */
    public final String hsmConfigurationIdentifier() {
        return hsmConfigurationIdentifier;
    }

    /**
     * <p>
     * The new identifier for the cluster.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Alphabetic characters must be lowercase.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be unique for all clusters within an Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>examplecluster</code>
     * </p>
     * 
     * @return The new identifier for the cluster.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alphabetic characters must be lowercase.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be unique for all clusters within an Amazon Web Services account.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>examplecluster</code>
     */
    public final String newClusterIdentifier() {
        return newClusterIdentifier;
    }

    /**
     * <p>
     * If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be
     * publicly available.
     * </p>
     * 
     * @return If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set
     *         to be publicly available.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The Elastic IP (EIP) address for the cluster.
     * </p>
     * <p>
     * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For
     * more information about provisioning clusters in EC2-VPC, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
     * Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * 
     * @return The Elastic IP (EIP) address for the cluster.</p>
     *         <p>
     *         Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet
     *         gateway. For more information about provisioning clusters in EC2-VPC, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms"
     *         >Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
     */
    public final String elasticIp() {
        return elasticIp;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
     *         Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The
     * new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window.
     * When the maintenance track changes, the cluster is switched to the latest cluster release available for the
     * maintenance track. At this point, the maintenance track name is applied.
     * </p>
     * 
     * @return The name for the maintenance track that you want to assign for the cluster. This name change is
     *         asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until
     *         the next maintenance window. When the maintenance track changes, the cluster is switched to the latest
     *         cluster release available for the maintenance track. At this point, the maintenance track name is
     *         applied.
     */
    public final String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the
     * <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't
     * provide a <code>KmsKeyId</code>, we encrypt with the default key.
     * </p>
     * <p>
     * If the value is not encrypted (false), then the cluster is decrypted.
     * </p>
     * 
     * @return Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for
     *         the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If
     *         you don't provide a <code>KmsKeyId</code>, we encrypt with the default key. </p>
     *         <p>
     *         If the value is not encrypted (false), then the cluster is decrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the
     * cluster.
     * </p>
     * 
     * @return The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the
     *         cluster.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster
     * modification is complete.
     * </p>
     * 
     * @return The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the
     *         cluster modification is complete.
     */
    public final Boolean availabilityZoneRelocation() {
        return availabilityZoneRelocation;
    }

    /**
     * <p>
     * The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
     * </p>
     * 
     * @return The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The option to change the port of an Amazon Redshift cluster.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or <code>8191-8215</code>.
     * (If you have an existing cluster with ra3 nodes, it isn't required that you change the port to these ranges.)
     * </p>
     * </li>
     * <li>
     * <p>
     * For clusters with ds2 or dc2 nodes - Select a port within the range <code>1150-65535</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The option to change the port of an Amazon Redshift cluster.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or
     *         <code>8191-8215</code>. (If you have an existing cluster with ra3 nodes, it isn't required that you
     *         change the port to these ranges.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For clusters with ds2 or dc2 nodes - Select a port within the range <code>1150-65535</code>.
     *         </p>
     *         </li>
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage this cluster's admin credentials. You can't
     * use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If
     * <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses <code>MasterUserPassword</code> for
     * the admin user account's password.
     * </p>
     * 
     * @return If <code>true</code>, Amazon Redshift uses Secrets Manager to manage this cluster's admin credentials.
     *         You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If
     *         <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses
     *         <code>MasterUserPassword</code> for the admin user account's password.
     */
    public final Boolean manageMasterPassword() {
        return manageMasterPassword;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
     * You can only use this parameter if <code>ManageMasterPassword</code> is true.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
     *         secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
     */
    public final String masterPasswordSecretKmsKeyId() {
        return masterPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The IP address types that the cluster supports. Possible values are <code>ipv4</code> and <code>dualstack</code>.
     * </p>
     * 
     * @return The IP address types that the cluster supports. Possible values are <code>ipv4</code> and
     *         <code>dualstack</code>.
     */
    public final String ipAddressType() {
        return ipAddressType;
    }

    /**
     * <p>
     * If true and the cluster is currently only deployed in a single Availability Zone, the cluster will be modified to
     * be deployed in two Availability Zones.
     * </p>
     * 
     * @return If true and the cluster is currently only deployed in a single Availability Zone, the cluster will be
     *         modified to be deployed in two Availability Zones.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterSecurityGroups() ? clusterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneRelocation());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(manageMasterPassword());
        hashCode = 31 * hashCode + Objects.hashCode(masterPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(clusterType(), other.clusterType()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && hasClusterSecurityGroups() == other.hasClusterSecurityGroups()
                && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(clusterParameterGroupName(), other.clusterParameterGroupName())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(allowVersionUpgrade(), other.allowVersionUpgrade())
                && Objects.equals(hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier())
                && Objects.equals(hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier())
                && Objects.equals(newClusterIdentifier(), other.newClusterIdentifier())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(elasticIp(), other.elasticIp())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(availabilityZoneRelocation(), other.availabilityZoneRelocation())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(port(), other.port())
                && Objects.equals(manageMasterPassword(), other.manageMasterPassword())
                && Objects.equals(masterPasswordSecretKmsKeyId(), other.masterPasswordSecretKmsKeyId())
                && Objects.equals(ipAddressType(), other.ipAddressType()) && Objects.equals(multiAZ(), other.multiAZ());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ClusterType", clusterType()).add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes())
                .add("ClusterSecurityGroups", hasClusterSecurityGroups() ? clusterSecurityGroups() : null)
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClusterParameterGroupName", clusterParameterGroupName())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("ClusterVersion", clusterVersion())
                .add("AllowVersionUpgrade", allowVersionUpgrade())
                .add("HsmClientCertificateIdentifier", hsmClientCertificateIdentifier())
                .add("HsmConfigurationIdentifier", hsmConfigurationIdentifier())
                .add("NewClusterIdentifier", newClusterIdentifier()).add("PubliclyAccessible", publiclyAccessible())
                .add("ElasticIp", elasticIp()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("MaintenanceTrackName", maintenanceTrackName()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("AvailabilityZoneRelocation", availabilityZoneRelocation()).add("AvailabilityZone", availabilityZone())
                .add("Port", port()).add("ManageMasterPassword", manageMasterPassword())
                .add("MasterPasswordSecretKmsKeyId", masterPasswordSecretKmsKeyId()).add("IpAddressType", ipAddressType())
                .add("MultiAZ", multiAZ()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "ClusterType":
            return Optional.ofNullable(clazz.cast(clusterType()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "ClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(clusterParameterGroupName()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "AllowVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowVersionUpgrade()));
        case "HsmClientCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(hsmClientCertificateIdentifier()));
        case "HsmConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(hsmConfigurationIdentifier()));
        case "NewClusterIdentifier":
            return Optional.ofNullable(clazz.cast(newClusterIdentifier()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "ElasticIp":
            return Optional.ofNullable(clazz.cast(elasticIp()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "AvailabilityZoneRelocation":
            return Optional.ofNullable(clazz.cast(availabilityZoneRelocation()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "ManageMasterPassword":
            return Optional.ofNullable(clazz.cast(manageMasterPassword()));
        case "MasterPasswordSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(masterPasswordSecretKmsKeyId()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterRequest, T> g) {
        return obj -> g.apply((ModifyClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClusterRequest> {
        /**
         * <p>
         * The unique identifier of the cluster to be modified.
         * </p>
         * <p>
         * Example: <code>examplecluster</code>
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster to be modified.</p>
         *        <p>
         *        Example: <code>examplecluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The new cluster type.
         * </p>
         * <p>
         * When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon
         * Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while
         * the old cluster is deleted and your connection is switched to the new cluster. You can use
         * <a>DescribeResize</a> to track the progress of the resize request.
         * </p>
         * <p>
         * Valid Values: <code> multi-node | single-node </code>
         * </p>
         * 
         * @param clusterType
         *        The new cluster type.</p>
         *        <p>
         *        When you submit your cluster resize request, your existing cluster goes into a read-only mode. After
         *        Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a
         *        period while the old cluster is deleted and your connection is switched to the new cluster. You can
         *        use <a>DescribeResize</a> to track the progress of the resize request.
         *        </p>
         *        <p>
         *        Valid Values: <code> multi-node | single-node </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes
         * parameter.
         * </p>
         * <p>
         * For more information about resizing clusters, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon
         * Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * <p>
         * Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> |
         * <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> |
         * <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
         * </p>
         * 
         * @param nodeType
         *        The new node type of the cluster. If you specify a new node type, you must also specify the number of
         *        nodes parameter.</p>
         *        <p>
         *        For more information about resizing clusters, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in
         *        Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         *        </p>
         *        <p>
         *        Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> |
         *        <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code>
         *        | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node
         * type parameter.
         * </p>
         * <p>
         * For more information about resizing clusters, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon
         * Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * <p>
         * Valid Values: Integer greater than <code>0</code>.
         * </p>
         * 
         * @param numberOfNodes
         *        The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify
         *        the node type parameter.</p>
         *        <p>
         *        For more information about resizing clusters, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in
         *        Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         *        </p>
         *        <p>
         *        Valid Values: Integer greater than <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * Security groups currently associated with the cluster, and not in the list of groups to apply, will be
         * revoked from the cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 alphanumeric characters or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security groups to be authorized on this cluster. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        Security groups currently associated with the cluster, and not in the list of groups to apply, will be
         *        revoked from the cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 alphanumeric characters or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups);

        /**
         * <p>
         * A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as
         * soon as possible.
         * </p>
         * <p>
         * Security groups currently associated with the cluster, and not in the list of groups to apply, will be
         * revoked from the cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 alphanumeric characters or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security groups to be authorized on this cluster. This change is asynchronously
         *        applied as soon as possible.</p>
         *        <p>
         *        Security groups currently associated with the cluster, and not in the list of groups to apply, will be
         *        revoked from the cluster.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 alphanumeric characters or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(String... clusterSecurityGroups);

        /**
         * <p>
         * A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change
         *        is asynchronously applied as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is
         * asynchronously applied as soon as possible.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change
         *        is asynchronously applied as soon as possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The new password for the cluster admin user. This change is asynchronously applied as soon as possible.
         * Between the time of the request and the completion of the request, the <code>MasterUserPassword</code>
         * element exists in the <code>PendingModifiedValues</code> element of the operation response.
         * </p>
         * <p>
         * You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is <code>true</code>.
         * </p>
         * <note>
         * <p>
         * Operations never return the password, so this operation provides a way to regain access to the admin user
         * account for a cluster if the password is lost.
         * </p>
         * </note>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be between 8 and 64 characters in length.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain at least one uppercase letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain at least one lowercase letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain one number.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote), <code>"</code>
         * (double quote), <code>\</code>, <code>/</code>, or <code>@</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The new password for the cluster admin user. This change is asynchronously applied as soon as
         *        possible. Between the time of the request and the completion of the request, the
         *        <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of
         *        the operation response. </p>
         *        <p>
         *        You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is
         *        <code>true</code>.
         *        </p>
         *        <note>
         *        <p>
         *        Operations never return the password, so this operation provides a way to regain access to the admin
         *        user account for a cluster if the password is lost.
         *        </p>
         *        </note>
         *        <p>
         *        Default: Uses existing setting.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be between 8 and 64 characters in length.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain at least one uppercase letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain at least one lowercase letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain one number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can be any printable ASCII character (ASCII code 33-126) except <code>'</code> (single quote),
         *        <code>"</code> (double quote), <code>\</code>, <code>/</code>, or <code>@</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The name of the cluster parameter group to apply to this cluster. This change is applied only after the
         * cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>.
         * </p>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * <p>
         * Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster
         * version.
         * </p>
         * 
         * @param clusterParameterGroupName
         *        The name of the cluster parameter group to apply to this cluster. This change is applied only after
         *        the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
         *        <p>
         *        Default: Uses existing setting.
         *        </p>
         *        <p>
         *        Constraints: The cluster parameter group must be in the same parameter group family that matches the
         *        cluster version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroupName(String clusterParameterGroupName);

        /**
         * <p>
         * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         * disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with
         * <a>CreateClusterSnapshot</a>.
         * </p>
         * <p>
         * If you decrease the automated snapshot retention period from its current value, existing automated snapshots
         * that fall outside of the new retention period will be immediately deleted.
         * </p>
         * <p>
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         * </p>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * <p>
         * Constraints: Must be a value from 0 to 35.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The number of days that automated snapshots are retained. If the value is 0, automated snapshots are
         *        disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you
         *        want with <a>CreateClusterSnapshot</a>. </p>
         *        <p>
         *        If you decrease the automated snapshot retention period from its current value, existing automated
         *        snapshots that fall outside of the new retention period will be immediately deleted.
         *        </p>
         *        <p>
         *        You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35
         *        days.
         *        </p>
         *        <p>
         *        Default: Uses existing setting.
         *        </p>
         *        <p>
         *        Constraints: Must be a value from 0 to 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The default for number of days that a newly created manual snapshot is retained. If the value is -1, the
         * manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of
         * existing manual snapshots.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * <p>
         * The default value is -1.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The default for number of days that a newly created manual snapshot is retained. If the value is -1,
         *        the manual snapshot is retained indefinitely. This value doesn't retroactively change the retention
         *        periods of existing manual snapshots.</p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         *        </p>
         *        <p>
         *        The default value is -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance
         * is necessary during the window, it may result in an outage.
         * </p>
         * <p>
         * This maintenance window change is made immediately. If the new maintenance window indicates the current time,
         * there must be at least 120 minutes between the current time and end of the window in order to ensure that
         * pending changes are applied.
         * </p>
         * <p>
         * Default: Uses existing setting.
         * </p>
         * <p>
         * Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system
         *        maintenance is necessary during the window, it may result in an outage.</p>
         *        <p>
         *        This maintenance window change is made immediately. If the new maintenance window indicates the
         *        current time, there must be at least 120 minutes between the current time and end of the window in
         *        order to ensure that pending changes are applied.
         *        </p>
         *        <p>
         *        Default: Uses existing setting.
         *        </p>
         *        <p>
         *        Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The new version number of the Amazon Redshift engine to upgrade to.
         * </p>
         * <p>
         * For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster
         * parameter group in the cluster parameter group family for the new version must be specified. The new cluster
         * parameter group can be the default for that cluster parameter group family. For more information about
         * parameters and parameter groups, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
         * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * <p>
         * Example: <code>1.0</code>
         * </p>
         * 
         * @param clusterVersion
         *        The new version number of the Amazon Redshift engine to upgrade to.</p>
         *        <p>
         *        For major version upgrades, if a non-default cluster parameter group is currently in use, a new
         *        cluster parameter group in the cluster parameter group family for the new version must be specified.
         *        The new cluster parameter group can be the default for that cluster parameter group family. For more
         *        information about parameters and parameter groups, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
         *        Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         *        </p>
         *        <p>
         *        Example: <code>1.0</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * If <code>true</code>, major version upgrades will be applied automatically to the cluster during the
         * maintenance window.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param allowVersionUpgrade
         *        If <code>true</code>, major version upgrades will be applied automatically to the cluster during the
         *        maintenance window. </p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowVersionUpgrade(Boolean allowVersionUpgrade);

        /**
         * <p>
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         * encryption keys stored in an HSM.
         * </p>
         * 
         * @param hsmClientCertificateIdentifier
         *        Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data
         *        encryption keys stored in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier);

        /**
         * <p>
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use
         * to retrieve and store keys in an HSM.
         * </p>
         * 
         * @param hsmConfigurationIdentifier
         *        Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster
         *        can use to retrieve and store keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier);

        /**
         * <p>
         * The new identifier for the cluster.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Alphabetic characters must be lowercase.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be unique for all clusters within an Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>examplecluster</code>
         * </p>
         * 
         * @param newClusterIdentifier
         *        The new identifier for the cluster.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alphabetic characters must be lowercase.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be unique for all clusters within an Amazon Web Services account.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>examplecluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newClusterIdentifier(String newClusterIdentifier);

        /**
         * <p>
         * If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to
         * be publicly available.
         * </p>
         * 
         * @param publiclyAccessible
         *        If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be
         *        set to be publicly available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The Elastic IP (EIP) address for the cluster.
         * </p>
         * <p>
         * Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway.
         * For more information about provisioning clusters in EC2-VPC, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms"
         * >Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
         * </p>
         * 
         * @param elasticIp
         *        The Elastic IP (EIP) address for the cluster.</p>
         *        <p>
         *        Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet
         *        gateway. For more information about provisioning clusters in EC2-VPC, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms"
         *        >Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous.
         * The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance
         * window. When the maintenance track changes, the cluster is switched to the latest cluster release available
         * for the maintenance track. At this point, the maintenance track name is applied.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name for the maintenance track that you want to assign for the cluster. This name change is
         *        asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until
         *        the next maintenance window. When the maintenance track changes, the cluster is switched to the latest
         *        cluster release available for the maintenance track. At this point, the maintenance track name is
         *        applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the
         * <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't
         * provide a <code>KmsKeyId</code>, we encrypt with the default key.
         * </p>
         * <p>
         * If the value is not encrypted (false), then the cluster is decrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value
         *        for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided
         *        <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>, we encrypt with the default key.
         *        </p>
         *        <p>
         *        If the value is not encrypted (false), then the cluster is decrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the
         * cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in
         *        the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster
         * modification is complete.
         * </p>
         * 
         * @param availabilityZoneRelocation
         *        The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the
         *        cluster modification is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation);

        /**
         * <p>
         * The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The option to change the port of an Amazon Redshift cluster.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or
         * <code>8191-8215</code>. (If you have an existing cluster with ra3 nodes, it isn't required that you change
         * the port to these ranges.)
         * </p>
         * </li>
         * <li>
         * <p>
         * For clusters with ds2 or dc2 nodes - Select a port within the range <code>1150-65535</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param port
         *        The option to change the port of an Amazon Redshift cluster.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For clusters with ra3 nodes - Select a port within the ranges <code>5431-5455</code> or
         *        <code>8191-8215</code>. (If you have an existing cluster with ra3 nodes, it isn't required that you
         *        change the port to these ranges.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For clusters with ds2 or dc2 nodes - Select a port within the range <code>1150-65535</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * If <code>true</code>, Amazon Redshift uses Secrets Manager to manage this cluster's admin credentials. You
         * can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If
         * <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses <code>MasterUserPassword</code>
         * for the admin user account's password.
         * </p>
         * 
         * @param manageMasterPassword
         *        If <code>true</code>, Amazon Redshift uses Secrets Manager to manage this cluster's admin credentials.
         *        You can't use <code>MasterUserPassword</code> if <code>ManageMasterPassword</code> is true. If
         *        <code>ManageMasterPassword</code> is false or not set, Amazon Redshift uses
         *        <code>MasterUserPassword</code> for the admin user account's password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageMasterPassword(Boolean manageMasterPassword);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials
         * secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
         * </p>
         * 
         * @param masterPasswordSecretKmsKeyId
         *        The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin
         *        credentials secret. You can only use this parameter if <code>ManageMasterPassword</code> is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId);

        /**
         * <p>
         * The IP address types that the cluster supports. Possible values are <code>ipv4</code> and
         * <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address types that the cluster supports. Possible values are <code>ipv4</code> and
         *        <code>dualstack</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * If true and the cluster is currently only deployed in a single Availability Zone, the cluster will be
         * modified to be deployed in two Availability Zones.
         * </p>
         * 
         * @param multiAZ
         *        If true and the cluster is currently only deployed in a single Availability Zone, the cluster will be
         *        modified to be deployed in two Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String clusterType;

        private String nodeType;

        private Integer numberOfNodes;

        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String masterUserPassword;

        private String clusterParameterGroupName;

        private Integer automatedSnapshotRetentionPeriod;

        private Integer manualSnapshotRetentionPeriod;

        private String preferredMaintenanceWindow;

        private String clusterVersion;

        private Boolean allowVersionUpgrade;

        private String hsmClientCertificateIdentifier;

        private String hsmConfigurationIdentifier;

        private String newClusterIdentifier;

        private Boolean publiclyAccessible;

        private String elasticIp;

        private Boolean enhancedVpcRouting;

        private String maintenanceTrackName;

        private Boolean encrypted;

        private String kmsKeyId;

        private Boolean availabilityZoneRelocation;

        private String availabilityZone;

        private Integer port;

        private Boolean manageMasterPassword;

        private String masterPasswordSecretKmsKeyId;

        private String ipAddressType;

        private Boolean multiAZ;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            clusterType(model.clusterType);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            clusterSecurityGroups(model.clusterSecurityGroups);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            masterUserPassword(model.masterUserPassword);
            clusterParameterGroupName(model.clusterParameterGroupName);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            clusterVersion(model.clusterVersion);
            allowVersionUpgrade(model.allowVersionUpgrade);
            hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            newClusterIdentifier(model.newClusterIdentifier);
            publiclyAccessible(model.publiclyAccessible);
            elasticIp(model.elasticIp);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maintenanceTrackName(model.maintenanceTrackName);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            availabilityZoneRelocation(model.availabilityZoneRelocation);
            availabilityZone(model.availabilityZone);
            port(model.port);
            manageMasterPassword(model.manageMasterPassword);
            masterPasswordSecretKmsKeyId(model.masterPasswordSecretKmsKeyId);
            ipAddressType(model.ipAddressType);
            multiAZ(model.multiAZ);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Collection<String> getClusterSecurityGroups() {
            if (clusterSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return clusterSecurityGroups;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getClusterParameterGroupName() {
            return clusterParameterGroupName;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final Boolean getAllowVersionUpgrade() {
            return allowVersionUpgrade;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final String getHsmClientCertificateIdentifier() {
            return hsmClientCertificateIdentifier;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final String getHsmConfigurationIdentifier() {
            return hsmConfigurationIdentifier;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final String getNewClusterIdentifier() {
            return newClusterIdentifier;
        }

        public final void setNewClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
        }

        @Override
        public final Builder newClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getAvailabilityZoneRelocation() {
            return availabilityZoneRelocation;
        }

        public final void setAvailabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
        }

        @Override
        public final Builder availabilityZoneRelocation(Boolean availabilityZoneRelocation) {
            this.availabilityZoneRelocation = availabilityZoneRelocation;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getManageMasterPassword() {
            return manageMasterPassword;
        }

        public final void setManageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
        }

        @Override
        public final Builder manageMasterPassword(Boolean manageMasterPassword) {
            this.manageMasterPassword = manageMasterPassword;
            return this;
        }

        public final String getMasterPasswordSecretKmsKeyId() {
            return masterPasswordSecretKmsKeyId;
        }

        public final void setMasterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder masterPasswordSecretKmsKeyId(String masterPasswordSecretKmsKeyId) {
            this.masterPasswordSecretKmsKeyId = masterPasswordSecretKmsKeyId;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
