/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of a cluster resize operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResizeResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeResizeResponse.Builder, DescribeResizeResponse> {
    private static final SdkField<String> TARGET_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetNodeType").getter(getter(DescribeResizeResponse::targetNodeType))
            .setter(setter(Builder::targetNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNodeType").build()).build();

    private static final SdkField<Integer> TARGET_NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetNumberOfNodes").getter(getter(DescribeResizeResponse::targetNumberOfNodes))
            .setter(setter(Builder::targetNumberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNumberOfNodes").build())
            .build();

    private static final SdkField<String> TARGET_CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetClusterType").getter(getter(DescribeResizeResponse::targetClusterType))
            .setter(setter(Builder::targetClusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetClusterType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeResizeResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> IMPORT_TABLES_COMPLETED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImportTablesCompleted")
            .getter(getter(DescribeResizeResponse::importTablesCompleted))
            .setter(setter(Builder::importTablesCompleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesCompleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPORT_TABLES_IN_PROGRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImportTablesInProgress")
            .getter(getter(DescribeResizeResponse::importTablesInProgress))
            .setter(setter(Builder::importTablesInProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesInProgress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPORT_TABLES_NOT_STARTED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ImportTablesNotStarted")
            .getter(getter(DescribeResizeResponse::importTablesNotStarted))
            .setter(setter(Builder::importTablesNotStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesNotStarted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("AvgResizeRateInMegaBytesPerSecond")
            .getter(getter(DescribeResizeResponse::avgResizeRateInMegaBytesPerSecond))
            .setter(setter(Builder::avgResizeRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvgResizeRateInMegaBytesPerSecond")
                    .build()).build();

    private static final SdkField<Long> TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalResizeDataInMegaBytes")
            .getter(getter(DescribeResizeResponse::totalResizeDataInMegaBytes))
            .setter(setter(Builder::totalResizeDataInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResizeDataInMegaBytes").build())
            .build();

    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProgressInMegaBytes").getter(getter(DescribeResizeResponse::progressInMegaBytes))
            .setter(setter(Builder::progressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build())
            .build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeInSeconds").getter(getter(DescribeResizeResponse::elapsedTimeInSeconds))
            .setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeToCompletionInSeconds")
            .getter(getter(DescribeResizeResponse::estimatedTimeToCompletionInSeconds))
            .setter(setter(Builder::estimatedTimeToCompletionInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds")
                    .build()).build();

    private static final SdkField<String> RESIZE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResizeType").getter(getter(DescribeResizeResponse::resizeType)).setter(setter(Builder::resizeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeType").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DescribeResizeResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> TARGET_ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEncryptionType").getter(getter(DescribeResizeResponse::targetEncryptionType))
            .setter(setter(Builder::targetEncryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEncryptionType").build())
            .build();

    private static final SdkField<Double> DATA_TRANSFER_PROGRESS_PERCENT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("DataTransferProgressPercent")
            .getter(getter(DescribeResizeResponse::dataTransferProgressPercent))
            .setter(setter(Builder::dataTransferProgressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgressPercent")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODE_TYPE_FIELD,
            TARGET_NUMBER_OF_NODES_FIELD, TARGET_CLUSTER_TYPE_FIELD, STATUS_FIELD, IMPORT_TABLES_COMPLETED_FIELD,
            IMPORT_TABLES_IN_PROGRESS_FIELD, IMPORT_TABLES_NOT_STARTED_FIELD, AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD,
            TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD,
            ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, RESIZE_TYPE_FIELD, MESSAGE_FIELD, TARGET_ENCRYPTION_TYPE_FIELD,
            DATA_TRANSFER_PROGRESS_PERCENT_FIELD));

    private final String targetNodeType;

    private final Integer targetNumberOfNodes;

    private final String targetClusterType;

    private final String status;

    private final List<String> importTablesCompleted;

    private final List<String> importTablesInProgress;

    private final List<String> importTablesNotStarted;

    private final Double avgResizeRateInMegaBytesPerSecond;

    private final Long totalResizeDataInMegaBytes;

    private final Long progressInMegaBytes;

    private final Long elapsedTimeInSeconds;

    private final Long estimatedTimeToCompletionInSeconds;

    private final String resizeType;

    private final String message;

    private final String targetEncryptionType;

    private final Double dataTransferProgressPercent;

    private DescribeResizeResponse(BuilderImpl builder) {
        super(builder);
        this.targetNodeType = builder.targetNodeType;
        this.targetNumberOfNodes = builder.targetNumberOfNodes;
        this.targetClusterType = builder.targetClusterType;
        this.status = builder.status;
        this.importTablesCompleted = builder.importTablesCompleted;
        this.importTablesInProgress = builder.importTablesInProgress;
        this.importTablesNotStarted = builder.importTablesNotStarted;
        this.avgResizeRateInMegaBytesPerSecond = builder.avgResizeRateInMegaBytesPerSecond;
        this.totalResizeDataInMegaBytes = builder.totalResizeDataInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.resizeType = builder.resizeType;
        this.message = builder.message;
        this.targetEncryptionType = builder.targetEncryptionType;
        this.dataTransferProgressPercent = builder.dataTransferProgressPercent;
    }

    /**
     * <p>
     * The node type that the cluster will have after the resize operation is complete.
     * </p>
     * 
     * @return The node type that the cluster will have after the resize operation is complete.
     */
    public final String targetNodeType() {
        return targetNodeType;
    }

    /**
     * <p>
     * The number of nodes that the cluster will have after the resize operation is complete.
     * </p>
     * 
     * @return The number of nodes that the cluster will have after the resize operation is complete.
     */
    public final Integer targetNumberOfNodes() {
        return targetNumberOfNodes;
    }

    /**
     * <p>
     * The cluster type after the resize operation is complete.
     * </p>
     * <p>
     * Valid Values: <code>multi-node</code> | <code>single-node</code>
     * </p>
     * 
     * @return The cluster type after the resize operation is complete.</p>
     *         <p>
     *         Valid Values: <code>multi-node</code> | <code>single-node</code>
     */
    public final String targetClusterType() {
        return targetClusterType;
    }

    /**
     * <p>
     * The status of the resize operation.
     * </p>
     * <p>
     * Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> |
     * <code>CANCELLING</code>
     * </p>
     * 
     * @return The status of the resize operation.</p>
     *         <p>
     *         Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code>
     *         | <code>CANCELLING</code>
     */
    public final String status() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportTablesCompleted property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImportTablesCompleted() {
        return importTablesCompleted != null && !(importTablesCompleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of tables that have been completely imported .
     * </p>
     * <p>
     * Valid Values: List of table names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportTablesCompleted} method.
     * </p>
     * 
     * @return The names of tables that have been completely imported .</p>
     *         <p>
     *         Valid Values: List of table names.
     */
    public final List<String> importTablesCompleted() {
        return importTablesCompleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportTablesInProgress property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImportTablesInProgress() {
        return importTablesInProgress != null && !(importTablesInProgress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of tables that are being currently imported.
     * </p>
     * <p>
     * Valid Values: List of table names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportTablesInProgress} method.
     * </p>
     * 
     * @return The names of tables that are being currently imported.</p>
     *         <p>
     *         Valid Values: List of table names.
     */
    public final List<String> importTablesInProgress() {
        return importTablesInProgress;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportTablesNotStarted property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImportTablesNotStarted() {
        return importTablesNotStarted != null && !(importTablesNotStarted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of tables that have not been yet imported.
     * </p>
     * <p>
     * Valid Values: List of table names
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportTablesNotStarted} method.
     * </p>
     * 
     * @return The names of tables that have not been yet imported.</p>
     *         <p>
     *         Valid Values: List of table names
     */
    public final List<String> importTablesNotStarted() {
        return importTablesNotStarted;
    }

    /**
     * <p>
     * The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the
     * resize operation completes, this value shows the average rate of the entire resize operation.
     * </p>
     * 
     * @return The average rate of the resize operation over the last few minutes, measured in megabytes per second.
     *         After the resize operation completes, this value shows the average rate of the entire resize operation.
     */
    public final Double avgResizeRateInMegaBytesPerSecond() {
        return avgResizeRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
     * </p>
     * 
     * @return The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
     */
    public final Long totalResizeDataInMegaBytes() {
        return totalResizeDataInMegaBytes;
    }

    /**
     * <p>
     * While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has
     * been processed so far. When the resize operation is complete, this value shows the total amount of data, in
     * megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount
     * of data before resize).
     * </p>
     * 
     * @return While the resize operation is in progress, this value shows the current amount of data, in megabytes,
     *         that has been processed so far. When the resize operation is complete, this value shows the total amount
     *         of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the
     *         estimated total amount of data before resize).
     */
    public final Long progressInMegaBytes() {
        return progressInMegaBytes;
    }

    /**
     * <p>
     * The amount of seconds that have elapsed since the resize operation began. After the resize operation completes,
     * this value shows the total actual time, in seconds, for the resize operation.
     * </p>
     * 
     * @return The amount of seconds that have elapsed since the resize operation began. After the resize operation
     *         completes, this value shows the total actual time, in seconds, for the resize operation.
     */
    public final Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based
     * on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation
     * is complete, this value will be 0.
     * </p>
     * 
     * @return The estimated time remaining, in seconds, until the resize operation is complete. This value is
     *         calculated based on the average resize rate and the estimated amount of data remaining to be processed.
     *         Once the resize operation is complete, this value will be 0.
     */
    public final Long estimatedTimeToCompletionInSeconds() {
        return estimatedTimeToCompletionInSeconds;
    }

    /**
     * <p>
     * An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe
     * the type of resize operation being performed.
     * </p>
     * 
     * @return An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values
     *         describe the type of resize operation being performed.
     */
    public final String resizeType() {
        return resizeType;
    }

    /**
     * <p>
     * An optional string to provide additional details about the resize action.
     * </p>
     * 
     * @return An optional string to provide additional details about the resize action.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The type of encryption for the cluster after the resize is complete.
     * </p>
     * <p>
     * Possible values are <code>KMS</code> and <code>None</code>.
     * </p>
     * 
     * @return The type of encryption for the cluster after the resize is complete.</p>
     *         <p>
     *         Possible values are <code>KMS</code> and <code>None</code>.
     */
    public final String targetEncryptionType() {
        return targetEncryptionType;
    }

    /**
     * <p>
     * The percent of data transferred from source cluster to target cluster.
     * </p>
     * 
     * @return The percent of data transferred from source cluster to target cluster.
     */
    public final Double dataTransferProgressPercent() {
        return dataTransferProgressPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(targetNumberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(targetClusterType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(hasImportTablesCompleted() ? importTablesCompleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImportTablesInProgress() ? importTablesInProgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImportTablesNotStarted() ? importTablesNotStarted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(avgResizeRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(totalResizeDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(resizeType());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(targetEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferProgressPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResizeResponse)) {
            return false;
        }
        DescribeResizeResponse other = (DescribeResizeResponse) obj;
        return Objects.equals(targetNodeType(), other.targetNodeType())
                && Objects.equals(targetNumberOfNodes(), other.targetNumberOfNodes())
                && Objects.equals(targetClusterType(), other.targetClusterType()) && Objects.equals(status(), other.status())
                && hasImportTablesCompleted() == other.hasImportTablesCompleted()
                && Objects.equals(importTablesCompleted(), other.importTablesCompleted())
                && hasImportTablesInProgress() == other.hasImportTablesInProgress()
                && Objects.equals(importTablesInProgress(), other.importTablesInProgress())
                && hasImportTablesNotStarted() == other.hasImportTablesNotStarted()
                && Objects.equals(importTablesNotStarted(), other.importTablesNotStarted())
                && Objects.equals(avgResizeRateInMegaBytesPerSecond(), other.avgResizeRateInMegaBytesPerSecond())
                && Objects.equals(totalResizeDataInMegaBytes(), other.totalResizeDataInMegaBytes())
                && Objects.equals(progressInMegaBytes(), other.progressInMegaBytes())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds())
                && Objects.equals(resizeType(), other.resizeType()) && Objects.equals(message(), other.message())
                && Objects.equals(targetEncryptionType(), other.targetEncryptionType())
                && Objects.equals(dataTransferProgressPercent(), other.dataTransferProgressPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResizeResponse").add("TargetNodeType", targetNodeType())
                .add("TargetNumberOfNodes", targetNumberOfNodes()).add("TargetClusterType", targetClusterType())
                .add("Status", status())
                .add("ImportTablesCompleted", hasImportTablesCompleted() ? importTablesCompleted() : null)
                .add("ImportTablesInProgress", hasImportTablesInProgress() ? importTablesInProgress() : null)
                .add("ImportTablesNotStarted", hasImportTablesNotStarted() ? importTablesNotStarted() : null)
                .add("AvgResizeRateInMegaBytesPerSecond", avgResizeRateInMegaBytesPerSecond())
                .add("TotalResizeDataInMegaBytes", totalResizeDataInMegaBytes())
                .add("ProgressInMegaBytes", progressInMegaBytes()).add("ElapsedTimeInSeconds", elapsedTimeInSeconds())
                .add("EstimatedTimeToCompletionInSeconds", estimatedTimeToCompletionInSeconds()).add("ResizeType", resizeType())
                .add("Message", message()).add("TargetEncryptionType", targetEncryptionType())
                .add("DataTransferProgressPercent", dataTransferProgressPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetNodeType":
            return Optional.ofNullable(clazz.cast(targetNodeType()));
        case "TargetNumberOfNodes":
            return Optional.ofNullable(clazz.cast(targetNumberOfNodes()));
        case "TargetClusterType":
            return Optional.ofNullable(clazz.cast(targetClusterType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ImportTablesCompleted":
            return Optional.ofNullable(clazz.cast(importTablesCompleted()));
        case "ImportTablesInProgress":
            return Optional.ofNullable(clazz.cast(importTablesInProgress()));
        case "ImportTablesNotStarted":
            return Optional.ofNullable(clazz.cast(importTablesNotStarted()));
        case "AvgResizeRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(avgResizeRateInMegaBytesPerSecond()));
        case "TotalResizeDataInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalResizeDataInMegaBytes()));
        case "ProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(progressInMegaBytes()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "EstimatedTimeToCompletionInSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompletionInSeconds()));
        case "ResizeType":
            return Optional.ofNullable(clazz.cast(resizeType()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "TargetEncryptionType":
            return Optional.ofNullable(clazz.cast(targetEncryptionType()));
        case "DataTransferProgressPercent":
            return Optional.ofNullable(clazz.cast(dataTransferProgressPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResizeResponse, T> g) {
        return obj -> g.apply((DescribeResizeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeResizeResponse> {
        /**
         * <p>
         * The node type that the cluster will have after the resize operation is complete.
         * </p>
         * 
         * @param targetNodeType
         *        The node type that the cluster will have after the resize operation is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNodeType(String targetNodeType);

        /**
         * <p>
         * The number of nodes that the cluster will have after the resize operation is complete.
         * </p>
         * 
         * @param targetNumberOfNodes
         *        The number of nodes that the cluster will have after the resize operation is complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetNumberOfNodes(Integer targetNumberOfNodes);

        /**
         * <p>
         * The cluster type after the resize operation is complete.
         * </p>
         * <p>
         * Valid Values: <code>multi-node</code> | <code>single-node</code>
         * </p>
         * 
         * @param targetClusterType
         *        The cluster type after the resize operation is complete.</p>
         *        <p>
         *        Valid Values: <code>multi-node</code> | <code>single-node</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetClusterType(String targetClusterType);

        /**
         * <p>
         * The status of the resize operation.
         * </p>
         * <p>
         * Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> |
         * <code>CANCELLING</code>
         * </p>
         * 
         * @param status
         *        The status of the resize operation.</p>
         *        <p>
         *        Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> |
         *        <code>SUCCEEDED</code> | <code>CANCELLING</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The names of tables that have been completely imported .
         * </p>
         * <p>
         * Valid Values: List of table names.
         * </p>
         * 
         * @param importTablesCompleted
         *        The names of tables that have been completely imported .</p>
         *        <p>
         *        Valid Values: List of table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesCompleted(Collection<String> importTablesCompleted);

        /**
         * <p>
         * The names of tables that have been completely imported .
         * </p>
         * <p>
         * Valid Values: List of table names.
         * </p>
         * 
         * @param importTablesCompleted
         *        The names of tables that have been completely imported .</p>
         *        <p>
         *        Valid Values: List of table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesCompleted(String... importTablesCompleted);

        /**
         * <p>
         * The names of tables that are being currently imported.
         * </p>
         * <p>
         * Valid Values: List of table names.
         * </p>
         * 
         * @param importTablesInProgress
         *        The names of tables that are being currently imported.</p>
         *        <p>
         *        Valid Values: List of table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesInProgress(Collection<String> importTablesInProgress);

        /**
         * <p>
         * The names of tables that are being currently imported.
         * </p>
         * <p>
         * Valid Values: List of table names.
         * </p>
         * 
         * @param importTablesInProgress
         *        The names of tables that are being currently imported.</p>
         *        <p>
         *        Valid Values: List of table names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesInProgress(String... importTablesInProgress);

        /**
         * <p>
         * The names of tables that have not been yet imported.
         * </p>
         * <p>
         * Valid Values: List of table names
         * </p>
         * 
         * @param importTablesNotStarted
         *        The names of tables that have not been yet imported.</p>
         *        <p>
         *        Valid Values: List of table names
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesNotStarted(Collection<String> importTablesNotStarted);

        /**
         * <p>
         * The names of tables that have not been yet imported.
         * </p>
         * <p>
         * Valid Values: List of table names
         * </p>
         * 
         * @param importTablesNotStarted
         *        The names of tables that have not been yet imported.</p>
         *        <p>
         *        Valid Values: List of table names
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTablesNotStarted(String... importTablesNotStarted);

        /**
         * <p>
         * The average rate of the resize operation over the last few minutes, measured in megabytes per second. After
         * the resize operation completes, this value shows the average rate of the entire resize operation.
         * </p>
         * 
         * @param avgResizeRateInMegaBytesPerSecond
         *        The average rate of the resize operation over the last few minutes, measured in megabytes per second.
         *        After the resize operation completes, this value shows the average rate of the entire resize
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder avgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond);

        /**
         * <p>
         * The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
         * </p>
         * 
         * @param totalResizeDataInMegaBytes
         *        The estimated total amount of data, in megabytes, on the cluster before the resize operation began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes);

        /**
         * <p>
         * While the resize operation is in progress, this value shows the current amount of data, in megabytes, that
         * has been processed so far. When the resize operation is complete, this value shows the total amount of data,
         * in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total
         * amount of data before resize).
         * </p>
         * 
         * @param progressInMegaBytes
         *        While the resize operation is in progress, this value shows the current amount of data, in megabytes,
         *        that has been processed so far. When the resize operation is complete, this value shows the total
         *        amount of data, in megabytes, on the cluster, which may be more or less than
         *        TotalResizeDataInMegaBytes (the estimated total amount of data before resize).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressInMegaBytes(Long progressInMegaBytes);

        /**
         * <p>
         * The amount of seconds that have elapsed since the resize operation began. After the resize operation
         * completes, this value shows the total actual time, in seconds, for the resize operation.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of seconds that have elapsed since the resize operation began. After the resize operation
         *        completes, this value shows the total actual time, in seconds, for the resize operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated
         * based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize
         * operation is complete, this value will be 0.
         * </p>
         * 
         * @param estimatedTimeToCompletionInSeconds
         *        The estimated time remaining, in seconds, until the resize operation is complete. This value is
         *        calculated based on the average resize rate and the estimated amount of data remaining to be
         *        processed. Once the resize operation is complete, this value will be 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds);

        /**
         * <p>
         * An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values
         * describe the type of resize operation being performed.
         * </p>
         * 
         * @param resizeType
         *        An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These
         *        values describe the type of resize operation being performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeType(String resizeType);

        /**
         * <p>
         * An optional string to provide additional details about the resize action.
         * </p>
         * 
         * @param message
         *        An optional string to provide additional details about the resize action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The type of encryption for the cluster after the resize is complete.
         * </p>
         * <p>
         * Possible values are <code>KMS</code> and <code>None</code>.
         * </p>
         * 
         * @param targetEncryptionType
         *        The type of encryption for the cluster after the resize is complete.</p>
         *        <p>
         *        Possible values are <code>KMS</code> and <code>None</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEncryptionType(String targetEncryptionType);

        /**
         * <p>
         * The percent of data transferred from source cluster to target cluster.
         * </p>
         * 
         * @param dataTransferProgressPercent
         *        The percent of data transferred from source cluster to target cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferProgressPercent(Double dataTransferProgressPercent);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String targetNodeType;

        private Integer targetNumberOfNodes;

        private String targetClusterType;

        private String status;

        private List<String> importTablesCompleted = DefaultSdkAutoConstructList.getInstance();

        private List<String> importTablesInProgress = DefaultSdkAutoConstructList.getInstance();

        private List<String> importTablesNotStarted = DefaultSdkAutoConstructList.getInstance();

        private Double avgResizeRateInMegaBytesPerSecond;

        private Long totalResizeDataInMegaBytes;

        private Long progressInMegaBytes;

        private Long elapsedTimeInSeconds;

        private Long estimatedTimeToCompletionInSeconds;

        private String resizeType;

        private String message;

        private String targetEncryptionType;

        private Double dataTransferProgressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResizeResponse model) {
            super(model);
            targetNodeType(model.targetNodeType);
            targetNumberOfNodes(model.targetNumberOfNodes);
            targetClusterType(model.targetClusterType);
            status(model.status);
            importTablesCompleted(model.importTablesCompleted);
            importTablesInProgress(model.importTablesInProgress);
            importTablesNotStarted(model.importTablesNotStarted);
            avgResizeRateInMegaBytesPerSecond(model.avgResizeRateInMegaBytesPerSecond);
            totalResizeDataInMegaBytes(model.totalResizeDataInMegaBytes);
            progressInMegaBytes(model.progressInMegaBytes);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            resizeType(model.resizeType);
            message(model.message);
            targetEncryptionType(model.targetEncryptionType);
            dataTransferProgressPercent(model.dataTransferProgressPercent);
        }

        public final String getTargetNodeType() {
            return targetNodeType;
        }

        public final void setTargetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
        }

        @Override
        public final Builder targetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
            return this;
        }

        public final Integer getTargetNumberOfNodes() {
            return targetNumberOfNodes;
        }

        public final void setTargetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
        }

        @Override
        public final Builder targetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
            return this;
        }

        public final String getTargetClusterType() {
            return targetClusterType;
        }

        public final void setTargetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
        }

        @Override
        public final Builder targetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getImportTablesCompleted() {
            if (importTablesCompleted instanceof SdkAutoConstructList) {
                return null;
            }
            return importTablesCompleted;
        }

        public final void setImportTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
        }

        @Override
        public final Builder importTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesCompleted(String... importTablesCompleted) {
            importTablesCompleted(Arrays.asList(importTablesCompleted));
            return this;
        }

        public final Collection<String> getImportTablesInProgress() {
            if (importTablesInProgress instanceof SdkAutoConstructList) {
                return null;
            }
            return importTablesInProgress;
        }

        public final void setImportTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
        }

        @Override
        public final Builder importTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesInProgress(String... importTablesInProgress) {
            importTablesInProgress(Arrays.asList(importTablesInProgress));
            return this;
        }

        public final Collection<String> getImportTablesNotStarted() {
            if (importTablesNotStarted instanceof SdkAutoConstructList) {
                return null;
            }
            return importTablesNotStarted;
        }

        public final void setImportTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
        }

        @Override
        public final Builder importTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesNotStarted(String... importTablesNotStarted) {
            importTablesNotStarted(Arrays.asList(importTablesNotStarted));
            return this;
        }

        public final Double getAvgResizeRateInMegaBytesPerSecond() {
            return avgResizeRateInMegaBytesPerSecond;
        }

        public final void setAvgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder avgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getTotalResizeDataInMegaBytes() {
            return totalResizeDataInMegaBytes;
        }

        public final void setTotalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
        }

        @Override
        public final Builder totalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
            return this;
        }

        public final Long getProgressInMegaBytes() {
            return progressInMegaBytes;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return estimatedTimeToCompletionInSeconds;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final String getResizeType() {
            return resizeType;
        }

        public final void setResizeType(String resizeType) {
            this.resizeType = resizeType;
        }

        @Override
        public final Builder resizeType(String resizeType) {
            this.resizeType = resizeType;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getTargetEncryptionType() {
            return targetEncryptionType;
        }

        public final void setTargetEncryptionType(String targetEncryptionType) {
            this.targetEncryptionType = targetEncryptionType;
        }

        @Override
        public final Builder targetEncryptionType(String targetEncryptionType) {
            this.targetEncryptionType = targetEncryptionType;
            return this;
        }

        public final Double getDataTransferProgressPercent() {
            return dataTransferProgressPercent;
        }

        public final void setDataTransferProgressPercent(Double dataTransferProgressPercent) {
            this.dataTransferProgressPercent = dataTransferProgressPercent;
        }

        @Override
        public final Builder dataTransferProgressPercent(Double dataTransferProgressPercent) {
            this.dataTransferProgressPercent = dataTransferProgressPercent;
            return this;
        }

        @Override
        public DescribeResizeResponse build() {
            return new DescribeResizeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
