/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSubnetGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSubnetGroup.Builder, ClusterSubnetGroup> {
    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSubnetGroupName").getter(getter(ClusterSubnetGroup::clusterSubnetGroupName))
            .setter(setter(Builder::clusterSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterSubnetGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ClusterSubnetGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetGroupStatus").getter(getter(ClusterSubnetGroup::subnetGroupStatus))
            .setter(setter(Builder::subnetGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()).build();

    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField
            .<List<Subnet>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(ClusterSubnetGroup::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Subnet")
                            .memberFieldInfo(
                                    SdkField.<Subnet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subnet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Subnet").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ClusterSubnetGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_CLUSTER_IP_ADDRESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedClusterIpAddressTypes")
            .getter(getter(ClusterSubnetGroup::supportedClusterIpAddressTypes))
            .setter(setter(Builder::supportedClusterIpAddressTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedClusterIpAddressTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("item").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SUBNET_GROUP_NAME_FIELD, DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD,
            TAGS_FIELD, SUPPORTED_CLUSTER_IP_ADDRESS_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterSubnetGroupName;

    private final String description;

    private final String vpcId;

    private final String subnetGroupStatus;

    private final List<Subnet> subnets;

    private final List<Tag> tags;

    private final List<String> supportedClusterIpAddressTypes;

    private ClusterSubnetGroup(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.tags = builder.tags;
        this.supportedClusterIpAddressTypes = builder.supportedClusterIpAddressTypes;
    }

    /**
     * <p>
     * The name of the cluster subnet group.
     * </p>
     * 
     * @return The name of the cluster subnet group.
     */
    public final String clusterSubnetGroupName() {
        return clusterSubnetGroupName;
    }

    /**
     * <p>
     * The description of the cluster subnet group.
     * </p>
     * 
     * @return The description of the cluster subnet group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The VPC ID of the cluster subnet group.
     * </p>
     * 
     * @return The VPC ID of the cluster subnet group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and
     * <code>Invalid</code>.
     * </p>
     * 
     * @return The status of the cluster subnet group. Possible values are <code>Complete</code>,
     *         <code>Incomplete</code> and <code>Invalid</code>.
     */
    public final String subnetGroupStatus() {
        return subnetGroupStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the VPC <a>Subnet</a> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return A list of the VPC <a>Subnet</a> elements.
     */
    public final List<Subnet> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags for the cluster subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of tags for the cluster subnet group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedClusterIpAddressTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedClusterIpAddressTypes() {
        return supportedClusterIpAddressTypes != null && !(supportedClusterIpAddressTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
     * <code>dualstack</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedClusterIpAddressTypes} method.
     * </p>
     * 
     * @return The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
     *         <code>dualstack</code>.
     */
    public final List<String> supportedClusterIpAddressTypes() {
        return supportedClusterIpAddressTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedClusterIpAddressTypes() ? supportedClusterIpAddressTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup) obj;
        return Objects.equals(clusterSubnetGroupName(), other.clusterSubnetGroupName())
                && Objects.equals(description(), other.description()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(subnetGroupStatus(), other.subnetGroupStatus()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && hasSupportedClusterIpAddressTypes() == other.hasSupportedClusterIpAddressTypes()
                && Objects.equals(supportedClusterIpAddressTypes(), other.supportedClusterIpAddressTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ClusterSubnetGroup")
                .add("ClusterSubnetGroupName", clusterSubnetGroupName())
                .add("Description", description())
                .add("VpcId", vpcId())
                .add("SubnetGroupStatus", subnetGroupStatus())
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("SupportedClusterIpAddressTypes",
                        hasSupportedClusterIpAddressTypes() ? supportedClusterIpAddressTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSubnetGroupName":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetGroupStatus":
            return Optional.ofNullable(clazz.cast(subnetGroupStatus()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SupportedClusterIpAddressTypes":
            return Optional.ofNullable(clazz.cast(supportedClusterIpAddressTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSubnetGroup, T> g) {
        return obj -> g.apply((ClusterSubnetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSubnetGroup> {
        /**
         * <p>
         * The name of the cluster subnet group.
         * </p>
         * 
         * @param clusterSubnetGroupName
         *        The name of the cluster subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroupName(String clusterSubnetGroupName);

        /**
         * <p>
         * The description of the cluster subnet group.
         * </p>
         * 
         * @param description
         *        The description of the cluster subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The VPC ID of the cluster subnet group.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the cluster subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code>
         * and <code>Invalid</code>.
         * </p>
         * 
         * @param subnetGroupStatus
         *        The status of the cluster subnet group. Possible values are <code>Complete</code>,
         *        <code>Incomplete</code> and <code>Invalid</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupStatus(String subnetGroupStatus);

        /**
         * <p>
         * A list of the VPC <a>Subnet</a> elements.
         * </p>
         * 
         * @param subnets
         *        A list of the VPC <a>Subnet</a> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<Subnet> subnets);

        /**
         * <p>
         * A list of the VPC <a>Subnet</a> elements.
         * </p>
         * 
         * @param subnets
         *        A list of the VPC <a>Subnet</a> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Subnet... subnets);

        /**
         * <p>
         * A list of the VPC <a>Subnet</a> elements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Subnet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshift.model.Subnet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Subnet.Builder#build()} is called immediately and its
         * result is passed to {@link #subnets(List<Subnet>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Subnet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(java.util.Collection<Subnet>)
         */
        Builder subnets(Consumer<Subnet.Builder>... subnets);

        /**
         * <p>
         * The list of tags for the cluster subnet group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster subnet group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster subnet group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
         * <code>dualstack</code>.
         * </p>
         * 
         * @param supportedClusterIpAddressTypes
         *        The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
         *        <code>dualstack</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes);

        /**
         * <p>
         * The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
         * <code>dualstack</code>.
         * </p>
         * 
         * @param supportedClusterIpAddressTypes
         *        The IP address types supported by this cluster subnet group. Possible values are <code>ipv4</code> and
         *        <code>dualstack</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedClusterIpAddressTypes(String... supportedClusterIpAddressTypes);
    }

    static final class BuilderImpl implements Builder {
        private String clusterSubnetGroupName;

        private String description;

        private String vpcId;

        private String subnetGroupStatus;

        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedClusterIpAddressTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSubnetGroup model) {
            clusterSubnetGroupName(model.clusterSubnetGroupName);
            description(model.description);
            vpcId(model.vpcId);
            subnetGroupStatus(model.subnetGroupStatus);
            subnets(model.subnets);
            tags(model.tags);
            supportedClusterIpAddressTypes(model.supportedClusterIpAddressTypes);
        }

        public final String getClusterSubnetGroupName() {
            return clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetGroupStatus() {
            return subnetGroupStatus;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> Subnet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedClusterIpAddressTypes() {
            if (supportedClusterIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedClusterIpAddressTypes;
        }

        public final void setSupportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes = ValueStringListCopier.copy(supportedClusterIpAddressTypes);
        }

        @Override
        public final Builder supportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes = ValueStringListCopier.copy(supportedClusterIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedClusterIpAddressTypes(String... supportedClusterIpAddressTypes) {
            supportedClusterIpAddressTypes(Arrays.asList(supportedClusterIpAddressTypes));
            return this;
        }

        @Override
        public ClusterSubnetGroup build() {
            return new ClusterSubnetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
