/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption;

public class GetReservedNodeExchangeConfigurationOptionsIterable
implements SdkIterable<GetReservedNodeExchangeConfigurationOptionsResponse> {
    private final RedshiftClient client;
    private final GetReservedNodeExchangeConfigurationOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetReservedNodeExchangeConfigurationOptionsIterable(RedshiftClient client, GetReservedNodeExchangeConfigurationOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetReservedNodeExchangeConfigurationOptionsResponseFetcher();
    }

    public Iterator<GetReservedNodeExchangeConfigurationOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNodeConfigurationOption> reservedNodeConfigurationOptionList() {
        Function<GetReservedNodeExchangeConfigurationOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeConfigurationOptionList() != null) {
                return response.reservedNodeConfigurationOptionList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetReservedNodeExchangeConfigurationOptionsResponseFetcher
    implements SyncPageFetcher<GetReservedNodeExchangeConfigurationOptionsResponse> {
        private GetReservedNodeExchangeConfigurationOptionsResponseFetcher() {
        }

        public boolean hasNextPage(GetReservedNodeExchangeConfigurationOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public GetReservedNodeExchangeConfigurationOptionsResponse nextPage(GetReservedNodeExchangeConfigurationOptionsResponse previousPage) {
            if (previousPage == null) {
                return GetReservedNodeExchangeConfigurationOptionsIterable.this.client.getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsIterable.this.firstRequest);
            }
            return GetReservedNodeExchangeConfigurationOptionsIterable.this.client.getReservedNodeExchangeConfigurationOptions((GetReservedNodeExchangeConfigurationOptionsRequest)((Object)GetReservedNodeExchangeConfigurationOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

