/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeInboundIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.InboundIntegration;

public class DescribeInboundIntegrationsIterable
implements SdkIterable<DescribeInboundIntegrationsResponse> {
    private final RedshiftClient client;
    private final DescribeInboundIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInboundIntegrationsIterable(RedshiftClient client, DescribeInboundIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInboundIntegrationsResponseFetcher();
    }

    public Iterator<DescribeInboundIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InboundIntegration> inboundIntegrations() {
        Function<DescribeInboundIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inboundIntegrations() != null) {
                return response.inboundIntegrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInboundIntegrationsResponseFetcher
    implements SyncPageFetcher<DescribeInboundIntegrationsResponse> {
        private DescribeInboundIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeInboundIntegrationsResponse nextPage(DescribeInboundIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundIntegrationsIterable.this.client.describeInboundIntegrations(DescribeInboundIntegrationsIterable.this.firstRequest);
            }
            return DescribeInboundIntegrationsIterable.this.client.describeInboundIntegrations((DescribeInboundIntegrationsRequest)((Object)DescribeInboundIntegrationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

