/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorageResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeStorageResponse.Builder, DescribeStorageResponse> {
    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalBackupSizeInMegaBytes")
            .getter(getter(DescribeStorageResponse::totalBackupSizeInMegaBytes))
            .setter(setter(Builder::totalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBackupSizeInMegaBytes").build())
            .build();

    private static final SdkField<Double> TOTAL_PROVISIONED_STORAGE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("TotalProvisionedStorageInMegaBytes")
            .getter(getter(DescribeStorageResponse::totalProvisionedStorageInMegaBytes))
            .setter(setter(Builder::totalProvisionedStorageInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalProvisionedStorageInMegaBytes")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, TOTAL_PROVISIONED_STORAGE_IN_MEGA_BYTES_FIELD));

    private final Double totalBackupSizeInMegaBytes;

    private final Double totalProvisionedStorageInMegaBytes;

    private DescribeStorageResponse(BuilderImpl builder) {
        super(builder);
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.totalProvisionedStorageInMegaBytes = builder.totalProvisionedStorageInMegaBytes;
    }

    /**
     * <p>
     * The total amount of storage currently used for snapshots.
     * </p>
     * 
     * @return The total amount of storage currently used for snapshots.
     */
    public final Double totalBackupSizeInMegaBytes() {
        return totalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The total amount of storage currently provisioned.
     * </p>
     * 
     * @return The total amount of storage currently provisioned.
     */
    public final Double totalProvisionedStorageInMegaBytes() {
        return totalProvisionedStorageInMegaBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(totalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(totalProvisionedStorageInMegaBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageResponse)) {
            return false;
        }
        DescribeStorageResponse other = (DescribeStorageResponse) obj;
        return Objects.equals(totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes())
                && Objects.equals(totalProvisionedStorageInMegaBytes(), other.totalProvisionedStorageInMegaBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStorageResponse").add("TotalBackupSizeInMegaBytes", totalBackupSizeInMegaBytes())
                .add("TotalProvisionedStorageInMegaBytes", totalProvisionedStorageInMegaBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalBackupSizeInMegaBytes()));
        case "TotalProvisionedStorageInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalProvisionedStorageInMegaBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageResponse, T> g) {
        return obj -> g.apply((DescribeStorageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStorageResponse> {
        /**
         * <p>
         * The total amount of storage currently used for snapshots.
         * </p>
         * 
         * @param totalBackupSizeInMegaBytes
         *        The total amount of storage currently used for snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes);

        /**
         * <p>
         * The total amount of storage currently provisioned.
         * </p>
         * 
         * @param totalProvisionedStorageInMegaBytes
         *        The total amount of storage currently provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalProvisionedStorageInMegaBytes(Double totalProvisionedStorageInMegaBytes);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private Double totalBackupSizeInMegaBytes;

        private Double totalProvisionedStorageInMegaBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageResponse model) {
            super(model);
            totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            totalProvisionedStorageInMegaBytes(model.totalProvisionedStorageInMegaBytes);
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return totalBackupSizeInMegaBytes;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final Double getTotalProvisionedStorageInMegaBytes() {
            return totalProvisionedStorageInMegaBytes;
        }

        public final void setTotalProvisionedStorageInMegaBytes(Double totalProvisionedStorageInMegaBytes) {
            this.totalProvisionedStorageInMegaBytes = totalProvisionedStorageInMegaBytes;
        }

        @Override
        public final Builder totalProvisionedStorageInMegaBytes(Double totalProvisionedStorageInMegaBytes) {
            this.totalProvisionedStorageInMegaBytes = totalProvisionedStorageInMegaBytes;
            return this;
        }

        @Override
        public DescribeStorageResponse build() {
            return new DescribeStorageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
