/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a partner integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartnerIntegrationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<PartnerIntegrationInfo.Builder, PartnerIntegrationInfo> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(PartnerIntegrationInfo::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> PARTNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartnerName").getter(getter(PartnerIntegrationInfo::partnerName)).setter(setter(Builder::partnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PartnerIntegrationInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(PartnerIntegrationInfo::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PartnerIntegrationInfo::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(PartnerIntegrationInfo::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            PARTNER_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String partnerName;

    private final String status;

    private final String statusMessage;

    private final Instant createdAt;

    private final Instant updatedAt;

    private PartnerIntegrationInfo(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.partnerName = builder.partnerName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The name of the database that receives data from a partner.
     * </p>
     * 
     * @return The name of the database that receives data from a partner.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the partner.
     * </p>
     * 
     * @return The name of the partner.
     */
    public final String partnerName() {
        return partnerName;
    }

    /**
     * <p>
     * The partner integration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The partner integration status.
     * @see PartnerIntegrationStatus
     */
    public final PartnerIntegrationStatus status() {
        return PartnerIntegrationStatus.fromValue(status);
    }

    /**
     * <p>
     * The partner integration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PartnerIntegrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The partner integration status.
     * @see PartnerIntegrationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message provided by the partner.
     * </p>
     * 
     * @return The status message provided by the partner.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date (UTC) that the partner integration was created.
     * </p>
     * 
     * @return The date (UTC) that the partner integration was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date (UTC) that the partner integration status was last updated by the partner.
     * </p>
     * 
     * @return The date (UTC) that the partner integration status was last updated by the partner.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(partnerName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerIntegrationInfo)) {
            return false;
        }
        PartnerIntegrationInfo other = (PartnerIntegrationInfo) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(partnerName(), other.partnerName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartnerIntegrationInfo").add("DatabaseName", databaseName()).add("PartnerName", partnerName())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "PartnerName":
            return Optional.ofNullable(clazz.cast(partnerName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartnerIntegrationInfo, T> g) {
        return obj -> g.apply((PartnerIntegrationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartnerIntegrationInfo> {
        /**
         * <p>
         * The name of the database that receives data from a partner.
         * </p>
         * 
         * @param databaseName
         *        The name of the database that receives data from a partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the partner.
         * </p>
         * 
         * @param partnerName
         *        The name of the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerName(String partnerName);

        /**
         * <p>
         * The partner integration status.
         * </p>
         * 
         * @param status
         *        The partner integration status.
         * @see PartnerIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerIntegrationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The partner integration status.
         * </p>
         * 
         * @param status
         *        The partner integration status.
         * @see PartnerIntegrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartnerIntegrationStatus
         */
        Builder status(PartnerIntegrationStatus status);

        /**
         * <p>
         * The status message provided by the partner.
         * </p>
         * 
         * @param statusMessage
         *        The status message provided by the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date (UTC) that the partner integration was created.
         * </p>
         * 
         * @param createdAt
         *        The date (UTC) that the partner integration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date (UTC) that the partner integration status was last updated by the partner.
         * </p>
         * 
         * @param updatedAt
         *        The date (UTC) that the partner integration status was last updated by the partner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String partnerName;

        private String status;

        private String statusMessage;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerIntegrationInfo model) {
            databaseName(model.databaseName);
            partnerName(model.partnerName);
            status(model.status);
            statusMessage(model.statusMessage);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getPartnerName() {
            return partnerName;
        }

        public final void setPartnerName(String partnerName) {
            this.partnerName = partnerName;
        }

        @Override
        public final Builder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PartnerIntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public PartnerIntegrationInfo build() {
            return new PartnerIntegrationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
