/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;

public class DescribeClusterSubnetGroupsIterable
implements SdkIterable<DescribeClusterSubnetGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterSubnetGroupsIterable(RedshiftClient client, DescribeClusterSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSubnetGroup> clusterSubnetGroups() {
        Function<DescribeClusterSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSubnetGroups() != null) {
                return response.clusterSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClusterSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeClusterSubnetGroupsResponse> {
        private DescribeClusterSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeClusterSubnetGroupsResponse nextPage(DescribeClusterSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSubnetGroupsIterable.this.client.describeClusterSubnetGroups(DescribeClusterSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeClusterSubnetGroupsIterable.this.client.describeClusterSubnetGroups((DescribeClusterSubnetGroupsRequest)((Object)DescribeClusterSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

