/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resize operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResizeInfo implements SdkPojo, Serializable, ToCopyableBuilder<ResizeInfo.Builder, ResizeInfo> {
    private static final SdkField<String> RESIZE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResizeType").getter(getter(ResizeInfo::resizeType)).setter(setter(Builder::resizeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeType").build()).build();

    private static final SdkField<Boolean> ALLOW_CANCEL_RESIZE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCancelResize").getter(getter(ResizeInfo::allowCancelResize))
            .setter(setter(Builder::allowCancelResize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCancelResize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESIZE_TYPE_FIELD,
            ALLOW_CANCEL_RESIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resizeType;

    private final Boolean allowCancelResize;

    private ResizeInfo(BuilderImpl builder) {
        this.resizeType = builder.resizeType;
        this.allowCancelResize = builder.allowCancelResize;
    }

    /**
     * <p>
     * Returns the value <code>ClassicResize</code>.
     * </p>
     * 
     * @return Returns the value <code>ClassicResize</code>.
     */
    public final String resizeType() {
        return resizeType;
    }

    /**
     * <p>
     * A boolean value indicating if the resize operation can be cancelled.
     * </p>
     * 
     * @return A boolean value indicating if the resize operation can be cancelled.
     */
    public final Boolean allowCancelResize() {
        return allowCancelResize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resizeType());
        hashCode = 31 * hashCode + Objects.hashCode(allowCancelResize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResizeInfo)) {
            return false;
        }
        ResizeInfo other = (ResizeInfo) obj;
        return Objects.equals(resizeType(), other.resizeType()) && Objects.equals(allowCancelResize(), other.allowCancelResize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResizeInfo").add("ResizeType", resizeType()).add("AllowCancelResize", allowCancelResize())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResizeType":
            return Optional.ofNullable(clazz.cast(resizeType()));
        case "AllowCancelResize":
            return Optional.ofNullable(clazz.cast(allowCancelResize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResizeInfo, T> g) {
        return obj -> g.apply((ResizeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResizeInfo> {
        /**
         * <p>
         * Returns the value <code>ClassicResize</code>.
         * </p>
         * 
         * @param resizeType
         *        Returns the value <code>ClassicResize</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeType(String resizeType);

        /**
         * <p>
         * A boolean value indicating if the resize operation can be cancelled.
         * </p>
         * 
         * @param allowCancelResize
         *        A boolean value indicating if the resize operation can be cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCancelResize(Boolean allowCancelResize);
    }

    static final class BuilderImpl implements Builder {
        private String resizeType;

        private Boolean allowCancelResize;

        private BuilderImpl() {
        }

        private BuilderImpl(ResizeInfo model) {
            resizeType(model.resizeType);
            allowCancelResize(model.allowCancelResize);
        }

        public final String getResizeType() {
            return resizeType;
        }

        public final void setResizeType(String resizeType) {
            this.resizeType = resizeType;
        }

        @Override
        @Transient
        public final Builder resizeType(String resizeType) {
            this.resizeType = resizeType;
            return this;
        }

        public final Boolean getAllowCancelResize() {
            return allowCancelResize;
        }

        public final void setAllowCancelResize(Boolean allowCancelResize) {
            this.allowCancelResize = allowCancelResize;
        }

        @Override
        @Transient
        public final Builder allowCancelResize(Boolean allowCancelResize) {
            this.allowCancelResize = allowCancelResize;
            return this;
        }

        @Override
        public ResizeInfo build() {
            return new ResizeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
