/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a reserved node offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedNodeOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedNodeOffering.Builder, ReservedNodeOffering> {
    private static final SdkField<String> RESERVED_NODE_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeOfferingId").getter(getter(ReservedNodeOffering::reservedNodeOfferingId))
            .setter(setter(Builder::reservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingId").build())
            .build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(ReservedNodeOffering::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedNodeOffering::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedNodeOffering::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(ReservedNodeOffering::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservedNodeOffering::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(ReservedNodeOffering::offeringType)).setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedNodeOffering::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RecurringCharge")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RecurringCharge").build()).build()).build()).build();

    private static final SdkField<String> RESERVED_NODE_OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeOfferingType").getter(getter(ReservedNodeOffering::reservedNodeOfferingTypeAsString))
            .setter(setter(Builder::reservedNodeOfferingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_NODE_OFFERING_ID_FIELD, NODE_TYPE_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD,
            CURRENCY_CODE_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD, RESERVED_NODE_OFFERING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservedNodeOfferingId;

    private final String nodeType;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final String offeringType;

    private final List<RecurringCharge> recurringCharges;

    private final String reservedNodeOfferingType;

    private ReservedNodeOffering(BuilderImpl builder) {
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeType = builder.nodeType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.reservedNodeOfferingType = builder.reservedNodeOfferingType;
    }

    /**
     * <p>
     * The offering identifier.
     * </p>
     * 
     * @return The offering identifier.
     */
    public final String reservedNodeOfferingId() {
        return reservedNodeOfferingId;
    }

    /**
     * <p>
     * The node type offered by the reserved node offering.
     * </p>
     * 
     * @return The node type offered by the reserved node offering.
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The duration, in seconds, for which the offering will reserve the node.
     * </p>
     * 
     * @return The duration, in seconds, for which the offering will reserve the node.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The upfront fixed charge you will pay to purchase the specific reserved node offering.
     * </p>
     * 
     * @return The upfront fixed charge you will pay to purchase the specific reserved node offering.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The rate you are charged for each hour the cluster that is using the offering is running.
     * </p>
     * 
     * @return The rate you are charged for each hour the cluster that is using the offering is running.
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the compute nodes offering.
     * </p>
     * 
     * @return The currency code for the compute nodes offering.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The anticipated utilization of the reserved node, as defined in the reserved node offering.
     * </p>
     * 
     * @return The anticipated utilization of the reserved node, as defined in the reserved node offering.
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecurringCharges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring
     * charges are only in effect for heavy-utilization reserved nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecurringCharges} method.
     * </p>
     * 
     * @return The charge to your account regardless of whether you are creating any clusters using the node offering.
     *         Recurring charges are only in effect for heavy-utilization reserved nodes.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedNodeOfferingType} will return {@link ReservedNodeOfferingType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #reservedNodeOfferingTypeAsString}.
     * </p>
     * 
     * @return
     * @see ReservedNodeOfferingType
     */
    public final ReservedNodeOfferingType reservedNodeOfferingType() {
        return ReservedNodeOfferingType.fromValue(reservedNodeOfferingType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedNodeOfferingType} will return {@link ReservedNodeOfferingType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #reservedNodeOfferingTypeAsString}.
     * </p>
     * 
     * @return
     * @see ReservedNodeOfferingType
     */
    public final String reservedNodeOfferingTypeAsString() {
        return reservedNodeOfferingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeOfferingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodeOffering)) {
            return false;
        }
        ReservedNodeOffering other = (ReservedNodeOffering) obj;
        return Objects.equals(reservedNodeOfferingId(), other.reservedNodeOfferingId())
                && Objects.equals(nodeType(), other.nodeType()) && Objects.equals(duration(), other.duration())
                && Objects.equals(fixedPrice(), other.fixedPrice()) && Objects.equals(usagePrice(), other.usagePrice())
                && Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(offeringType(), other.offeringType())
                && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(reservedNodeOfferingTypeAsString(), other.reservedNodeOfferingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedNodeOffering").add("ReservedNodeOfferingId", reservedNodeOfferingId())
                .add("NodeType", nodeType()).add("Duration", duration()).add("FixedPrice", fixedPrice())
                .add("UsagePrice", usagePrice()).add("CurrencyCode", currencyCode()).add("OfferingType", offeringType())
                .add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null)
                .add("ReservedNodeOfferingType", reservedNodeOfferingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(reservedNodeOfferingId()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "ReservedNodeOfferingType":
            return Optional.ofNullable(clazz.cast(reservedNodeOfferingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodeOffering, T> g) {
        return obj -> g.apply((ReservedNodeOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedNodeOffering> {
        /**
         * <p>
         * The offering identifier.
         * </p>
         * 
         * @param reservedNodeOfferingId
         *        The offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeOfferingId(String reservedNodeOfferingId);

        /**
         * <p>
         * The node type offered by the reserved node offering.
         * </p>
         * 
         * @param nodeType
         *        The node type offered by the reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The duration, in seconds, for which the offering will reserve the node.
         * </p>
         * 
         * @param duration
         *        The duration, in seconds, for which the offering will reserve the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The upfront fixed charge you will pay to purchase the specific reserved node offering.
         * </p>
         * 
         * @param fixedPrice
         *        The upfront fixed charge you will pay to purchase the specific reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The rate you are charged for each hour the cluster that is using the offering is running.
         * </p>
         * 
         * @param usagePrice
         *        The rate you are charged for each hour the cluster that is using the offering is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the compute nodes offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the compute nodes offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The anticipated utilization of the reserved node, as defined in the reserved node offering.
         * </p>
         * 
         * @param offeringType
         *        The anticipated utilization of the reserved node, as defined in the reserved node offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any clusters using the node offering.
         * Recurring charges are only in effect for heavy-utilization reserved nodes.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any clusters using the node
         *        offering. Recurring charges are only in effect for heavy-utilization reserved nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any clusters using the node offering.
         * Recurring charges are only in effect for heavy-utilization reserved nodes.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any clusters using the node
         *        offering. Recurring charges are only in effect for heavy-utilization reserved nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any clusters using the node offering.
         * Recurring charges are only in effect for heavy-utilization reserved nodes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecurringCharge>.Builder} avoiding the need
         * to create one manually via {@link List<RecurringCharge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecurringCharge>.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on {@link List<RecurringCharge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(List<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p/>
         * 
         * @param reservedNodeOfferingType
         * @see ReservedNodeOfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeOfferingType
         */
        Builder reservedNodeOfferingType(String reservedNodeOfferingType);

        /**
         * <p/>
         * 
         * @param reservedNodeOfferingType
         * @see ReservedNodeOfferingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedNodeOfferingType
         */
        Builder reservedNodeOfferingType(ReservedNodeOfferingType reservedNodeOfferingType);
    }

    static final class BuilderImpl implements Builder {
        private String reservedNodeOfferingId;

        private String nodeType;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private String offeringType;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String reservedNodeOfferingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodeOffering model) {
            reservedNodeOfferingId(model.reservedNodeOfferingId);
            nodeType(model.nodeType);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            offeringType(model.offeringType);
            recurringCharges(model.recurringCharges);
            reservedNodeOfferingType(model.reservedNodeOfferingType);
        }

        public final String getReservedNodeOfferingId() {
            return reservedNodeOfferingId;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        @Override
        @Transient
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        @Transient
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        @Transient
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        @Transient
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        @Transient
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        @Transient
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReservedNodeOfferingType() {
            return reservedNodeOfferingType;
        }

        public final void setReservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
        }

        @Override
        @Transient
        public final Builder reservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
            return this;
        }

        @Override
        @Transient
        public final Builder reservedNodeOfferingType(ReservedNodeOfferingType reservedNodeOfferingType) {
            this.reservedNodeOfferingType(reservedNodeOfferingType == null ? null : reservedNodeOfferingType.toString());
            return this;
        }

        @Override
        public ReservedNodeOffering build() {
            return new ReservedNodeOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
