/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ParameterGroupListCopier {
    static List<ClusterParameterGroup> copy(Collection<? extends ClusterParameterGroup> parameterGroupListParam) {
        List<ClusterParameterGroup> list;
        if (parameterGroupListParam == null || parameterGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterParameterGroup> modifiableList = new ArrayList<>();
            parameterGroupListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ClusterParameterGroup> copyFromBuilder(Collection<? extends ClusterParameterGroup.Builder> parameterGroupListParam) {
        List<ClusterParameterGroup> list;
        if (parameterGroupListParam == null || parameterGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterParameterGroup> modifiableList = new ArrayList<>();
            parameterGroupListParam.forEach(entry -> {
                ClusterParameterGroup member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ClusterParameterGroup.Builder> copyToBuilder(Collection<? extends ClusterParameterGroup> parameterGroupListParam) {
        List<ClusterParameterGroup.Builder> list;
        if (parameterGroupListParam == null || parameterGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ClusterParameterGroup.Builder> modifiableList = new ArrayList<>();
            parameterGroupListParam.forEach(entry -> {
                ClusterParameterGroup.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
