/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterDbRevisionRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyClusterDbRevisionRequest.Builder, ModifyClusterDbRevisionRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyClusterDbRevisionRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> REVISION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionTarget").getter(getter(ModifyClusterDbRevisionRequest::revisionTarget))
            .setter(setter(Builder::revisionTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            REVISION_TARGET_FIELD));

    private final String clusterIdentifier;

    private final String revisionTarget;

    private ModifyClusterDbRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.revisionTarget = builder.revisionTarget;
    }

    /**
     * <p>
     * The unique identifier of a cluster whose database revision you want to modify.
     * </p>
     * <p>
     * Example: <code>examplecluster</code>
     * </p>
     * 
     * @return The unique identifier of a cluster whose database revision you want to modify. </p>
     *         <p>
     *         Example: <code>examplecluster</code>
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the database revision. You can retrieve this value from the response to the
     * <a>DescribeClusterDbRevisions</a> request.
     * </p>
     * 
     * @return The identifier of the database revision. You can retrieve this value from the response to the
     *         <a>DescribeClusterDbRevisions</a> request.
     */
    public final String revisionTarget() {
        return revisionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(revisionTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterDbRevisionRequest)) {
            return false;
        }
        ModifyClusterDbRevisionRequest other = (ModifyClusterDbRevisionRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(revisionTarget(), other.revisionTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterDbRevisionRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("RevisionTarget", revisionTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "RevisionTarget":
            return Optional.ofNullable(clazz.cast(revisionTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterDbRevisionRequest, T> g) {
        return obj -> g.apply((ModifyClusterDbRevisionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClusterDbRevisionRequest> {
        /**
         * <p>
         * The unique identifier of a cluster whose database revision you want to modify.
         * </p>
         * <p>
         * Example: <code>examplecluster</code>
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of a cluster whose database revision you want to modify. </p>
         *        <p>
         *        Example: <code>examplecluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the database revision. You can retrieve this value from the response to the
         * <a>DescribeClusterDbRevisions</a> request.
         * </p>
         * 
         * @param revisionTarget
         *        The identifier of the database revision. You can retrieve this value from the response to the
         *        <a>DescribeClusterDbRevisions</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionTarget(String revisionTarget);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String revisionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterDbRevisionRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            revisionTarget(model.revisionTarget);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getRevisionTarget() {
            return revisionTarget;
        }

        public final void setRevisionTarget(String revisionTarget) {
            this.revisionTarget = revisionTarget;
        }

        @Override
        @Transient
        public final Builder revisionTarget(String revisionTarget) {
            this.revisionTarget = revisionTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterDbRevisionRequest build() {
            return new ModifyClusterDbRevisionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
