/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAquaConfigurationResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyAquaConfigurationResponse.Builder, ModifyAquaConfigurationResponse> {
    private static final SdkField<AquaConfiguration> AQUA_CONFIGURATION_FIELD = SdkField
            .<AquaConfiguration> builder(MarshallingType.SDK_POJO).memberName("AquaConfiguration")
            .getter(getter(ModifyAquaConfigurationResponse::aquaConfiguration)).setter(setter(Builder::aquaConfiguration))
            .constructor(AquaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AQUA_CONFIGURATION_FIELD));

    private final AquaConfiguration aquaConfiguration;

    private ModifyAquaConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.aquaConfiguration = builder.aquaConfiguration;
    }

    /**
     * <p>
     * The updated AQUA configuration of the cluster.
     * </p>
     * 
     * @return The updated AQUA configuration of the cluster.
     */
    public final AquaConfiguration aquaConfiguration() {
        return aquaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aquaConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAquaConfigurationResponse)) {
            return false;
        }
        ModifyAquaConfigurationResponse other = (ModifyAquaConfigurationResponse) obj;
        return Objects.equals(aquaConfiguration(), other.aquaConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyAquaConfigurationResponse").add("AquaConfiguration", aquaConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AquaConfiguration":
            return Optional.ofNullable(clazz.cast(aquaConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyAquaConfigurationResponse, T> g) {
        return obj -> g.apply((ModifyAquaConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, ModifyAquaConfigurationResponse> {
        /**
         * <p>
         * The updated AQUA configuration of the cluster.
         * </p>
         * 
         * @param aquaConfiguration
         *        The updated AQUA configuration of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aquaConfiguration(AquaConfiguration aquaConfiguration);

        /**
         * <p>
         * The updated AQUA configuration of the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link AquaConfiguration.Builder} avoiding the need to
         * create one manually via {@link AquaConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AquaConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #aquaConfiguration(AquaConfiguration)}.
         * 
         * @param aquaConfiguration
         *        a consumer that will call methods on {@link AquaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aquaConfiguration(AquaConfiguration)
         */
        default Builder aquaConfiguration(Consumer<AquaConfiguration.Builder> aquaConfiguration) {
            return aquaConfiguration(AquaConfiguration.builder().applyMutation(aquaConfiguration).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private AquaConfiguration aquaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAquaConfigurationResponse model) {
            super(model);
            aquaConfiguration(model.aquaConfiguration);
        }

        public final AquaConfiguration.Builder getAquaConfiguration() {
            return aquaConfiguration != null ? aquaConfiguration.toBuilder() : null;
        }

        public final void setAquaConfiguration(AquaConfiguration.BuilderImpl aquaConfiguration) {
            this.aquaConfiguration = aquaConfiguration != null ? aquaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder aquaConfiguration(AquaConfiguration aquaConfiguration) {
            this.aquaConfiguration = aquaConfiguration;
            return this;
        }

        @Override
        public ModifyAquaConfigurationResponse build() {
            return new ModifyAquaConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
