/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyAquaConfigurationRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyAquaConfigurationRequest.Builder, ModifyAquaConfigurationRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyAquaConfigurationRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> AQUA_CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AquaConfigurationStatus")
            .getter(getter(ModifyAquaConfigurationRequest::aquaConfigurationStatusAsString))
            .setter(setter(Builder::aquaConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfigurationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            AQUA_CONFIGURATION_STATUS_FIELD));

    private final String clusterIdentifier;

    private final String aquaConfigurationStatus;

    private ModifyAquaConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
    }

    /**
     * <p>
     * The identifier of the cluster to be modified.
     * </p>
     * 
     * @return The identifier of the cluster to be modified.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The new value of AQUA configuration status. Possible values include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
     * </p>
     * </li>
     * <li>
     * <p>
     * disabled - Don't use AQUA.
     * </p>
     * </li>
     * <li>
     * <p>
     * auto - Amazon Redshift determines whether to use AQUA.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return The new value of AQUA configuration status. Possible values include the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node
     *         type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         disabled - Don't use AQUA.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         auto - Amazon Redshift determines whether to use AQUA.
     *         </p>
     *         </li>
     * @see AquaConfigurationStatus
     */
    public final AquaConfigurationStatus aquaConfigurationStatus() {
        return AquaConfigurationStatus.fromValue(aquaConfigurationStatus);
    }

    /**
     * <p>
     * The new value of AQUA configuration status. Possible values include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.
     * </p>
     * </li>
     * <li>
     * <p>
     * disabled - Don't use AQUA.
     * </p>
     * </li>
     * <li>
     * <p>
     * auto - Amazon Redshift determines whether to use AQUA.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aquaConfigurationStatus} will return {@link AquaConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #aquaConfigurationStatusAsString}.
     * </p>
     * 
     * @return The new value of AQUA configuration status. Possible values include the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node
     *         type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         disabled - Don't use AQUA.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         auto - Amazon Redshift determines whether to use AQUA.
     *         </p>
     *         </li>
     * @see AquaConfigurationStatus
     */
    public final String aquaConfigurationStatusAsString() {
        return aquaConfigurationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(aquaConfigurationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyAquaConfigurationRequest)) {
            return false;
        }
        ModifyAquaConfigurationRequest other = (ModifyAquaConfigurationRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(aquaConfigurationStatusAsString(), other.aquaConfigurationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyAquaConfigurationRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("AquaConfigurationStatus", aquaConfigurationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "AquaConfigurationStatus":
            return Optional.ofNullable(clazz.cast(aquaConfigurationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyAquaConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyAquaConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyAquaConfigurationRequest> {
        /**
         * <p>
         * The identifier of the cluster to be modified.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The new value of AQUA configuration status. Possible values include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node
         * type.
         * </p>
         * </li>
         * <li>
         * <p>
         * disabled - Don't use AQUA.
         * </p>
         * </li>
         * <li>
         * <p>
         * auto - Amazon Redshift determines whether to use AQUA.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aquaConfigurationStatus
         *        The new value of AQUA configuration status. Possible values include the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift
         *        node type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        disabled - Don't use AQUA.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        auto - Amazon Redshift determines whether to use AQUA.
         *        </p>
         *        </li>
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(String aquaConfigurationStatus);

        /**
         * <p>
         * The new value of AQUA configuration status. Possible values include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node
         * type.
         * </p>
         * </li>
         * <li>
         * <p>
         * disabled - Don't use AQUA.
         * </p>
         * </li>
         * <li>
         * <p>
         * auto - Amazon Redshift determines whether to use AQUA.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aquaConfigurationStatus
         *        The new value of AQUA configuration status. Possible values include the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift
         *        node type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        disabled - Don't use AQUA.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        auto - Amazon Redshift determines whether to use AQUA.
         *        </p>
         *        </li>
         * @see AquaConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AquaConfigurationStatus
         */
        Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String aquaConfigurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyAquaConfigurationRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            aquaConfigurationStatus(model.aquaConfigurationStatus);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getAquaConfigurationStatus() {
            return aquaConfigurationStatus;
        }

        public final void setAquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
        }

        @Override
        @Transient
        public final Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus) {
            this.aquaConfigurationStatus(aquaConfigurationStatus == null ? null : aquaConfigurationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyAquaConfigurationRequest build() {
            return new ModifyAquaConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
