/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes event categories.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventCategoriesMap implements SdkPojo, Serializable,
        ToCopyableBuilder<EventCategoriesMap.Builder, EventCategoriesMap> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(EventCategoriesMap::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<EventInfoMap>> EVENTS_FIELD = SdkField
            .<List<EventInfoMap>> builder(MarshallingType.LIST)
            .memberName("Events")
            .getter(getter(EventCategoriesMap::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventInfoMap")
                            .memberFieldInfo(
                                    SdkField.<EventInfoMap> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventInfoMap::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventInfoMap").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final List<EventInfoMap> events;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.events = builder.events;
    }

    /**
     * <p>
     * The source type, such as cluster or cluster-snapshot, that the returned categories belong to.
     * </p>
     * 
     * @return The source type, such as cluster or cluster-snapshot, that the returned categories belong to.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The events in the event category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The events in the event category.
     */
    public final List<EventInfoMap> events() {
        return events;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap) obj;
        return Objects.equals(sourceType(), other.sourceType()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventCategoriesMap").add("SourceType", sourceType())
                .add("Events", hasEvents() ? events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "Events":
            return Optional.ofNullable(clazz.cast(events()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventCategoriesMap, T> g) {
        return obj -> g.apply((EventCategoriesMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventCategoriesMap> {
        /**
         * <p>
         * The source type, such as cluster or cluster-snapshot, that the returned categories belong to.
         * </p>
         * 
         * @param sourceType
         *        The source type, such as cluster or cluster-snapshot, that the returned categories belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The events in the event category.
         * </p>
         * 
         * @param events
         *        The events in the event category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<EventInfoMap> events);

        /**
         * <p>
         * The events in the event category.
         * </p>
         * 
         * @param events
         *        The events in the event category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(EventInfoMap... events);

        /**
         * <p>
         * The events in the event category.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventInfoMap>.Builder} avoiding the need to
         * create one manually via {@link List<EventInfoMap>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventInfoMap>.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<EventInfoMap>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<EventInfoMap>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<EventInfoMap>)
         */
        Builder events(Consumer<EventInfoMap.Builder>... events);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private List<EventInfoMap> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            sourceType(model.sourceType);
            events(model.events);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final List<EventInfoMap.Builder> getEvents() {
            List<EventInfoMap.Builder> result = EventInfoMapListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<EventInfoMap.BuilderImpl> events) {
            this.events = EventInfoMapListCopier.copyFromBuilder(events);
        }

        @Override
        @Transient
        public final Builder events(Collection<EventInfoMap> events) {
            this.events = EventInfoMapListCopier.copy(events);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(EventInfoMap... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder events(Consumer<EventInfoMap.Builder>... events) {
            events(Stream.of(events).map(c -> EventInfoMap.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
