/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTagsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private static final SdkField<List<TaggedResource>> TAGGED_RESOURCES_FIELD = SdkField
            .<List<TaggedResource>> builder(MarshallingType.LIST)
            .memberName("TaggedResources")
            .getter(getter(DescribeTagsResponse::taggedResources))
            .setter(setter(Builder::taggedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaggedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TaggedResource")
                            .memberFieldInfo(
                                    SdkField.<TaggedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaggedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TaggedResource").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTagsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGGED_RESOURCES_FIELD,
            MARKER_FIELD));

    private final List<TaggedResource> taggedResources;

    private final String marker;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.taggedResources = builder.taggedResources;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaggedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaggedResources() {
        return taggedResources != null && !(taggedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags with their associated resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaggedResources} method.
     * </p>
     * 
     * @return A list of tags with their associated resources.
     */
    public final List<TaggedResource> taggedResources() {
        return taggedResources;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaggedResources() ? taggedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        return hasTaggedResources() == other.hasTaggedResources() && Objects.equals(taggedResources(), other.taggedResources())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTagsResponse").add("TaggedResources", hasTaggedResources() ? taggedResources() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaggedResources":
            return Optional.ofNullable(clazz.cast(taggedResources()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsResponse, T> g) {
        return obj -> g.apply((DescribeTagsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * A list of tags with their associated resources.
         * </p>
         * 
         * @param taggedResources
         *        A list of tags with their associated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taggedResources(Collection<TaggedResource> taggedResources);

        /**
         * <p>
         * A list of tags with their associated resources.
         * </p>
         * 
         * @param taggedResources
         *        A list of tags with their associated resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taggedResources(TaggedResource... taggedResources);

        /**
         * <p>
         * A list of tags with their associated resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaggedResource>.Builder} avoiding the need
         * to create one manually via {@link List<TaggedResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaggedResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #taggedResources(List<TaggedResource>)}.
         * 
         * @param taggedResources
         *        a consumer that will call methods on {@link List<TaggedResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taggedResources(List<TaggedResource>)
         */
        Builder taggedResources(Consumer<TaggedResource.Builder>... taggedResources);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<TaggedResource> taggedResources = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            taggedResources(model.taggedResources);
            marker(model.marker);
        }

        public final List<TaggedResource.Builder> getTaggedResources() {
            List<TaggedResource.Builder> result = TaggedResourceListCopier.copyToBuilder(this.taggedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaggedResources(Collection<TaggedResource.BuilderImpl> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copyFromBuilder(taggedResources);
        }

        @Override
        @Transient
        public final Builder taggedResources(Collection<TaggedResource> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copy(taggedResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taggedResources(TaggedResource... taggedResources) {
            taggedResources(Arrays.asList(taggedResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taggedResources(Consumer<TaggedResource.Builder>... taggedResources) {
            taggedResources(Stream.of(taggedResources).map(c -> TaggedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
