/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledActionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeScheduledActionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField
            .<List<ScheduledAction>> builder(MarshallingType.LIST)
            .memberName("ScheduledActions")
            .getter(getter(DescribeScheduledActionsResponse::scheduledActions))
            .setter(setter(Builder::scheduledActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ScheduledAction")
                            .memberFieldInfo(
                                    SdkField.<ScheduledAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ScheduledAction").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            SCHEDULED_ACTIONS_FIELD));

    private final String marker;

    private final List<ScheduledAction> scheduledActions;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.scheduledActions = builder.scheduledActions;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web
     * Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     * request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeScheduledActions</a> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduledActions() {
        return scheduledActions != null && !(scheduledActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of retrieved scheduled actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledActions} method.
     * </p>
     * 
     * @return List of retrieved scheduled actions.
     */
    public final List<ScheduledAction> scheduledActions() {
        return scheduledActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledActions() ? scheduledActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasScheduledActions() == other.hasScheduledActions()
                && Objects.equals(scheduledActions(), other.scheduledActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduledActionsResponse").add("Marker", marker())
                .add("ScheduledActions", hasScheduledActions() ? scheduledActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ScheduledActions":
            return Optional.ofNullable(clazz.cast(scheduledActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, Amazon
         * Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set
         * of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
         * the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeScheduledActions</a> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned marker value in
         *        the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * List of retrieved scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        List of retrieved scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(Collection<ScheduledAction> scheduledActions);

        /**
         * <p>
         * List of retrieved scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        List of retrieved scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(ScheduledAction... scheduledActions);

        /**
         * <p>
         * List of retrieved scheduled actions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledAction>.Builder} avoiding the need
         * to create one manually via {@link List<ScheduledAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduledActions(List<ScheduledAction>)}.
         * 
         * @param scheduledActions
         *        a consumer that will call methods on {@link List<ScheduledAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledActions(List<ScheduledAction>)
         */
        Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            marker(model.marker);
            scheduledActions(model.scheduledActions);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ScheduledAction.Builder> getScheduledActions() {
            List<ScheduledAction.Builder> result = ScheduledActionListCopier.copyToBuilder(this.scheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionListCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        @Transient
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionListCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction... scheduledActions) {
            scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions) {
            scheduledActions(Stream.of(scheduledActions).map(c -> ScheduledAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
