/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePartnersResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribePartnersResponse.Builder, DescribePartnersResponse> {
    private static final SdkField<List<PartnerIntegrationInfo>> PARTNER_INTEGRATION_INFO_LIST_FIELD = SdkField
            .<List<PartnerIntegrationInfo>> builder(MarshallingType.LIST)
            .memberName("PartnerIntegrationInfoList")
            .getter(getter(DescribePartnersResponse::partnerIntegrationInfoList))
            .setter(setter(Builder::partnerIntegrationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerIntegrationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PartnerIntegrationInfo")
                            .memberFieldInfo(
                                    SdkField.<PartnerIntegrationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartnerIntegrationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PartnerIntegrationInfo").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PARTNER_INTEGRATION_INFO_LIST_FIELD));

    private final List<PartnerIntegrationInfo> partnerIntegrationInfoList;

    private DescribePartnersResponse(BuilderImpl builder) {
        super(builder);
        this.partnerIntegrationInfoList = builder.partnerIntegrationInfoList;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartnerIntegrationInfoList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPartnerIntegrationInfoList() {
        return partnerIntegrationInfoList != null && !(partnerIntegrationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of partner integrations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartnerIntegrationInfoList} method.
     * </p>
     * 
     * @return A list of partner integrations.
     */
    public final List<PartnerIntegrationInfo> partnerIntegrationInfoList() {
        return partnerIntegrationInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPartnerIntegrationInfoList() ? partnerIntegrationInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePartnersResponse)) {
            return false;
        }
        DescribePartnersResponse other = (DescribePartnersResponse) obj;
        return hasPartnerIntegrationInfoList() == other.hasPartnerIntegrationInfoList()
                && Objects.equals(partnerIntegrationInfoList(), other.partnerIntegrationInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePartnersResponse")
                .add("PartnerIntegrationInfoList", hasPartnerIntegrationInfoList() ? partnerIntegrationInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartnerIntegrationInfoList":
            return Optional.ofNullable(clazz.cast(partnerIntegrationInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePartnersResponse, T> g) {
        return obj -> g.apply((DescribePartnersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePartnersResponse> {
        /**
         * <p>
         * A list of partner integrations.
         * </p>
         * 
         * @param partnerIntegrationInfoList
         *        A list of partner integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerIntegrationInfoList(Collection<PartnerIntegrationInfo> partnerIntegrationInfoList);

        /**
         * <p>
         * A list of partner integrations.
         * </p>
         * 
         * @param partnerIntegrationInfoList
         *        A list of partner integrations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerIntegrationInfoList(PartnerIntegrationInfo... partnerIntegrationInfoList);

        /**
         * <p>
         * A list of partner integrations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartnerIntegrationInfo>.Builder} avoiding
         * the need to create one manually via {@link List<PartnerIntegrationInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartnerIntegrationInfo>.Builder#build()} is called
         * immediately and its result is passed to {@link #partnerIntegrationInfoList(List<PartnerIntegrationInfo>)}.
         * 
         * @param partnerIntegrationInfoList
         *        a consumer that will call methods on {@link List<PartnerIntegrationInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partnerIntegrationInfoList(List<PartnerIntegrationInfo>)
         */
        Builder partnerIntegrationInfoList(Consumer<PartnerIntegrationInfo.Builder>... partnerIntegrationInfoList);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<PartnerIntegrationInfo> partnerIntegrationInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePartnersResponse model) {
            super(model);
            partnerIntegrationInfoList(model.partnerIntegrationInfoList);
        }

        public final List<PartnerIntegrationInfo.Builder> getPartnerIntegrationInfoList() {
            List<PartnerIntegrationInfo.Builder> result = PartnerIntegrationInfoListCopier
                    .copyToBuilder(this.partnerIntegrationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartnerIntegrationInfoList(Collection<PartnerIntegrationInfo.BuilderImpl> partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList = PartnerIntegrationInfoListCopier.copyFromBuilder(partnerIntegrationInfoList);
        }

        @Override
        @Transient
        public final Builder partnerIntegrationInfoList(Collection<PartnerIntegrationInfo> partnerIntegrationInfoList) {
            this.partnerIntegrationInfoList = PartnerIntegrationInfoListCopier.copy(partnerIntegrationInfoList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partnerIntegrationInfoList(PartnerIntegrationInfo... partnerIntegrationInfoList) {
            partnerIntegrationInfoList(Arrays.asList(partnerIntegrationInfoList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partnerIntegrationInfoList(Consumer<PartnerIntegrationInfo.Builder>... partnerIntegrationInfoList) {
            partnerIntegrationInfoList(Stream.of(partnerIntegrationInfoList)
                    .map(c -> PartnerIntegrationInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePartnersResponse build() {
            return new DescribePartnersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
