/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeConfigurationOptionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeNodeConfigurationOptionsResponse.Builder, DescribeNodeConfigurationOptionsResponse> {
    private static final SdkField<List<NodeConfigurationOption>> NODE_CONFIGURATION_OPTION_LIST_FIELD = SdkField
            .<List<NodeConfigurationOption>> builder(MarshallingType.LIST)
            .memberName("NodeConfigurationOptionList")
            .getter(getter(DescribeNodeConfigurationOptionsResponse::nodeConfigurationOptionList))
            .setter(setter(Builder::nodeConfigurationOptionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOptionList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeConfigurationOption")
                            .memberFieldInfo(
                                    SdkField.<NodeConfigurationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeConfigurationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeConfigurationOption").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeNodeConfigurationOptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NODE_CONFIGURATION_OPTION_LIST_FIELD, MARKER_FIELD));

    private final List<NodeConfigurationOption> nodeConfigurationOptionList;

    private final String marker;

    private DescribeNodeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nodeConfigurationOptionList = builder.nodeConfigurationOptionList;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeConfigurationOptionList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNodeConfigurationOptionList() {
        return nodeConfigurationOptionList != null && !(nodeConfigurationOptionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of valid node configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeConfigurationOptionList} method.
     * </p>
     * 
     * @return A list of valid node configurations.
     */
    public final List<NodeConfigurationOption> nodeConfigurationOptionList() {
        return nodeConfigurationOptionList;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeConfigurationOptionList() ? nodeConfigurationOptionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeNodeConfigurationOptionsResponse other = (DescribeNodeConfigurationOptionsResponse) obj;
        return hasNodeConfigurationOptionList() == other.hasNodeConfigurationOptionList()
                && Objects.equals(nodeConfigurationOptionList(), other.nodeConfigurationOptionList())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNodeConfigurationOptionsResponse")
                .add("NodeConfigurationOptionList", hasNodeConfigurationOptionList() ? nodeConfigurationOptionList() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeConfigurationOptionList":
            return Optional.ofNullable(clazz.cast(nodeConfigurationOptionList()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsResponse, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNodeConfigurationOptionsResponse> {
        /**
         * <p>
         * A list of valid node configurations.
         * </p>
         * 
         * @param nodeConfigurationOptionList
         *        A list of valid node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> nodeConfigurationOptionList);

        /**
         * <p>
         * A list of valid node configurations.
         * </p>
         * 
         * @param nodeConfigurationOptionList
         *        A list of valid node configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeConfigurationOptionList(NodeConfigurationOption... nodeConfigurationOptionList);

        /**
         * <p>
         * A list of valid node configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeConfigurationOption>.Builder} avoiding
         * the need to create one manually via {@link List<NodeConfigurationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeConfigurationOption>.Builder#build()} is called
         * immediately and its result is passed to {@link #nodeConfigurationOptionList(List<NodeConfigurationOption>)}.
         * 
         * @param nodeConfigurationOptionList
         *        a consumer that will call methods on {@link List<NodeConfigurationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeConfigurationOptionList(List<NodeConfigurationOption>)
         */
        Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder>... nodeConfigurationOptionList);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<NodeConfigurationOption> nodeConfigurationOptionList = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsResponse model) {
            super(model);
            nodeConfigurationOptionList(model.nodeConfigurationOptionList);
            marker(model.marker);
        }

        public final List<NodeConfigurationOption.Builder> getNodeConfigurationOptionList() {
            List<NodeConfigurationOption.Builder> result = NodeConfigurationOptionListCopier
                    .copyToBuilder(this.nodeConfigurationOptionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeConfigurationOptionList(
                Collection<NodeConfigurationOption.BuilderImpl> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copyFromBuilder(nodeConfigurationOptionList);
        }

        @Override
        @Transient
        public final Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copy(nodeConfigurationOptionList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(NodeConfigurationOption... nodeConfigurationOptionList) {
            nodeConfigurationOptionList(Arrays.asList(nodeConfigurationOptionList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder>... nodeConfigurationOptionList) {
            nodeConfigurationOptionList(Stream.of(nodeConfigurationOptionList)
                    .map(c -> NodeConfigurationOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeNodeConfigurationOptionsResponse build() {
            return new DescribeNodeConfigurationOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
