/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointAuthorizationRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeEndpointAuthorizationRequest.Builder, DescribeEndpointAuthorizationRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(DescribeEndpointAuthorizationRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Account")
            .getter(getter(DescribeEndpointAuthorizationRequest::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<Boolean> GRANTEE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Grantee").getter(getter(DescribeEndpointAuthorizationRequest::grantee)).setter(setter(Builder::grantee))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeEndpointAuthorizationRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEndpointAuthorizationRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            ACCOUNT_FIELD, GRANTEE_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String clusterIdentifier;

    private final String account;

    private final Boolean grantee;

    private final Integer maxRecords;

    private final String marker;

    private DescribeEndpointAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.account = builder.account;
        this.grantee = builder.grantee;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The cluster identifier of the cluster to access.
     * </p>
     * 
     * @return The cluster identifier of the cluster to access.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code>
     * parameter is true, then the <code>Account</code> value is of the grantor.
     * </p>
     * 
     * @return The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If
     *         <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift
     * returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor
     * point of view.
     * </p>
     * 
     * @return Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon
     *         Redshift returns endpoint authorizations that you've been granted. If false (default), checks
     *         authorization from a grantor point of view.
     */
    public final Boolean grantee() {
        return grantee;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so
     * that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified
     *         <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the
     *         response so that the remaining results can be retrieved.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by the
     * <code>MaxRecords</code> parameter.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request.
     *         If this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by the <code>MaxRecords</code> parameter.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(grantee());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointAuthorizationRequest)) {
            return false;
        }
        DescribeEndpointAuthorizationRequest other = (DescribeEndpointAuthorizationRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(account(), other.account())
                && Objects.equals(grantee(), other.grantee()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointAuthorizationRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("Account", account()).add("Grantee", grantee()).add("MaxRecords", maxRecords()).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "Grantee":
            return Optional.ofNullable(clazz.cast(grantee()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointAuthorizationRequest, T> g) {
        return obj -> g.apply((DescribeEndpointAuthorizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEndpointAuthorizationRequest> {
        /**
         * <p>
         * The cluster identifier of the cluster to access.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier of the cluster to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code>
         * parameter is true, then the <code>Account</code> value is of the grantor.
         * </p>
         * 
         * @param account
         *        The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If
         *        <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift
         * returns endpoint authorizations that you've been granted. If false (default), checks authorization from a
         * grantor point of view.
         * </p>
         * 
         * @param grantee
         *        Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon
         *        Redshift returns endpoint authorizations that you've been granted. If false (default), checks
         *        authorization from a grantor point of view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantee(Boolean grantee);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so
         * that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the
         *        response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by the <code>MaxRecords</code> parameter.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by the <code>MaxRecords</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String account;

        private Boolean grantee;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointAuthorizationRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            account(model.account);
            grantee(model.grantee);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        @Transient
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Boolean getGrantee() {
            return grantee;
        }

        public final void setGrantee(Boolean grantee) {
            this.grantee = grantee;
        }

        @Override
        @Transient
        public final Builder grantee(Boolean grantee) {
            this.grantee = grantee;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        @Transient
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEndpointAuthorizationRequest build() {
            return new DescribeEndpointAuthorizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
