/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeClusterVersions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterVersionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterVersionsResponse.Builder, DescribeClusterVersionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeClusterVersionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterVersion>> CLUSTER_VERSIONS_FIELD = SdkField
            .<List<ClusterVersion>> builder(MarshallingType.LIST)
            .memberName("ClusterVersions")
            .getter(getter(DescribeClusterVersionsResponse::clusterVersions))
            .setter(setter(Builder::clusterVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterVersion")
                            .memberFieldInfo(
                                    SdkField.<ClusterVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterVersion").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CLUSTER_VERSIONS_FIELD));

    private final String marker;

    private final List<ClusterVersion> clusterVersions;

    private DescribeClusterVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterVersions = builder.clusterVersions;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterVersions() {
        return clusterVersions != null && !(clusterVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>Version</code> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterVersions} method.
     * </p>
     * 
     * @return A list of <code>Version</code> elements.
     */
    public final List<ClusterVersion> clusterVersions() {
        return clusterVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterVersions() ? clusterVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsResponse)) {
            return false;
        }
        DescribeClusterVersionsResponse other = (DescribeClusterVersionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasClusterVersions() == other.hasClusterVersions()
                && Objects.equals(clusterVersions(), other.clusterVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterVersionsResponse").add("Marker", marker())
                .add("ClusterVersions", hasClusterVersions() ? clusterVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ClusterVersions":
            return Optional.ofNullable(clazz.cast(clusterVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterVersionsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>Version</code> elements.
         * </p>
         * 
         * @param clusterVersions
         *        A list of <code>Version</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersions(Collection<ClusterVersion> clusterVersions);

        /**
         * <p>
         * A list of <code>Version</code> elements.
         * </p>
         * 
         * @param clusterVersions
         *        A list of <code>Version</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersions(ClusterVersion... clusterVersions);

        /**
         * <p>
         * A list of <code>Version</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterVersion>.Builder} avoiding the need
         * to create one manually via {@link List<ClusterVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterVersion>.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterVersions(List<ClusterVersion>)}.
         * 
         * @param clusterVersions
         *        a consumer that will call methods on {@link List<ClusterVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterVersions(List<ClusterVersion>)
         */
        Builder clusterVersions(Consumer<ClusterVersion.Builder>... clusterVersions);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterVersion> clusterVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsResponse model) {
            super(model);
            marker(model.marker);
            clusterVersions(model.clusterVersions);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterVersion.Builder> getClusterVersions() {
            List<ClusterVersion.Builder> result = ClusterVersionListCopier.copyToBuilder(this.clusterVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterVersions(Collection<ClusterVersion.BuilderImpl> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copyFromBuilder(clusterVersions);
        }

        @Override
        @Transient
        public final Builder clusterVersions(Collection<ClusterVersion> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterVersions(ClusterVersion... clusterVersions) {
            clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterVersions(Consumer<ClusterVersion.Builder>... clusterVersions) {
            clusterVersions(Stream.of(clusterVersions).map(c -> ClusterVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterVersionsResponse build() {
            return new DescribeClusterVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
