/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterSnapshotsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeClusterSnapshotsRequest.Builder, DescribeClusterSnapshotsRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(DescribeClusterSnapshotsRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(DescribeClusterSnapshotsRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(DescribeClusterSnapshotsRequest::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeClusterSnapshotsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeClusterSnapshotsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeClusterSnapshotsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeClusterSnapshotsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(DescribeClusterSnapshotsRequest::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeys")
            .getter(getter(DescribeClusterSnapshotsRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TagKey")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TagKey").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValues")
            .getter(getter(DescribeClusterSnapshotsRequest::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TagValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TagValue").build()).build()).build()).build();

    private static final SdkField<Boolean> CLUSTER_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ClusterExists").getter(getter(DescribeClusterSnapshotsRequest::clusterExists))
            .setter(setter(Builder::clusterExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterExists").build()).build();

    private static final SdkField<List<SnapshotSortingEntity>> SORTING_ENTITIES_FIELD = SdkField
            .<List<SnapshotSortingEntity>> builder(MarshallingType.LIST)
            .memberName("SortingEntities")
            .getter(getter(DescribeClusterSnapshotsRequest::sortingEntities))
            .setter(setter(Builder::sortingEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotSortingEntity")
                            .memberFieldInfo(
                                    SdkField.<SnapshotSortingEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotSortingEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotSortingEntity").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD,
            OWNER_ACCOUNT_FIELD, TAG_KEYS_FIELD, TAG_VALUES_FIELD, CLUSTER_EXISTS_FIELD, SORTING_ENTITIES_FIELD));

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String snapshotType;

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxRecords;

    private final String marker;

    private final String ownerAccount;

    private final List<String> tagKeys;

    private final List<String> tagValues;

    private final Boolean clusterExists;

    private final List<SnapshotSortingEntity> sortingEntities;

    private DescribeClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.ownerAccount = builder.ownerAccount;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
        this.clusterExists = builder.clusterExists;
        this.sortingEntities = builder.sortingEntities;
    }

    /**
     * <p>
     * The identifier of the cluster which generated the requested snapshots.
     * </p>
     * 
     * @return The identifier of the cluster which generated the requested snapshots.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The snapshot identifier of the snapshot about which to return information.
     * </p>
     * 
     * @return The snapshot identifier of the snapshot about which to return information.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.
     * </p>
     * <p>
     * Valid Values: <code>automated</code> | <code>manual</code>
     * </p>
     * 
     * @return The type of snapshots for which you are requesting information. By default, snapshots of all types are
     *         returned.</p>
     *         <p>
     *         Valid Values: <code>automated</code> | <code>manual</code>
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * A value that requests only snapshots created at or after the specified time. The time value is specified in ISO
     * 8601 format. For more information about ISO 8601, go to the <a
     * href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
     * </p>
     * <p>
     * Example: <code>2012-07-16T18:00:00Z</code>
     * </p>
     * 
     * @return A value that requests only snapshots created at or after the specified time. The time value is specified
     *         in ISO 8601 format. For more information about ISO 8601, go to the <a
     *         href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
     *         <p>
     *         Example: <code>2012-07-16T18:00:00Z</code>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * A time value that requests only snapshots created at or before the specified time. The time value is specified in
     * ISO 8601 format. For more information about ISO 8601, go to the <a
     * href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
     * </p>
     * <p>
     * Example: <code>2012-07-16T18:00:00Z</code>
     * </p>
     * 
     * @return A time value that requests only snapshots created at or before the specified time. The time value is
     *         specified in ISO 8601 format. For more information about ISO 8601, go to the <a
     *         href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
     *         <p>
     *         Example: <code>2012-07-16T18:00:00Z</code>
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeClusterSnapshots</a> request exceed the value specified in <code>MaxRecords</code>, Amazon Web
     * Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
     * request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeClusterSnapshots</a> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to
     * snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services
     * account, or do not specify the parameter.
     * </p>
     * 
     * @return The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results
     *         to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web
     *         Services account, or do not specify the parameter.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagKeys() {
        return tagKeys != null && !(tagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A tag key or keys for which you want to return all matching cluster snapshots that are associated with the
     * specified key or keys. For example, suppose that you have snapshots that are tagged with keys called
     * <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon
     * Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeys} method.
     * </p>
     * 
     * @return A tag key or keys for which you want to return all matching cluster snapshots that are associated with
     *         the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called
     *         <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request,
     *         Amazon Redshift returns a response with the snapshots that have either or both of these tag keys
     *         associated with them.
     */
    public final List<String> tagKeys() {
        return tagKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A tag value or values for which you want to return all matching cluster snapshots that are associated with the
     * specified tag value or values. For example, suppose that you have snapshots that are tagged with values called
     * <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
     * returns a response with the snapshots that have either or both of these tag values associated with them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return A tag value or values for which you want to return all matching cluster snapshots that are associated
     *         with the specified tag value or values. For example, suppose that you have snapshots that are tagged with
     *         values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the
     *         request, Amazon Redshift returns a response with the snapshots that have either or both of these tag
     *         values associated with them.
     */
    public final List<String> tagValues() {
        return tagValues;
    }

    /**
     * <p>
     * A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level
     * restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for
     * this parameter work as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't specified,
     * all snapshots associated with deleted clusters (orphaned snapshots) are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a
     * deleted cluster, snapshots associated with that cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an
     * existing cluster, no snapshots are returned.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that indicates whether to return snapshots only for an existing cluster. You can perform
     *         table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been
     *         deleted. Values for this parameter work as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't
     *         specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is
     *         specified for a deleted cluster, snapshots associated with that cluster are returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is
     *         specified for an existing cluster, no snapshots are returned.
     *         </p>
     *         </li>
     */
    public final Boolean clusterExists() {
        return clusterExists;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortingEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortingEntities() {
        return sortingEntities != null && !(sortingEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortingEntities} method.
     * </p>
     * 
     * @return
     */
    public final List<SnapshotSortingEntity> sortingEntities() {
        return sortingEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeys() ? tagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterExists());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortingEntities() ? sortingEntities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSnapshotsRequest)) {
            return false;
        }
        DescribeClusterSnapshotsRequest other = (DescribeClusterSnapshotsRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && hasTagKeys() == other.hasTagKeys() && Objects.equals(tagKeys(), other.tagKeys())
                && hasTagValues() == other.hasTagValues() && Objects.equals(tagValues(), other.tagValues())
                && Objects.equals(clusterExists(), other.clusterExists()) && hasSortingEntities() == other.hasSortingEntities()
                && Objects.equals(sortingEntities(), other.sortingEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterSnapshotsRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("SnapshotIdentifier", snapshotIdentifier()).add("SnapshotType", snapshotType())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("MaxRecords", maxRecords()).add("Marker", marker())
                .add("OwnerAccount", ownerAccount()).add("TagKeys", hasTagKeys() ? tagKeys() : null)
                .add("TagValues", hasTagValues() ? tagValues() : null).add("ClusterExists", clusterExists())
                .add("SortingEntities", hasSortingEntities() ? sortingEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "TagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        case "TagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        case "ClusterExists":
            return Optional.ofNullable(clazz.cast(clusterExists()));
        case "SortingEntities":
            return Optional.ofNullable(clazz.cast(sortingEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeClusterSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterSnapshotsRequest> {
        /**
         * <p>
         * The identifier of the cluster which generated the requested snapshots.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster which generated the requested snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The snapshot identifier of the snapshot about which to return information.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The snapshot identifier of the snapshot about which to return information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The type of snapshots for which you are requesting information. By default, snapshots of all types are
         * returned.
         * </p>
         * <p>
         * Valid Values: <code>automated</code> | <code>manual</code>
         * </p>
         * 
         * @param snapshotType
         *        The type of snapshots for which you are requesting information. By default, snapshots of all types are
         *        returned.</p>
         *        <p>
         *        Valid Values: <code>automated</code> | <code>manual</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * A value that requests only snapshots created at or after the specified time. The time value is specified in
         * ISO 8601 format. For more information about ISO 8601, go to the <a
         * href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
         * </p>
         * <p>
         * Example: <code>2012-07-16T18:00:00Z</code>
         * </p>
         * 
         * @param startTime
         *        A value that requests only snapshots created at or after the specified time. The time value is
         *        specified in ISO 8601 format. For more information about ISO 8601, go to the <a
         *        href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
         *        <p>
         *        Example: <code>2012-07-16T18:00:00Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * A time value that requests only snapshots created at or before the specified time. The time value is
         * specified in ISO 8601 format. For more information about ISO 8601, go to the <a
         * href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
         * </p>
         * <p>
         * Example: <code>2012-07-16T18:00:00Z</code>
         * </p>
         * 
         * @param endTime
         *        A time value that requests only snapshots created at or before the specified time. The time value is
         *        specified in ISO 8601 format. For more information about ISO 8601, go to the <a
         *        href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
         *        <p>
         *        Example: <code>2012-07-16T18:00:00Z</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeClusterSnapshots</a> request exceed the value specified in <code>MaxRecords</code>, Amazon
         * Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set
         * of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
         * the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeClusterSnapshots</a> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned marker value in
         *        the <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to
         * snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web
         * Services account, or do not specify the parameter.
         * </p>
         * 
         * @param ownerAccount
         *        The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the
         *        results to snapshots owned by a particular account. To describe snapshots you own, either specify your
         *        Amazon Web Services account, or do not specify the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * A tag key or keys for which you want to return all matching cluster snapshots that are associated with the
         * specified key or keys. For example, suppose that you have snapshots that are tagged with keys called
         * <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon
         * Redshift returns a response with the snapshots that have either or both of these tag keys associated with
         * them.
         * </p>
         * 
         * @param tagKeys
         *        A tag key or keys for which you want to return all matching cluster snapshots that are associated with
         *        the specified key or keys. For example, suppose that you have snapshots that are tagged with keys
         *        called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the
         *        request, Amazon Redshift returns a response with the snapshots that have either or both of these tag
         *        keys associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * A tag key or keys for which you want to return all matching cluster snapshots that are associated with the
         * specified key or keys. For example, suppose that you have snapshots that are tagged with keys called
         * <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon
         * Redshift returns a response with the snapshots that have either or both of these tag keys associated with
         * them.
         * </p>
         * 
         * @param tagKeys
         *        A tag key or keys for which you want to return all matching cluster snapshots that are associated with
         *        the specified key or keys. For example, suppose that you have snapshots that are tagged with keys
         *        called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the
         *        request, Amazon Redshift returns a response with the snapshots that have either or both of these tag
         *        keys associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        /**
         * <p>
         * A tag value or values for which you want to return all matching cluster snapshots that are associated with
         * the specified tag value or values. For example, suppose that you have snapshots that are tagged with values
         * called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request,
         * Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated
         * with them.
         * </p>
         * 
         * @param tagValues
         *        A tag value or values for which you want to return all matching cluster snapshots that are associated
         *        with the specified tag value or values. For example, suppose that you have snapshots that are tagged
         *        with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values
         *        in the request, Amazon Redshift returns a response with the snapshots that have either or both of
         *        these tag values associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<String> tagValues);

        /**
         * <p>
         * A tag value or values for which you want to return all matching cluster snapshots that are associated with
         * the specified tag value or values. For example, suppose that you have snapshots that are tagged with values
         * called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request,
         * Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated
         * with them.
         * </p>
         * 
         * @param tagValues
         *        A tag value or values for which you want to return all matching cluster snapshots that are associated
         *        with the specified tag value or values. For example, suppose that you have snapshots that are tagged
         *        with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values
         *        in the request, Amazon Redshift returns a response with the snapshots that have either or both of
         *        these tag values associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(String... tagValues);

        /**
         * <p>
         * A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level
         * restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values
         * for this parameter work as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't
         * specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified
         * for a deleted cluster, snapshots associated with that cluster are returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified
         * for an existing cluster, no snapshots are returned.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterExists
         *        A value that indicates whether to return snapshots only for an existing cluster. You can perform
         *        table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not
         *        been deleted. Values for this parameter work as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't
         *        specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is
         *        specified for a deleted cluster, snapshots associated with that cluster are returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is
         *        specified for an existing cluster, no snapshots are returned.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterExists(Boolean clusterExists);

        /**
         * <p/>
         * 
         * @param sortingEntities
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingEntities(Collection<SnapshotSortingEntity> sortingEntities);

        /**
         * <p/>
         * 
         * @param sortingEntities
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortingEntities(SnapshotSortingEntity... sortingEntities);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<SnapshotSortingEntity>.Builder} avoiding
         * the need to create one manually via {@link List<SnapshotSortingEntity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SnapshotSortingEntity>.Builder#build()} is called
         * immediately and its result is passed to {@link #sortingEntities(List<SnapshotSortingEntity>)}.
         * 
         * @param sortingEntities
         *        a consumer that will call methods on {@link List<SnapshotSortingEntity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortingEntities(List<SnapshotSortingEntity>)
         */
        Builder sortingEntities(Consumer<SnapshotSortingEntity.Builder>... sortingEntities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String snapshotType;

        private Instant startTime;

        private Instant endTime;

        private Integer maxRecords;

        private String marker;

        private String ownerAccount;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private Boolean clusterExists;

        private List<SnapshotSortingEntity> sortingEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSnapshotsRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotType(model.snapshotType);
            startTime(model.startTime);
            endTime(model.endTime);
            maxRecords(model.maxRecords);
            marker(model.marker);
            ownerAccount(model.ownerAccount);
            tagKeys(model.tagKeys);
            tagValues(model.tagValues);
            clusterExists(model.clusterExists);
            sortingEntities(model.sortingEntities);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        @Transient
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        @Transient
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        @Transient
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Collection<String> getTagKeys() {
            if (tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeys;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @Override
        @Transient
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final Collection<String> getTagValues() {
            if (tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        @Transient
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagValues(String... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        public final Boolean getClusterExists() {
            return clusterExists;
        }

        public final void setClusterExists(Boolean clusterExists) {
            this.clusterExists = clusterExists;
        }

        @Override
        @Transient
        public final Builder clusterExists(Boolean clusterExists) {
            this.clusterExists = clusterExists;
            return this;
        }

        public final List<SnapshotSortingEntity.Builder> getSortingEntities() {
            List<SnapshotSortingEntity.Builder> result = SnapshotSortingEntityListCopier.copyToBuilder(this.sortingEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingEntities(Collection<SnapshotSortingEntity.BuilderImpl> sortingEntities) {
            this.sortingEntities = SnapshotSortingEntityListCopier.copyFromBuilder(sortingEntities);
        }

        @Override
        @Transient
        public final Builder sortingEntities(Collection<SnapshotSortingEntity> sortingEntities) {
            this.sortingEntities = SnapshotSortingEntityListCopier.copy(sortingEntities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sortingEntities(SnapshotSortingEntity... sortingEntities) {
            sortingEntities(Arrays.asList(sortingEntities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sortingEntities(Consumer<SnapshotSortingEntity.Builder>... sortingEntities) {
            sortingEntities(Stream.of(sortingEntities).map(c -> SnapshotSortingEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterSnapshotsRequest build() {
            return new DescribeClusterSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
