/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClusterSnapshotMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteClusterSnapshotMessage.Builder, DeleteClusterSnapshotMessage> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(DeleteClusterSnapshotMessage::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotClusterIdentifier").getter(getter(DeleteClusterSnapshotMessage::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            SNAPSHOT_CLUSTER_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotIdentifier;

    private final String snapshotClusterIdentifier;

    private DeleteClusterSnapshotMessage(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the manual snapshot to be deleted.
     * </p>
     * <p>
     * Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>,
     * or <code>cancelled</code> state.
     * </p>
     * 
     * @return The unique identifier of the manual snapshot to be deleted.</p>
     *         <p>
     *         Constraints: Must be the name of an existing snapshot that is in the <code>available</code>,
     *         <code>failed</code>, or <code>cancelled</code> state.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user
     * has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     * </p>
     * <p>
     * Constraints: Must be the name of valid cluster.
     * </p>
     * 
     * @return The unique identifier of the cluster the snapshot was created from. This parameter is required if your
     *         IAM user has a policy containing a snapshot resource element that specifies anything other than * for the
     *         cluster name.</p>
     *         <p>
     *         Constraints: Must be the name of valid cluster.
     */
    public final String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterSnapshotMessage)) {
            return false;
        }
        DeleteClusterSnapshotMessage other = (DeleteClusterSnapshotMessage) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteClusterSnapshotMessage").add("SnapshotIdentifier", snapshotIdentifier())
                .add("SnapshotClusterIdentifier", snapshotClusterIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterSnapshotMessage, T> g) {
        return obj -> g.apply((DeleteClusterSnapshotMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteClusterSnapshotMessage> {
        /**
         * <p>
         * The unique identifier of the manual snapshot to be deleted.
         * </p>
         * <p>
         * Constraints: Must be the name of an existing snapshot that is in the <code>available</code>,
         * <code>failed</code>, or <code>cancelled</code> state.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The unique identifier of the manual snapshot to be deleted.</p>
         *        <p>
         *        Constraints: Must be the name of an existing snapshot that is in the <code>available</code>,
         *        <code>failed</code>, or <code>cancelled</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM
         * user has a policy containing a snapshot resource element that specifies anything other than * for the cluster
         * name.
         * </p>
         * <p>
         * Constraints: Must be the name of valid cluster.
         * </p>
         * 
         * @param snapshotClusterIdentifier
         *        The unique identifier of the cluster the snapshot was created from. This parameter is required if your
         *        IAM user has a policy containing a snapshot resource element that specifies anything other than * for
         *        the cluster name.</p>
         *        <p>
         *        Constraints: Must be the name of valid cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String snapshotClusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterSnapshotMessage model) {
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        @Transient
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        @Override
        public DeleteClusterSnapshotMessage build() {
            return new DeleteClusterSnapshotMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
