/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a cluster while it is in the process of resizing with an incremental resize.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTransferProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTransferProgress.Builder, DataTransferProgress> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataTransferProgress::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Double> CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("CurrentRateInMegaBytesPerSecond")
            .getter(getter(DataTransferProgress::currentRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRateInMegaBytesPerSecond")
                    .build()).build();

    private static final SdkField<Long> TOTAL_DATA_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalDataInMegaBytes").getter(getter(DataTransferProgress::totalDataInMegaBytes))
            .setter(setter(Builder::totalDataInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalDataInMegaBytes").build())
            .build();

    private static final SdkField<Long> DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("DataTransferredInMegaBytes")
            .getter(getter(DataTransferProgress::dataTransferredInMegaBytes))
            .setter(setter(Builder::dataTransferredInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferredInMegaBytes").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeToCompletionInSeconds")
            .getter(getter(DataTransferProgress::estimatedTimeToCompletionInSeconds))
            .setter(setter(Builder::estimatedTimeToCompletionInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds")
                    .build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeInSeconds").getter(getter(DataTransferProgress::elapsedTimeInSeconds))
            .setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CURRENT_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, TOTAL_DATA_IN_MEGA_BYTES_FIELD, DATA_TRANSFERRED_IN_MEGA_BYTES_FIELD,
            ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Double currentRateInMegaBytesPerSecond;

    private final Long totalDataInMegaBytes;

    private final Long dataTransferredInMegaBytes;

    private final Long estimatedTimeToCompletionInSeconds;

    private final Long elapsedTimeInSeconds;

    private DataTransferProgress(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRateInMegaBytesPerSecond = builder.currentRateInMegaBytesPerSecond;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.dataTransferredInMegaBytes = builder.dataTransferredInMegaBytes;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
    }

    /**
     * <p>
     * Describes the status of the cluster. While the transfer is in progress the status is
     * <code>transferringdata</code>.
     * </p>
     * 
     * @return Describes the status of the cluster. While the transfer is in progress the status is
     *         <code>transferringdata</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Describes the data transfer rate in MB's per second.
     * </p>
     * 
     * @return Describes the data transfer rate in MB's per second.
     */
    public final Double currentRateInMegaBytesPerSecond() {
        return currentRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * Describes the total amount of data to be transfered in megabytes.
     * </p>
     * 
     * @return Describes the total amount of data to be transfered in megabytes.
     */
    public final Long totalDataInMegaBytes() {
        return totalDataInMegaBytes;
    }

    /**
     * <p>
     * Describes the total amount of data that has been transfered in MB's.
     * </p>
     * 
     * @return Describes the total amount of data that has been transfered in MB's.
     */
    public final Long dataTransferredInMegaBytes() {
        return dataTransferredInMegaBytes;
    }

    /**
     * <p>
     * Describes the estimated number of seconds remaining to complete the transfer.
     * </p>
     * 
     * @return Describes the estimated number of seconds remaining to complete the transfer.
     */
    public final Long estimatedTimeToCompletionInSeconds() {
        return estimatedTimeToCompletionInSeconds;
    }

    /**
     * <p>
     * Describes the number of seconds that have elapsed during the data transfer.
     * </p>
     * 
     * @return Describes the number of seconds that have elapsed during the data transfer.
     */
    public final Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(currentRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferredInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTransferProgress)) {
            return false;
        }
        DataTransferProgress other = (DataTransferProgress) obj;
        return Objects.equals(status(), other.status())
                && Objects.equals(currentRateInMegaBytesPerSecond(), other.currentRateInMegaBytesPerSecond())
                && Objects.equals(totalDataInMegaBytes(), other.totalDataInMegaBytes())
                && Objects.equals(dataTransferredInMegaBytes(), other.dataTransferredInMegaBytes())
                && Objects.equals(estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTransferProgress").add("Status", status())
                .add("CurrentRateInMegaBytesPerSecond", currentRateInMegaBytesPerSecond())
                .add("TotalDataInMegaBytes", totalDataInMegaBytes())
                .add("DataTransferredInMegaBytes", dataTransferredInMegaBytes())
                .add("EstimatedTimeToCompletionInSeconds", estimatedTimeToCompletionInSeconds())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CurrentRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentRateInMegaBytesPerSecond()));
        case "TotalDataInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalDataInMegaBytes()));
        case "DataTransferredInMegaBytes":
            return Optional.ofNullable(clazz.cast(dataTransferredInMegaBytes()));
        case "EstimatedTimeToCompletionInSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompletionInSeconds()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataTransferProgress, T> g) {
        return obj -> g.apply((DataTransferProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTransferProgress> {
        /**
         * <p>
         * Describes the status of the cluster. While the transfer is in progress the status is
         * <code>transferringdata</code>.
         * </p>
         * 
         * @param status
         *        Describes the status of the cluster. While the transfer is in progress the status is
         *        <code>transferringdata</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Describes the data transfer rate in MB's per second.
         * </p>
         * 
         * @param currentRateInMegaBytesPerSecond
         *        Describes the data transfer rate in MB's per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond);

        /**
         * <p>
         * Describes the total amount of data to be transfered in megabytes.
         * </p>
         * 
         * @param totalDataInMegaBytes
         *        Describes the total amount of data to be transfered in megabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDataInMegaBytes(Long totalDataInMegaBytes);

        /**
         * <p>
         * Describes the total amount of data that has been transfered in MB's.
         * </p>
         * 
         * @param dataTransferredInMegaBytes
         *        Describes the total amount of data that has been transfered in MB's.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferredInMegaBytes(Long dataTransferredInMegaBytes);

        /**
         * <p>
         * Describes the estimated number of seconds remaining to complete the transfer.
         * </p>
         * 
         * @param estimatedTimeToCompletionInSeconds
         *        Describes the estimated number of seconds remaining to complete the transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds);

        /**
         * <p>
         * Describes the number of seconds that have elapsed during the data transfer.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        Describes the number of seconds that have elapsed during the data transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Double currentRateInMegaBytesPerSecond;

        private Long totalDataInMegaBytes;

        private Long dataTransferredInMegaBytes;

        private Long estimatedTimeToCompletionInSeconds;

        private Long elapsedTimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTransferProgress model) {
            status(model.status);
            currentRateInMegaBytesPerSecond(model.currentRateInMegaBytesPerSecond);
            totalDataInMegaBytes(model.totalDataInMegaBytes);
            dataTransferredInMegaBytes(model.dataTransferredInMegaBytes);
            estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Double getCurrentRateInMegaBytesPerSecond() {
            return currentRateInMegaBytesPerSecond;
        }

        public final void setCurrentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder currentRateInMegaBytesPerSecond(Double currentRateInMegaBytesPerSecond) {
            this.currentRateInMegaBytesPerSecond = currentRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getTotalDataInMegaBytes() {
            return totalDataInMegaBytes;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        @Override
        @Transient
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final Long getDataTransferredInMegaBytes() {
            return dataTransferredInMegaBytes;
        }

        public final void setDataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
        }

        @Override
        @Transient
        public final Builder dataTransferredInMegaBytes(Long dataTransferredInMegaBytes) {
            this.dataTransferredInMegaBytes = dataTransferredInMegaBytes;
            return this;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return estimatedTimeToCompletionInSeconds;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        @Transient
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        @Transient
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        @Override
        public DataTransferProgress build() {
            return new DataTransferProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
