/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventSubscriptionRequest extends RedshiftRequest implements
        ToCopyableBuilder<CreateEventSubscriptionRequest.Builder, CreateEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(CreateEventSubscriptionRequest::subscriptionName))
            .setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(CreateEventSubscriptionRequest::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CreateEventSubscriptionRequest::sourceType))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<List<String>> SOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceIds")
            .getter(getter(CreateEventSubscriptionRequest::sourceIds))
            .setter(setter(Builder::sourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SourceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SourceId").build()).build()).build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategories")
            .getter(getter(CreateEventSubscriptionRequest::eventCategories))
            .setter(setter(Builder::eventCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategory")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategory").build()).build()).build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(CreateEventSubscriptionRequest::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CreateEventSubscriptionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEventSubscriptionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, SOURCE_IDS_FIELD, EVENT_CATEGORIES_FIELD, SEVERITY_FIELD, ENABLED_FIELD,
            TAGS_FIELD));

    private final String subscriptionName;

    private final String snsTopicArn;

    private final String sourceType;

    private final List<String> sourceIds;

    private final List<String> eventCategories;

    private final String severity;

    private final Boolean enabled;

    private final List<Tag> tags;

    private CreateEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.sourceIds = builder.sourceIds;
        this.eventCategories = builder.eventCategories;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the event subscription to be created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cannot be null, empty, or blank.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 255 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the event subscription to be created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot be null, empty, or blank.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is
     * created by Amazon SNS when you create a topic and subscribe to it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN
     *         is created by Amazon SNS when you create a topic and subscribe to it.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The type of source that will be generating the events. For example, if you want to be notified of events
     * generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are
     * returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in
     * order to specify source IDs.
     * </p>
     * <p>
     * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.
     * </p>
     * 
     * @return The type of source that will be generating the events. For example, if you want to be notified of events
     *         generated by a cluster, you would set this parameter to cluster. If this value is not specified, events
     *         are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a
     *         source type in order to specify source IDs.</p>
     *         <p>
     *         Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and
     *         scheduled-action.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceIds() {
        return sourceIds != null && !(sourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type
     * as was specified in the source type parameter. The event subscription will return only events generated by the
     * specified objects. If not specified, then events are returned for all objects within the source type specified.
     * </p>
     * <p>
     * Example: my-cluster-1, my-cluster-2
     * </p>
     * <p>
     * Example: my-snapshot-20131010
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceIds} method.
     * </p>
     * 
     * @return A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the
     *         same type as was specified in the source type parameter. The event subscription will return only events
     *         generated by the specified objects. If not specified, then events are returned for all objects within the
     *         source type specified.</p>
     *         <p>
     *         Example: my-cluster-1, my-cluster-2
     *         </p>
     *         <p>
     *         Example: my-snapshot-20131010
     */
    public final List<String> sourceIds() {
        return sourceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventCategories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventCategories() {
        return eventCategories != null && !(eventCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
     * </p>
     * <p>
     * Values: configuration, management, monitoring, security, pending
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventCategories} method.
     * </p>
     * 
     * @return Specifies the Amazon Redshift event categories to be published by the event notification
     *         subscription.</p>
     *         <p>
     *         Values: configuration, management, monitoring, security, pending
     */
    public final List<String> eventCategories() {
        return eventCategories;
    }

    /**
     * <p>
     * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
     * </p>
     * <p>
     * Values: ERROR, INFO
     * </p>
     * 
     * @return Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>
     *         <p>
     *         Values: ERROR, INFO
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create
     * the subscription but not activate it.
     * </p>
     * 
     * @return A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to
     *         create the subscription but not activate it.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tag instances.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceIds() ? sourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategories() ? eventCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSubscriptionRequest)) {
            return false;
        }
        CreateEventSubscriptionRequest other = (CreateEventSubscriptionRequest) obj;
        return Objects.equals(subscriptionName(), other.subscriptionName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(sourceType(), other.sourceType()) && hasSourceIds() == other.hasSourceIds()
                && Objects.equals(sourceIds(), other.sourceIds()) && hasEventCategories() == other.hasEventCategories()
                && Objects.equals(eventCategories(), other.eventCategories()) && Objects.equals(severity(), other.severity())
                && Objects.equals(enabled(), other.enabled()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventSubscriptionRequest").add("SubscriptionName", subscriptionName())
                .add("SnsTopicArn", snsTopicArn()).add("SourceType", sourceType())
                .add("SourceIds", hasSourceIds() ? sourceIds() : null)
                .add("EventCategories", hasEventCategories() ? eventCategories() : null).add("Severity", severity())
                .add("Enabled", enabled()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "SourceIds":
            return Optional.ofNullable(clazz.cast(sourceIds()));
        case "EventCategories":
            return Optional.ofNullable(clazz.cast(eventCategories()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateEventSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventSubscriptionRequest> {
        /**
         * <p>
         * The name of the event subscription to be created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cannot be null, empty, or blank.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 255 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param subscriptionName
         *        The name of the event subscription to be created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cannot be null, empty, or blank.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is
         * created by Amazon SNS when you create a topic and subscribe to it.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The
         *        ARN is created by Amazon SNS when you create a topic and subscribe to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The type of source that will be generating the events. For example, if you want to be notified of events
         * generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are
         * returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type
         * in order to specify source IDs.
         * </p>
         * <p>
         * Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and
         * scheduled-action.
         * </p>
         * 
         * @param sourceType
         *        The type of source that will be generating the events. For example, if you want to be notified of
         *        events generated by a cluster, you would set this parameter to cluster. If this value is not
         *        specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account.
         *        You must specify a source type in order to specify source IDs.</p>
         *        <p>
         *        Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and
         *        scheduled-action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same
         * type as was specified in the source type parameter. The event subscription will return only events generated
         * by the specified objects. If not specified, then events are returned for all objects within the source type
         * specified.
         * </p>
         * <p>
         * Example: my-cluster-1, my-cluster-2
         * </p>
         * <p>
         * Example: my-snapshot-20131010
         * </p>
         * 
         * @param sourceIds
         *        A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the
         *        same type as was specified in the source type parameter. The event subscription will return only
         *        events generated by the specified objects. If not specified, then events are returned for all objects
         *        within the source type specified.</p>
         *        <p>
         *        Example: my-cluster-1, my-cluster-2
         *        </p>
         *        <p>
         *        Example: my-snapshot-20131010
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIds(Collection<String> sourceIds);

        /**
         * <p>
         * A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same
         * type as was specified in the source type parameter. The event subscription will return only events generated
         * by the specified objects. If not specified, then events are returned for all objects within the source type
         * specified.
         * </p>
         * <p>
         * Example: my-cluster-1, my-cluster-2
         * </p>
         * <p>
         * Example: my-snapshot-20131010
         * </p>
         * 
         * @param sourceIds
         *        A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the
         *        same type as was specified in the source type parameter. The event subscription will return only
         *        events generated by the specified objects. If not specified, then events are returned for all objects
         *        within the source type specified.</p>
         *        <p>
         *        Example: my-cluster-1, my-cluster-2
         *        </p>
         *        <p>
         *        Example: my-snapshot-20131010
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIds(String... sourceIds);

        /**
         * <p>
         * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
         * </p>
         * <p>
         * Values: configuration, management, monitoring, security, pending
         * </p>
         * 
         * @param eventCategories
         *        Specifies the Amazon Redshift event categories to be published by the event notification
         *        subscription.</p>
         *        <p>
         *        Values: configuration, management, monitoring, security, pending
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(Collection<String> eventCategories);

        /**
         * <p>
         * Specifies the Amazon Redshift event categories to be published by the event notification subscription.
         * </p>
         * <p>
         * Values: configuration, management, monitoring, security, pending
         * </p>
         * 
         * @param eventCategories
         *        Specifies the Amazon Redshift event categories to be published by the event notification
         *        subscription.</p>
         *        <p>
         *        Values: configuration, management, monitoring, security, pending
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategories(String... eventCategories);

        /**
         * <p>
         * Specifies the Amazon Redshift event severity to be published by the event notification subscription.
         * </p>
         * <p>
         * Values: ERROR, INFO
         * </p>
         * 
         * @param severity
         *        Specifies the Amazon Redshift event severity to be published by the event notification
         *        subscription.</p>
         *        <p>
         *        Values: ERROR, INFO
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to
         * create the subscription but not activate it.
         * </p>
         * 
         * @param enabled
         *        A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code>
         *        to create the subscription but not activate it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String subscriptionName;

        private String snsTopicArn;

        private String sourceType;

        private List<String> sourceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private String severity;

        private Boolean enabled;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSubscriptionRequest model) {
            super(model);
            subscriptionName(model.subscriptionName);
            snsTopicArn(model.snsTopicArn);
            sourceType(model.sourceType);
            sourceIds(model.sourceIds);
            eventCategories(model.eventCategories);
            severity(model.severity);
            enabled(model.enabled);
            tags(model.tags);
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        @Transient
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Collection<String> getSourceIds() {
            if (sourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceIds;
        }

        public final void setSourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
        }

        @Override
        @Transient
        public final Builder sourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceIds(String... sourceIds) {
            sourceIds(Arrays.asList(sourceIds));
            return this;
        }

        public final Collection<String> getEventCategories() {
            if (eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategories;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @Override
        @Transient
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventCategories(String... eventCategories) {
            eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSubscriptionRequest build() {
            return new CreateEventSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
