/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterParameterGroupResponse extends RedshiftResponse implements
        ToCopyableBuilder<CreateClusterParameterGroupResponse.Builder, CreateClusterParameterGroupResponse> {
    private static final SdkField<ClusterParameterGroup> CLUSTER_PARAMETER_GROUP_FIELD = SdkField
            .<ClusterParameterGroup> builder(MarshallingType.SDK_POJO).memberName("ClusterParameterGroup")
            .getter(getter(CreateClusterParameterGroupResponse::clusterParameterGroup))
            .setter(setter(Builder::clusterParameterGroup)).constructor(ClusterParameterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTER_PARAMETER_GROUP_FIELD));

    private final ClusterParameterGroup clusterParameterGroup;

    private CreateClusterParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.clusterParameterGroup = builder.clusterParameterGroup;
    }

    /**
     * Returns the value of the ClusterParameterGroup property for this object.
     * 
     * @return The value of the ClusterParameterGroup property for this object.
     */
    public final ClusterParameterGroup clusterParameterGroup() {
        return clusterParameterGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterParameterGroupResponse)) {
            return false;
        }
        CreateClusterParameterGroupResponse other = (CreateClusterParameterGroupResponse) obj;
        return Objects.equals(clusterParameterGroup(), other.clusterParameterGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterParameterGroupResponse").add("ClusterParameterGroup", clusterParameterGroup())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterParameterGroup":
            return Optional.ofNullable(clazz.cast(clusterParameterGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterParameterGroupResponse, T> g) {
        return obj -> g.apply((CreateClusterParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateClusterParameterGroupResponse> {
        /**
         * Sets the value of the ClusterParameterGroup property for this object.
         *
         * @param clusterParameterGroup
         *        The new value for the ClusterParameterGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroup(ClusterParameterGroup clusterParameterGroup);

        /**
         * Sets the value of the ClusterParameterGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link ClusterParameterGroup.Builder} avoiding the need
         * to create one manually via {@link ClusterParameterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterParameterGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterParameterGroup(ClusterParameterGroup)}.
         * 
         * @param clusterParameterGroup
         *        a consumer that will call methods on {@link ClusterParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterParameterGroup(ClusterParameterGroup)
         */
        default Builder clusterParameterGroup(Consumer<ClusterParameterGroup.Builder> clusterParameterGroup) {
            return clusterParameterGroup(ClusterParameterGroup.builder().applyMutation(clusterParameterGroup).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private ClusterParameterGroup clusterParameterGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterParameterGroupResponse model) {
            super(model);
            clusterParameterGroup(model.clusterParameterGroup);
        }

        public final ClusterParameterGroup.Builder getClusterParameterGroup() {
            return clusterParameterGroup != null ? clusterParameterGroup.toBuilder() : null;
        }

        public final void setClusterParameterGroup(ClusterParameterGroup.BuilderImpl clusterParameterGroup) {
            this.clusterParameterGroup = clusterParameterGroup != null ? clusterParameterGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder clusterParameterGroup(ClusterParameterGroup clusterParameterGroup) {
            this.clusterParameterGroup = clusterParameterGroup;
            return this;
        }

        @Override
        public CreateClusterParameterGroupResponse build() {
            return new CreateClusterParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
