/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeDataShareRequest extends RedshiftRequest implements
        ToCopyableBuilder<AuthorizeDataShareRequest.Builder, AuthorizeDataShareRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataShareArn").getter(getter(AuthorizeDataShareRequest::dataShareArn))
            .setter(setter(Builder::dataShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()).build();

    private static final SdkField<String> CONSUMER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerIdentifier").getter(getter(AuthorizeDataShareRequest::consumerIdentifier))
            .setter(setter(Builder::consumerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD,
            CONSUMER_IDENTIFIER_FIELD));

    private final String dataShareArn;

    private final String consumerIdentifier;

    private AuthorizeDataShareRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.consumerIdentifier = builder.consumerIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
     */
    public final String dataShareArn() {
        return dataShareArn;
    }

    /**
     * <p>
     * The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account
     * ID.
     * </p>
     * 
     * @return The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS
     *         account ID.
     */
    public final String consumerIdentifier() {
        return consumerIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(consumerIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeDataShareRequest)) {
            return false;
        }
        AuthorizeDataShareRequest other = (AuthorizeDataShareRequest) obj;
        return Objects.equals(dataShareArn(), other.dataShareArn())
                && Objects.equals(consumerIdentifier(), other.consumerIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeDataShareRequest").add("DataShareArn", dataShareArn())
                .add("ConsumerIdentifier", consumerIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataShareArn":
            return Optional.ofNullable(clazz.cast(dataShareArn()));
        case "ConsumerIdentifier":
            return Optional.ofNullable(clazz.cast(consumerIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeDataShareRequest, T> g) {
        return obj -> g.apply((AuthorizeDataShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, AuthorizeDataShareRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
         * </p>
         * 
         * @param dataShareArn
         *        The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataShareArn(String dataShareArn);

        /**
         * <p>
         * The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS
         * account ID.
         * </p>
         * 
         * @param consumerIdentifier
         *        The identifier of the data consumer that is authorized to access the datashare. This identifier is an
         *        AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerIdentifier(String consumerIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String dataShareArn;

        private String consumerIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeDataShareRequest model) {
            super(model);
            dataShareArn(model.dataShareArn);
            consumerIdentifier(model.consumerIdentifier);
        }

        public final String getDataShareArn() {
            return dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        @Transient
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final String getConsumerIdentifier() {
            return consumerIdentifier;
        }

        public final void setConsumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
        }

        @Override
        @Transient
        public final Builder consumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeDataShareRequest build() {
            return new AuthorizeDataShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
