/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterSnapshotScheduleRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyClusterSnapshotScheduleRequest.Builder, ModifyClusterSnapshotScheduleRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ModifyClusterSnapshotScheduleRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleIdentifier").getter(getter(ModifyClusterSnapshotScheduleRequest::scheduleIdentifier))
            .setter(setter(Builder::scheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build())
            .build();

    private static final SdkField<Boolean> DISASSOCIATE_SCHEDULE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisassociateSchedule").getter(getter(ModifyClusterSnapshotScheduleRequest::disassociateSchedule))
            .setter(setter(Builder::disassociateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateSchedule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SCHEDULE_IDENTIFIER_FIELD, DISASSOCIATE_SCHEDULE_FIELD));

    private final String clusterIdentifier;

    private final String scheduleIdentifier;

    private final Boolean disassociateSchedule;

    private ModifyClusterSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.disassociateSchedule = builder.disassociateSchedule;
    }

    /**
     * <p>
     * A unique identifier for the cluster whose snapshot schedule you want to modify.
     * </p>
     * 
     * @return A unique identifier for the cluster whose snapshot schedule you want to modify.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * A unique alphanumeric identifier for the schedule that you want to associate with the cluster.
     * </p>
     * 
     * @return A unique alphanumeric identifier for the schedule that you want to associate with the cluster.
     */
    public final String scheduleIdentifier() {
        return scheduleIdentifier;
    }

    /**
     * <p>
     * A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.
     * </p>
     * 
     * @return A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.
     */
    public final Boolean disassociateSchedule() {
        return disassociateSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateSchedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterSnapshotScheduleRequest)) {
            return false;
        }
        ModifyClusterSnapshotScheduleRequest other = (ModifyClusterSnapshotScheduleRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(scheduleIdentifier(), other.scheduleIdentifier())
                && Objects.equals(disassociateSchedule(), other.disassociateSchedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterSnapshotScheduleRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("ScheduleIdentifier", scheduleIdentifier()).add("DisassociateSchedule", disassociateSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "ScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(scheduleIdentifier()));
        case "DisassociateSchedule":
            return Optional.ofNullable(clazz.cast(disassociateSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((ModifyClusterSnapshotScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyClusterSnapshotScheduleRequest> {
        /**
         * <p>
         * A unique identifier for the cluster whose snapshot schedule you want to modify.
         * </p>
         * 
         * @param clusterIdentifier
         *        A unique identifier for the cluster whose snapshot schedule you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * A unique alphanumeric identifier for the schedule that you want to associate with the cluster.
         * </p>
         * 
         * @param scheduleIdentifier
         *        A unique alphanumeric identifier for the schedule that you want to associate with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleIdentifier(String scheduleIdentifier);

        /**
         * <p>
         * A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.
         * </p>
         * 
         * @param disassociateSchedule
         *        A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateSchedule(Boolean disassociateSchedule);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String scheduleIdentifier;

        private Boolean disassociateSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterSnapshotScheduleRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            scheduleIdentifier(model.scheduleIdentifier);
            disassociateSchedule(model.disassociateSchedule);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getScheduleIdentifier() {
            return scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final Boolean getDisassociateSchedule() {
            return disassociateSchedule;
        }

        @Override
        public final Builder disassociateSchedule(Boolean disassociateSchedule) {
            this.disassociateSchedule = disassociateSchedule;
            return this;
        }

        public final void setDisassociateSchedule(Boolean disassociateSchedule) {
            this.disassociateSchedule = disassociateSchedule;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterSnapshotScheduleRequest build() {
            return new ModifyClusterSnapshotScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
