/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedNodeOfferingRequest extends RedshiftRequest implements
        ToCopyableBuilder<PurchaseReservedNodeOfferingRequest.Builder, PurchaseReservedNodeOfferingRequest> {
    private static final SdkField<String> RESERVED_NODE_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseReservedNodeOfferingRequest::reservedNodeOfferingId))
            .setter(setter(Builder::reservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingId").build())
            .build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PurchaseReservedNodeOfferingRequest::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_NODE_OFFERING_ID_FIELD, NODE_COUNT_FIELD));

    private final String reservedNodeOfferingId;

    private final Integer nodeCount;

    private PurchaseReservedNodeOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeCount = builder.nodeCount;
    }

    /**
     * <p>
     * The unique identifier of the reserved node offering you want to purchase.
     * </p>
     * 
     * @return The unique identifier of the reserved node offering you want to purchase.
     */
    public String reservedNodeOfferingId() {
        return reservedNodeOfferingId;
    }

    /**
     * <p>
     * The number of reserved nodes that you want to purchase.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * 
     * @return The number of reserved nodes that you want to purchase.</p>
     *         <p>
     *         Default: <code>1</code>
     */
    public Integer nodeCount() {
        return nodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedNodeOfferingRequest)) {
            return false;
        }
        PurchaseReservedNodeOfferingRequest other = (PurchaseReservedNodeOfferingRequest) obj;
        return Objects.equals(reservedNodeOfferingId(), other.reservedNodeOfferingId())
                && Objects.equals(nodeCount(), other.nodeCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseReservedNodeOfferingRequest").add("ReservedNodeOfferingId", reservedNodeOfferingId())
                .add("NodeCount", nodeCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(reservedNodeOfferingId()));
        case "NodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedNodeOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedNodeOfferingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedNodeOfferingRequest> {
        /**
         * <p>
         * The unique identifier of the reserved node offering you want to purchase.
         * </p>
         * 
         * @param reservedNodeOfferingId
         *        The unique identifier of the reserved node offering you want to purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeOfferingId(String reservedNodeOfferingId);

        /**
         * <p>
         * The number of reserved nodes that you want to purchase.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * 
         * @param nodeCount
         *        The number of reserved nodes that you want to purchase.</p>
         *        <p>
         *        Default: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String reservedNodeOfferingId;

        private Integer nodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedNodeOfferingRequest model) {
            super(model);
            reservedNodeOfferingId(model.reservedNodeOfferingId);
            nodeCount(model.nodeCount);
        }

        public final String getReservedNodeOfferingId() {
            return reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedNodeOfferingRequest build() {
            return new PurchaseReservedNodeOfferingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
