/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUsageLimitsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeUsageLimitsResponse.Builder, DescribeUsageLimitsResponse> {
    private static final SdkField<List<UsageLimit>> USAGE_LIMITS_FIELD = SdkField
            .<List<UsageLimit>> builder(MarshallingType.LIST)
            .getter(getter(DescribeUsageLimitsResponse::usageLimits))
            .setter(setter(Builder::usageLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeUsageLimitsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMITS_FIELD,
            MARKER_FIELD));

    private final List<UsageLimit> usageLimits;

    private final String marker;

    private DescribeUsageLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.usageLimits = builder.usageLimits;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the UsageLimits property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsageLimits() {
        return usageLimits != null && !(usageLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the output from the <a>DescribeUsageLimits</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsageLimits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the output from the <a>DescribeUsageLimits</a> action.
     */
    public List<UsageLimit> usageLimits() {
        return usageLimits;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUsageLimitsResponse)) {
            return false;
        }
        DescribeUsageLimitsResponse other = (DescribeUsageLimitsResponse) obj;
        return Objects.equals(usageLimits(), other.usageLimits()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeUsageLimitsResponse").add("UsageLimits", usageLimits()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageLimits":
            return Optional.ofNullable(clazz.cast(usageLimits()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUsageLimitsResponse, T> g) {
        return obj -> g.apply((DescribeUsageLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUsageLimitsResponse> {
        /**
         * <p>
         * Contains the output from the <a>DescribeUsageLimits</a> action.
         * </p>
         * 
         * @param usageLimits
         *        Contains the output from the <a>DescribeUsageLimits</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimits(Collection<UsageLimit> usageLimits);

        /**
         * <p>
         * Contains the output from the <a>DescribeUsageLimits</a> action.
         * </p>
         * 
         * @param usageLimits
         *        Contains the output from the <a>DescribeUsageLimits</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimits(UsageLimit... usageLimits);

        /**
         * <p>
         * Contains the output from the <a>DescribeUsageLimits</a> action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UsageLimit>.Builder} avoiding the need to
         * create one manually via {@link List<UsageLimit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UsageLimit>.Builder#build()} is called immediately and its
         * result is passed to {@link #usageLimits(List<UsageLimit>)}.
         * 
         * @param usageLimits
         *        a consumer that will call methods on {@link List<UsageLimit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageLimits(List<UsageLimit>)
         */
        Builder usageLimits(Consumer<UsageLimit.Builder>... usageLimits);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<UsageLimit> usageLimits = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUsageLimitsResponse model) {
            super(model);
            usageLimits(model.usageLimits);
            marker(model.marker);
        }

        public final Collection<UsageLimit.Builder> getUsageLimits() {
            return usageLimits != null ? usageLimits.stream().map(UsageLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder usageLimits(Collection<UsageLimit> usageLimits) {
            this.usageLimits = UsageLimitsCopier.copy(usageLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageLimits(UsageLimit... usageLimits) {
            usageLimits(Arrays.asList(usageLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageLimits(Consumer<UsageLimit.Builder>... usageLimits) {
            usageLimits(Stream.of(usageLimits).map(c -> UsageLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUsageLimits(Collection<UsageLimit.BuilderImpl> usageLimits) {
            this.usageLimits = UsageLimitsCopier.copyFromBuilder(usageLimits);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeUsageLimitsResponse build() {
            return new DescribeUsageLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
