/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeClusterSubnetGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterSubnetGroupsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterSubnetGroupsResponse.Builder, DescribeClusterSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterSubnetGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterSubnetGroup>> CLUSTER_SUBNET_GROUPS_FIELD = SdkField
            .<List<ClusterSubnetGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClusterSubnetGroupsResponse::clusterSubnetGroups))
            .setter(setter(Builder::clusterSubnetGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSubnetGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterSubnetGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSubnetGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSubnetGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CLUSTER_SUBNET_GROUPS_FIELD));

    private final String marker;

    private final List<ClusterSubnetGroup> clusterSubnetGroups;

    private DescribeClusterSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSubnetGroups = builder.clusterSubnetGroups;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ClusterSubnetGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasClusterSubnetGroups() {
        return clusterSubnetGroups != null && !(clusterSubnetGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>ClusterSubnetGroup</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterSubnetGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>ClusterSubnetGroup</a> instances.
     */
    public List<ClusterSubnetGroup> clusterSubnetGroups() {
        return clusterSubnetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSubnetGroupsResponse)) {
            return false;
        }
        DescribeClusterSubnetGroupsResponse other = (DescribeClusterSubnetGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(clusterSubnetGroups(), other.clusterSubnetGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClusterSubnetGroupsResponse").add("Marker", marker())
                .add("ClusterSubnetGroups", clusterSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ClusterSubnetGroups":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterSubnetGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>ClusterSubnetGroup</a> instances.
         * </p>
         * 
         * @param clusterSubnetGroups
         *        A list of <a>ClusterSubnetGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups);

        /**
         * <p>
         * A list of <a>ClusterSubnetGroup</a> instances.
         * </p>
         * 
         * @param clusterSubnetGroups
         *        A list of <a>ClusterSubnetGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroups(ClusterSubnetGroup... clusterSubnetGroups);

        /**
         * <p>
         * A list of <a>ClusterSubnetGroup</a> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterSubnetGroup>.Builder} avoiding the
         * need to create one manually via {@link List<ClusterSubnetGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterSubnetGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterSubnetGroups(List<ClusterSubnetGroup>)}.
         * 
         * @param clusterSubnetGroups
         *        a consumer that will call methods on {@link List<ClusterSubnetGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSubnetGroups(List<ClusterSubnetGroup>)
         */
        Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder>... clusterSubnetGroups);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterSubnetGroup> clusterSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSubnetGroupsResponse model) {
            super(model);
            marker(model.marker);
            clusterSubnetGroups(model.clusterSubnetGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSubnetGroup.Builder> getClusterSubnetGroups() {
            return clusterSubnetGroups != null ? clusterSubnetGroups.stream().map(ClusterSubnetGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copy(clusterSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(ClusterSubnetGroup... clusterSubnetGroups) {
            clusterSubnetGroups(Arrays.asList(clusterSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder>... clusterSubnetGroups) {
            clusterSubnetGroups(Stream.of(clusterSubnetGroups).map(c -> ClusterSubnetGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClusterSubnetGroups(Collection<ClusterSubnetGroup.BuilderImpl> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copyFromBuilder(clusterSubnetGroups);
        }

        @Override
        public DescribeClusterSubnetGroupsResponse build() {
            return new DescribeClusterSubnetGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
