/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClusterRequest extends RedshiftRequest implements
        ToCopyableBuilder<DeleteClusterRequest.Builder, DeleteClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClusterRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Boolean> SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(DeleteClusterRequest::skipFinalClusterSnapshot))
            .setter(setter(Builder::skipFinalClusterSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalClusterSnapshot").build())
            .build();

    private static final SdkField<String> FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteClusterRequest::finalClusterSnapshotIdentifier))
            .setter(setter(Builder::finalClusterSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalClusterSnapshotIdentifier")
                    .build()).build();

    private static final SdkField<Integer> FINAL_CLUSTER_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DeleteClusterRequest::finalClusterSnapshotRetentionPeriod))
            .setter(setter(Builder::finalClusterSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FinalClusterSnapshotRetentionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD, FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD,
            FINAL_CLUSTER_SNAPSHOT_RETENTION_PERIOD_FIELD));

    private final String clusterIdentifier;

    private final Boolean skipFinalClusterSnapshot;

    private final String finalClusterSnapshotIdentifier;

    private final Integer finalClusterSnapshotRetentionPeriod;

    private DeleteClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.skipFinalClusterSnapshot = builder.skipFinalClusterSnapshot;
        this.finalClusterSnapshotIdentifier = builder.finalClusterSnapshotIdentifier;
        this.finalClusterSnapshotRetentionPeriod = builder.finalClusterSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The identifier of the cluster to be deleted.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain lowercase characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the cluster to be deleted.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain lowercase characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If
     * <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is
     * created before the cluster is deleted.
     * </p>
     * <note>
     * <p>
     * The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is
     * <code>false</code>.
     * </p>
     * </note>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster.
     *         If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster
     *         snapshot is created before the cluster is deleted. </p> <note>
     *         <p>
     *         The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i>
     *         is <code>false</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean skipFinalClusterSnapshot() {
        return skipFinalClusterSnapshot;
    }

    /**
     * <p>
     * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this
     * parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be 1 to 255 alphanumeric characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the final snapshot that is to be created immediately before deleting the cluster. If
     *         this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be 1 to 255 alphanumeric characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     */
    public String finalClusterSnapshotIdentifier() {
        return finalClusterSnapshotIdentifier;
    }

    /**
     * <p>
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
     * indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * <p>
     * The default value is -1.
     * </p>
     * 
     * @return The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
     *         retained indefinitely.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     *         </p>
     *         <p>
     *         The default value is -1.
     */
    public Integer finalClusterSnapshotRetentionPeriod() {
        return finalClusterSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(finalClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(finalClusterSnapshotRetentionPeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(skipFinalClusterSnapshot(), other.skipFinalClusterSnapshot())
                && Objects.equals(finalClusterSnapshotIdentifier(), other.finalClusterSnapshotIdentifier())
                && Objects.equals(finalClusterSnapshotRetentionPeriod(), other.finalClusterSnapshotRetentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteClusterRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("SkipFinalClusterSnapshot", skipFinalClusterSnapshot())
                .add("FinalClusterSnapshotIdentifier", finalClusterSnapshotIdentifier())
                .add("FinalClusterSnapshotRetentionPeriod", finalClusterSnapshotRetentionPeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SkipFinalClusterSnapshot":
            return Optional.ofNullable(clazz.cast(skipFinalClusterSnapshot()));
        case "FinalClusterSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(finalClusterSnapshotIdentifier()));
        case "FinalClusterSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(finalClusterSnapshotRetentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterRequest, T> g) {
        return obj -> g.apply((DeleteClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteClusterRequest> {
        /**
         * <p>
         * The identifier of the cluster to be deleted.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain lowercase characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster to be deleted.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain lowercase characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If
         * <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot
         * is created before the cluster is deleted.
         * </p>
         * <note>
         * <p>
         * The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is
         * <code>false</code>.
         * </p>
         * </note>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param skipFinalClusterSnapshot
         *        Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the
         *        cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final
         *        cluster snapshot is created before the cluster is deleted. </p> <note>
         *        <p>
         *        The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if
         *        <i>SkipFinalClusterSnapshot</i> is <code>false</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot);

        /**
         * <p>
         * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this
         * parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be 1 to 255 alphanumeric characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * 
         * @param finalClusterSnapshotIdentifier
         *        The identifier of the final snapshot that is to be created immediately before deleting the cluster. If
         *        this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be 1 to 255 alphanumeric characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier);

        /**
         * <p>
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
         * indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * <p>
         * The default value is -1.
         * </p>
         * 
         * @param finalClusterSnapshotRetentionPeriod
         *        The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
         *        retained indefinitely.</p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         *        </p>
         *        <p>
         *        The default value is -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalClusterSnapshotRetentionPeriod(Integer finalClusterSnapshotRetentionPeriod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Boolean skipFinalClusterSnapshot;

        private String finalClusterSnapshotIdentifier;

        private Integer finalClusterSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            skipFinalClusterSnapshot(model.skipFinalClusterSnapshot);
            finalClusterSnapshotIdentifier(model.finalClusterSnapshotIdentifier);
            finalClusterSnapshotRetentionPeriod(model.finalClusterSnapshotRetentionPeriod);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getSkipFinalClusterSnapshot() {
            return skipFinalClusterSnapshot;
        }

        @Override
        public final Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
            return this;
        }

        public final void setSkipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
        }

        public final String getFinalClusterSnapshotIdentifier() {
            return finalClusterSnapshotIdentifier;
        }

        @Override
        public final Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
            return this;
        }

        public final void setFinalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
        }

        public final Integer getFinalClusterSnapshotRetentionPeriod() {
            return finalClusterSnapshotRetentionPeriod;
        }

        @Override
        public final Builder finalClusterSnapshotRetentionPeriod(Integer finalClusterSnapshotRetentionPeriod) {
            this.finalClusterSnapshotRetentionPeriod = finalClusterSnapshotRetentionPeriod;
            return this;
        }

        public final void setFinalClusterSnapshotRetentionPeriod(Integer finalClusterSnapshotRetentionPeriod) {
            this.finalClusterSnapshotRetentionPeriod = finalClusterSnapshotRetentionPeriod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
