/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeClusterSecurityGroupIngressRequest extends RedshiftRequest implements
        ToCopyableBuilder<AuthorizeClusterSecurityGroupIngressRequest.Builder, AuthorizeClusterSecurityGroupIngressRequest> {
    private static final SdkField<String> CLUSTER_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeClusterSecurityGroupIngressRequest::clusterSecurityGroupName))
            .setter(setter(Builder::clusterSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build())
            .build();

    private static final SdkField<String> CIDRIP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeClusterSecurityGroupIngressRequest::cidrip)).setter(setter(Builder::cidrip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRIP").build()).build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeClusterSecurityGroupIngressRequest::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuthorizeClusterSecurityGroupIngressRequest::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SECURITY_GROUP_NAME_FIELD, CIDRIP_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));

    private final String clusterSecurityGroupName;

    private final String cidrip;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupOwnerId;

    private AuthorizeClusterSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * The name of the security group to which the ingress rule is added.
     * </p>
     * 
     * @return The name of the security group to which the ingress rule is added.
     */
    public String clusterSecurityGroupName() {
        return clusterSecurityGroupName;
    }

    /**
     * <p>
     * The IP range to be added the Amazon Redshift security group.
     * </p>
     * 
     * @return The IP range to be added the Amazon Redshift security group.
     */
    public String cidrip() {
        return cidrip;
    }

    /**
     * <p>
     * The EC2 security group to be added the Amazon Redshift security group.
     * </p>
     * 
     * @return The EC2 security group to be added the Amazon Redshift security group.
     */
    public String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * The AWS account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter.
     * The AWS Access Key ID is not an acceptable value.
     * </p>
     * <p>
     * Example: <code>111122223333</code>
     * </p>
     * 
     * @return The AWS account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i>
     *         parameter. The AWS Access Key ID is not an acceptable value. </p>
     *         <p>
     *         Example: <code>111122223333</code>
     */
    public String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeClusterSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeClusterSecurityGroupIngressRequest other = (AuthorizeClusterSecurityGroupIngressRequest) obj;
        return Objects.equals(clusterSecurityGroupName(), other.clusterSecurityGroupName())
                && Objects.equals(cidrip(), other.cidrip())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuthorizeClusterSecurityGroupIngressRequest")
                .add("ClusterSecurityGroupName", clusterSecurityGroupName()).add("CIDRIP", cidrip())
                .add("EC2SecurityGroupName", ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", ec2SecurityGroupOwnerId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSecurityGroupName":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroupName()));
        case "CIDRIP":
            return Optional.ofNullable(clazz.cast(cidrip()));
        case "EC2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "EC2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeClusterSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((AuthorizeClusterSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AuthorizeClusterSecurityGroupIngressRequest> {
        /**
         * <p>
         * The name of the security group to which the ingress rule is added.
         * </p>
         * 
         * @param clusterSecurityGroupName
         *        The name of the security group to which the ingress rule is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroupName(String clusterSecurityGroupName);

        /**
         * <p>
         * The IP range to be added the Amazon Redshift security group.
         * </p>
         * 
         * @param cidrip
         *        The IP range to be added the Amazon Redshift security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrip(String cidrip);

        /**
         * <p>
         * The EC2 security group to be added the Amazon Redshift security group.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        The EC2 security group to be added the Amazon Redshift security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * The AWS account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i>
         * parameter. The AWS Access Key ID is not an acceptable value.
         * </p>
         * <p>
         * Example: <code>111122223333</code>
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        The AWS account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i>
         *        parameter. The AWS Access Key ID is not an acceptable value. </p>
         *        <p>
         *        Example: <code>111122223333</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterSecurityGroupName;

        private String cidrip;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeClusterSecurityGroupIngressRequest model) {
            super(model);
            clusterSecurityGroupName(model.clusterSecurityGroupName);
            cidrip(model.cidrip);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getClusterSecurityGroupName() {
            return clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getCidrip() {
            return cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCidrip(String cidrip) {
            this.cidrip = cidrip;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeClusterSecurityGroupIngressRequest build() {
            return new AuthorizeClusterSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
