/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.Snapshot;

public class DescribeClusterSnapshotsIterable
implements SdkIterable<DescribeClusterSnapshotsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterSnapshotsIterable(RedshiftClient client, DescribeClusterSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSnapshotsResponseFetcher();
    }

    public Iterator<DescribeClusterSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Snapshot> snapshots() {
        Function<DescribeClusterSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeClusterSnapshotsIterable resume(DescribeClusterSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSnapshotsIterable(this.client, (DescribeClusterSnapshotsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSnapshotsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterSnapshotsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterSnapshotsResponseFetcher
    implements SyncPageFetcher<DescribeClusterSnapshotsResponse> {
        private DescribeClusterSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeClusterSnapshotsResponse nextPage(DescribeClusterSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSnapshotsIterable.this.client.describeClusterSnapshots(DescribeClusterSnapshotsIterable.this.firstRequest);
            }
            return DescribeClusterSnapshotsIterable.this.client.describeClusterSnapshots((DescribeClusterSnapshotsRequest)((Object)DescribeClusterSnapshotsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

