/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterDbRevisionRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterDbRevisionRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyClusterDbRevisionRequest.getter(ModifyClusterDbRevisionRequest::clusterIdentifier)).setter(ModifyClusterDbRevisionRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> REVISION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyClusterDbRevisionRequest.getter(ModifyClusterDbRevisionRequest::revisionTarget)).setter(ModifyClusterDbRevisionRequest.setter(Builder::revisionTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, REVISION_TARGET_FIELD));
    private final String clusterIdentifier;
    private final String revisionTarget;

    private ModifyClusterDbRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.revisionTarget = builder.revisionTarget;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String revisionTarget() {
        return this.revisionTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionTarget());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterDbRevisionRequest)) {
            return false;
        }
        ModifyClusterDbRevisionRequest other = (ModifyClusterDbRevisionRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.revisionTarget(), other.revisionTarget());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClusterDbRevisionRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("RevisionTarget", (Object)this.revisionTarget()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "RevisionTarget": {
                return Optional.ofNullable(clazz.cast(this.revisionTarget()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterDbRevisionRequest, T> g) {
        return obj -> g.apply((ModifyClusterDbRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String revisionTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterDbRevisionRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.revisionTarget(model.revisionTarget);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getRevisionTarget() {
            return this.revisionTarget;
        }

        @Override
        public final Builder revisionTarget(String revisionTarget) {
            this.revisionTarget = revisionTarget;
            return this;
        }

        public final void setRevisionTarget(String revisionTarget) {
            this.revisionTarget = revisionTarget;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterDbRevisionRequest build() {
            return new ModifyClusterDbRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterDbRevisionRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder revisionTarget(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

