/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledSnapshotTimeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotSchedule> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleDefinitions)).setter(SnapshotSchedule.setter(Builder::scheduleDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(), ListTrait.builder().memberLocationName("ScheduleDefinition").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinition").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleIdentifier)).setter(SnapshotSchedule.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnapshotSchedule.getter(SnapshotSchedule::scheduleDescription)).setter(SnapshotSchedule.setter(Builder::scheduleDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SnapshotSchedule.getter(SnapshotSchedule::tags)).setter(SnapshotSchedule.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SnapshotSchedule.getter(SnapshotSchedule::nextInvocations)).setter(SnapshotSchedule.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(), ListTrait.builder().memberLocationName("SnapshotTime").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTime").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD, SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, NEXT_INVOCATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> scheduleDefinitions;
    private final String scheduleIdentifier;
    private final String scheduleDescription;
    private final List<Tag> tags;
    private final List<Instant> nextInvocations;

    private SnapshotSchedule(BuilderImpl builder) {
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.nextInvocations = builder.nextInvocations;
    }

    public List<String> scheduleDefinitions() {
        return this.scheduleDefinitions;
    }

    public String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public String scheduleDescription() {
        return this.scheduleDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotSchedule)) {
            return false;
        }
        SnapshotSchedule other = (SnapshotSchedule)obj;
        return Objects.equals(this.scheduleDefinitions(), other.scheduleDefinitions()) && Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && Objects.equals(this.scheduleDescription(), other.scheduleDescription()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.nextInvocations(), other.nextInvocations());
    }

    public String toString() {
        return ToString.builder((String)"SnapshotSchedule").add("ScheduleDefinitions", this.scheduleDefinitions()).add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("ScheduleDescription", (Object)this.scheduleDescription()).add("Tags", this.tags()).add("NextInvocations", this.nextInvocations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleDefinitions": {
                return Optional.ofNullable(clazz.cast(this.scheduleDefinitions()));
            }
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "ScheduleDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduleDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotSchedule, T> g) {
        return obj -> g.apply((SnapshotSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String scheduleIdentifier;
        private String scheduleDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotSchedule model) {
            this.scheduleDefinitions(model.scheduleDefinitions);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.scheduleDescription(model.scheduleDescription);
            this.tags(model.tags);
            this.nextInvocations(model.nextInvocations);
        }

        public final Collection<String> getScheduleDefinitions() {
            return this.scheduleDefinitions;
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String ... scheduleDefinitions) {
            this.scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final String getScheduleDescription() {
            return this.scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<Instant> getNextInvocations() {
            return this.nextInvocations;
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
        }

        public SnapshotSchedule build() {
            return new SnapshotSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotSchedule> {
        public Builder scheduleDefinitions(Collection<String> var1);

        public Builder scheduleDefinitions(String ... var1);

        public Builder scheduleIdentifier(String var1);

        public Builder scheduleDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);
    }
}

