/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a sorting entity
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotSortingEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotSortingEntity.Builder, SnapshotSortingEntity> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotSortingEntity::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotSortingEntity::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String sortOrder;

    private SnapshotSortingEntity(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The category for sorting the snapshots.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeToSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The category for sorting the snapshots.
     * @see SnapshotAttributeToSortBy
     */
    public SnapshotAttributeToSortBy attribute() {
        return SnapshotAttributeToSortBy.fromValue(attribute);
    }

    /**
     * <p>
     * The category for sorting the snapshots.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeToSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The category for sorting the snapshots.
     * @see SnapshotAttributeToSortBy
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The order for listing the attributes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortByOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order for listing the attributes.
     * @see SortByOrder
     */
    public SortByOrder sortOrder() {
        return SortByOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order for listing the attributes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortByOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order for listing the attributes.
     * @see SortByOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotSortingEntity)) {
            return false;
        }
        SnapshotSortingEntity other = (SnapshotSortingEntity) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("SnapshotSortingEntity").add("Attribute", attributeAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotSortingEntity, T> g) {
        return obj -> g.apply((SnapshotSortingEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotSortingEntity> {
        /**
         * <p>
         * The category for sorting the snapshots.
         * </p>
         * 
         * @param attribute
         *        The category for sorting the snapshots.
         * @see SnapshotAttributeToSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeToSortBy
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The category for sorting the snapshots.
         * </p>
         * 
         * @param attribute
         *        The category for sorting the snapshots.
         * @see SnapshotAttributeToSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeToSortBy
         */
        Builder attribute(SnapshotAttributeToSortBy attribute);

        /**
         * <p>
         * The order for listing the attributes.
         * </p>
         * 
         * @param sortOrder
         *        The order for listing the attributes.
         * @see SortByOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortByOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order for listing the attributes.
         * </p>
         * 
         * @param sortOrder
         *        The order for listing the attributes.
         * @see SortByOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortByOrder
         */
        Builder sortOrder(SortByOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotSortingEntity model) {
            attribute(model.attribute);
            sortOrder(model.sortOrder);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeToSortBy attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortByOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public SnapshotSortingEntity build() {
            return new SnapshotSortingEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
