/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::snapshotIdentifier)).setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Snapshot::snapshotCreateTime)).setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Snapshot::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Snapshot::clusterCreateTime)).setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::clusterVersion)).setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::snapshotType)).setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Snapshot::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Snapshot::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_WITH_HSM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Snapshot::encryptedWithHSM)).setter(setter(Builder::encryptedWithHSM))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedWithHSM").build()).build();

    private static final SdkField<List<AccountWithRestoreAccess>> ACCOUNTS_WITH_RESTORE_ACCESS_FIELD = SdkField
            .<List<AccountWithRestoreAccess>> builder(MarshallingType.LIST)
            .getter(getter(Snapshot::accountsWithRestoreAccess))
            .setter(setter(Builder::accountsWithRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountsWithRestoreAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccountWithRestoreAccess")
                            .memberFieldInfo(
                                    SdkField.<AccountWithRestoreAccess> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountWithRestoreAccess::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccountWithRestoreAccess").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Snapshot::totalBackupSizeInMegaBytes))
            .setter(setter(Builder::totalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBackupSizeInMegaBytes").build())
            .build();

    private static final SdkField<Double> ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Snapshot::actualIncrementalBackupSizeInMegaBytes))
            .setter(setter(Builder::actualIncrementalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ActualIncrementalBackupSizeInMegaBytes").build()).build();

    private static final SdkField<Double> BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Snapshot::backupProgressInMegaBytes)).setter(setter(Builder::backupProgressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupProgressInMegaBytes").build())
            .build();

    private static final SdkField<Double> CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Snapshot::currentBackupRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentBackupRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CurrentBackupRateInMegaBytesPerSecond").build()).build();

    private static final SdkField<Long> ESTIMATED_SECONDS_TO_COMPLETION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(Snapshot::estimatedSecondsToCompletion))
            .setter(setter(Builder::estimatedSecondsToCompletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSecondsToCompletion")
                    .build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Snapshot::elapsedTimeInSeconds)).setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Snapshot::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<String>> RESTORABLE_NODE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Snapshot::restorableNodeTypes))
            .setter(setter(Builder::restorableNodeTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableNodeTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("NodeType")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("NodeType").build()).build()).build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Snapshot::enhancedVpcRouting)).setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Snapshot::maintenanceTrackName)).setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Snapshot::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_REMAINING_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Snapshot::manualSnapshotRemainingDays))
            .setter(setter(Builder::manualSnapshotRemainingDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRemainingDays")
                    .build()).build();

    private static final SdkField<Instant> SNAPSHOT_RETENTION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Snapshot::snapshotRetentionStartTime))
            .setter(setter(Builder::snapshotRetentionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_CREATE_TIME_FIELD, STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD,
            CLUSTER_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, CLUSTER_VERSION_FIELD, SNAPSHOT_TYPE_FIELD, NODE_TYPE_FIELD,
            NUMBER_OF_NODES_FIELD, DB_NAME_FIELD, VPC_ID_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, ENCRYPTED_WITH_HSM_FIELD,
            ACCOUNTS_WITH_RESTORE_ACCESS_FIELD, OWNER_ACCOUNT_FIELD, TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD,
            ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD,
            CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, ESTIMATED_SECONDS_TO_COMPLETION_FIELD,
            ELAPSED_TIME_IN_SECONDS_FIELD, SOURCE_REGION_FIELD, TAGS_FIELD, RESTORABLE_NODE_TYPES_FIELD,
            ENHANCED_VPC_ROUTING_FIELD, MAINTENANCE_TRACK_NAME_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD,
            MANUAL_SNAPSHOT_REMAINING_DAYS_FIELD, SNAPSHOT_RETENTION_START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotIdentifier;

    private final String clusterIdentifier;

    private final Instant snapshotCreateTime;

    private final String status;

    private final Integer port;

    private final String availabilityZone;

    private final Instant clusterCreateTime;

    private final String masterUsername;

    private final String clusterVersion;

    private final String snapshotType;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final String dbName;

    private final String vpcId;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final Boolean encryptedWithHSM;

    private final List<AccountWithRestoreAccess> accountsWithRestoreAccess;

    private final String ownerAccount;

    private final Double totalBackupSizeInMegaBytes;

    private final Double actualIncrementalBackupSizeInMegaBytes;

    private final Double backupProgressInMegaBytes;

    private final Double currentBackupRateInMegaBytesPerSecond;

    private final Long estimatedSecondsToCompletion;

    private final Long elapsedTimeInSeconds;

    private final String sourceRegion;

    private final List<Tag> tags;

    private final List<String> restorableNodeTypes;

    private final Boolean enhancedVpcRouting;

    private final String maintenanceTrackName;

    private final Integer manualSnapshotRetentionPeriod;

    private final Integer manualSnapshotRemainingDays;

    private final Instant snapshotRetentionStartTime;

    private Snapshot(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.clusterVersion = builder.clusterVersion;
        this.snapshotType = builder.snapshotType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.dbName = builder.dbName;
        this.vpcId = builder.vpcId;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptedWithHSM = builder.encryptedWithHSM;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.ownerAccount = builder.ownerAccount;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.sourceRegion = builder.sourceRegion;
        this.tags = builder.tags;
        this.restorableNodeTypes = builder.restorableNodeTypes;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.manualSnapshotRemainingDays = builder.manualSnapshotRemainingDays;
        this.snapshotRetentionStartTime = builder.snapshotRetentionStartTime;
    }

    /**
     * <p>
     * The snapshot identifier that is provided in the request.
     * </p>
     * 
     * @return The snapshot identifier that is provided in the request.
     */
    public String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The identifier of the cluster for which the snapshot was taken.
     * </p>
     * 
     * @return The identifier of the cluster for which the snapshot was taken.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data
     * as of this exact time.
     * </p>
     * 
     * @return The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the
     *         cluster data as of this exact time.
     */
    public Instant snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The snapshot status. The value of the status depends on the API operation used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>DeleteClusterSnapshot</a> returns status as "deleted".
     * </p>
     * </li>
     * </ul>
     * 
     * @return The snapshot status. The value of the status depends on the API operation used: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>DeleteClusterSnapshot</a> returns status as "deleted".
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The port that the cluster is listening on.
     * </p>
     * 
     * @return The port that the cluster is listening on.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The Availability Zone in which the cluster was created.
     * </p>
     * 
     * @return The Availability Zone in which the cluster was created.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The time (UTC) when the cluster was originally created.
     * </p>
     * 
     * @return The time (UTC) when the cluster was originally created.
     */
    public Instant clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * The master user name for the cluster.
     * </p>
     * 
     * @return The master user name for the cluster.
     */
    public String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     * </p>
     * 
     * @return The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    public String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of
     * type "manual".
     * </p>
     * 
     * @return The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a>
     *         are of type "manual".
     */
    public String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * The node type of the nodes in the cluster.
     * </p>
     * 
     * @return The node type of the nodes in the cluster.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The number of nodes in the cluster.
     * </p>
     * 
     * @return The number of nodes in the cluster.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The name of the database that was created when the cluster was created.
     * </p>
     * 
     * @return The name of the database that was created when the cluster was created.
     */
    public String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the
     * output.
     * </p>
     * 
     * @return The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is
     *         not in the output.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * If <code>true</code>, the data in the snapshot is encrypted at rest.
     * </p>
     * 
     * @return If <code>true</code>, the data in the snapshot is encrypted at rest.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The AWS Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster
     * from which the snapshot was taken.
     * </p>
     * 
     * @return The AWS Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the
     *         cluster from which the snapshot was taken.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
     * <code>true</code> indicates that the data is encrypted using HSM keys.
     * </p>
     * 
     * @return A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
     *         <code>true</code> indicates that the data is encrypted using HSM keys.
     */
    public Boolean encryptedWithHSM() {
        return encryptedWithHSM;
    }

    /**
     * <p>
     * A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts
     * are authorized. Visible only to the snapshot owner.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no
     *         accounts are authorized. Visible only to the snapshot owner.
     */
    public List<AccountWithRestoreAccess> accountsWithRestoreAccess() {
        return accountsWithRestoreAccess;
    }

    /**
     * <p>
     * For manual snapshots, the AWS customer account used to create or copy the snapshot. For automatic snapshots, the
     * owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     * </p>
     * 
     * @return For manual snapshots, the AWS customer account used to create or copy the snapshot. For automatic
     *         snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual
     *         snapshot.
     */
    public String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The size of the complete set of backup data that would be used to restore the cluster.
     * </p>
     * 
     * @return The size of the complete set of backup data that would be used to restore the cluster.
     */
    public Double totalBackupSizeInMegaBytes() {
        return totalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The size of the incremental backup.
     * </p>
     * 
     * @return The size of the incremental backup.
     */
    public Double actualIncrementalBackupSizeInMegaBytes() {
        return actualIncrementalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The number of megabytes that have been transferred to the snapshot backup.
     * </p>
     * 
     * @return The number of megabytes that have been transferred to the snapshot backup.
     */
    public Double backupProgressInMegaBytes() {
        return backupProgressInMegaBytes;
    }

    /**
     * <p>
     * The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
     * completed backup.
     * </p>
     * 
     * @return The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
     *         completed backup.
     */
    public Double currentBackupRateInMegaBytesPerSecond() {
        return currentBackupRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
     * completed backup.
     * </p>
     * 
     * @return The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
     *         completed backup.
     */
    public Long estimatedSecondsToCompletion() {
        return estimatedSecondsToCompletion;
    }

    /**
     * <p>
     * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed
     * backup to finish.
     * </p>
     * 
     * @return The amount of time an in-progress snapshot backup has been running, or the amount of time it took a
     *         completed backup to finish.
     */
    public Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The source region from which the snapshot was copied.
     * </p>
     * 
     * @return The source region from which the snapshot was copied.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The list of tags for the cluster snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags for the cluster snapshot.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The list of node types that this cluster snapshot is able to restore into.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of node types that this cluster snapshot is able to restore into.
     */
    public List<String> restorableNodeTypes() {
        return restorableNodeTypes;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a>
     *         in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The name of the maintenance track for the snapshot.
     * </p>
     * 
     * @return The name of the maintenance track for the snapshot.
     */
    public String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
     * indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
     *         retained indefinitely. </p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The number of days until a manual snapshot will pass its retention period.
     * </p>
     * 
     * @return The number of days until a manual snapshot will pass its retention period.
     */
    public Integer manualSnapshotRemainingDays() {
        return manualSnapshotRemainingDays;
    }

    /**
     * <p>
     * A timestamp representing the start of the retention period for the snapshot.
     * </p>
     * 
     * @return A timestamp representing the start of the retention period for the snapshot.
     */
    public Instant snapshotRetentionStartTime() {
        return snapshotRetentionStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedWithHSM());
        hashCode = 31 * hashCode + Objects.hashCode(accountsWithRestoreAccess());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(totalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(actualIncrementalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupProgressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(currentBackupRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSecondsToCompletion());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(restorableNodeTypes());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRemainingDays());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionStartTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(numberOfNodes(), other.numberOfNodes()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(encryptedWithHSM(), other.encryptedWithHSM())
                && Objects.equals(accountsWithRestoreAccess(), other.accountsWithRestoreAccess())
                && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes())
                && Objects.equals(actualIncrementalBackupSizeInMegaBytes(), other.actualIncrementalBackupSizeInMegaBytes())
                && Objects.equals(backupProgressInMegaBytes(), other.backupProgressInMegaBytes())
                && Objects.equals(currentBackupRateInMegaBytesPerSecond(), other.currentBackupRateInMegaBytesPerSecond())
                && Objects.equals(estimatedSecondsToCompletion(), other.estimatedSecondsToCompletion())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && Objects.equals(tags(), other.tags())
                && Objects.equals(restorableNodeTypes(), other.restorableNodeTypes())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRemainingDays(), other.manualSnapshotRemainingDays())
                && Objects.equals(snapshotRetentionStartTime(), other.snapshotRetentionStartTime());
    }

    @Override
    public String toString() {
        return ToString.builder("Snapshot").add("SnapshotIdentifier", snapshotIdentifier())
                .add("ClusterIdentifier", clusterIdentifier()).add("SnapshotCreateTime", snapshotCreateTime())
                .add("Status", status()).add("Port", port()).add("AvailabilityZone", availabilityZone())
                .add("ClusterCreateTime", clusterCreateTime()).add("MasterUsername", masterUsername())
                .add("ClusterVersion", clusterVersion()).add("SnapshotType", snapshotType()).add("NodeType", nodeType())
                .add("NumberOfNodes", numberOfNodes()).add("DBName", dbName()).add("VpcId", vpcId())
                .add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId()).add("EncryptedWithHSM", encryptedWithHSM())
                .add("AccountsWithRestoreAccess", accountsWithRestoreAccess()).add("OwnerAccount", ownerAccount())
                .add("TotalBackupSizeInMegaBytes", totalBackupSizeInMegaBytes())
                .add("ActualIncrementalBackupSizeInMegaBytes", actualIncrementalBackupSizeInMegaBytes())
                .add("BackupProgressInMegaBytes", backupProgressInMegaBytes())
                .add("CurrentBackupRateInMegaBytesPerSecond", currentBackupRateInMegaBytesPerSecond())
                .add("EstimatedSecondsToCompletion", estimatedSecondsToCompletion())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds()).add("SourceRegion", sourceRegion()).add("Tags", tags())
                .add("RestorableNodeTypes", restorableNodeTypes()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("MaintenanceTrackName", maintenanceTrackName())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod())
                .add("ManualSnapshotRemainingDays", manualSnapshotRemainingDays())
                .add("SnapshotRetentionStartTime", snapshotRetentionStartTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EncryptedWithHSM":
            return Optional.ofNullable(clazz.cast(encryptedWithHSM()));
        case "AccountsWithRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountsWithRestoreAccess()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "TotalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalBackupSizeInMegaBytes()));
        case "ActualIncrementalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(actualIncrementalBackupSizeInMegaBytes()));
        case "BackupProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(backupProgressInMegaBytes()));
        case "CurrentBackupRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentBackupRateInMegaBytesPerSecond()));
        case "EstimatedSecondsToCompletion":
            return Optional.ofNullable(clazz.cast(estimatedSecondsToCompletion()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RestorableNodeTypes":
            return Optional.ofNullable(clazz.cast(restorableNodeTypes()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "ManualSnapshotRemainingDays":
            return Optional.ofNullable(clazz.cast(manualSnapshotRemainingDays()));
        case "SnapshotRetentionStartTime":
            return Optional.ofNullable(clazz.cast(snapshotRetentionStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * The snapshot identifier that is provided in the request.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The snapshot identifier that is provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The identifier of the cluster for which the snapshot was taken.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster for which the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster
         * data as of this exact time.
         * </p>
         * 
         * @param snapshotCreateTime
         *        The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the
         *        cluster data as of this exact time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(Instant snapshotCreateTime);

        /**
         * <p>
         * The snapshot status. The value of the status depends on the API operation used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or "failed".
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>DeleteClusterSnapshot</a> returns status as "deleted".
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The snapshot status. The value of the status depends on the API operation used: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> returns status as "creating".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>DescribeClusterSnapshots</a> returns status as "creating", "available", "final snapshot", or
         *        "failed".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>DeleteClusterSnapshot</a> returns status as "deleted".
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port that the cluster is listening on.
         * </p>
         * 
         * @param port
         *        The port that the cluster is listening on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The Availability Zone in which the cluster was created.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The time (UTC) when the cluster was originally created.
         * </p>
         * 
         * @param clusterCreateTime
         *        The time (UTC) when the cluster was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(Instant clusterCreateTime);

        /**
         * <p>
         * The master user name for the cluster.
         * </p>
         * 
         * @param masterUsername
         *        The master user name for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The version ID of the Amazon Redshift engine that is running on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a> are of
         * type "manual".
         * </p>
         * 
         * @param snapshotType
         *        The snapshot type. Snapshots created using <a>CreateClusterSnapshot</a> and <a>CopyClusterSnapshot</a>
         *        are of type "manual".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The node type of the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type of the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The number of nodes in the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The name of the database that was created when the cluster was created.
         * </p>
         * 
         * @param dbName
         *        The name of the database that was created when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in
         * the output.
         * </p>
         * 
         * @param vpcId
         *        The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is
         *        not in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * If <code>true</code>, the data in the snapshot is encrypted at rest.
         * </p>
         * 
         * @param encrypted
         *        If <code>true</code>, the data in the snapshot is encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The AWS Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the
         * cluster from which the snapshot was taken.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the
         *        cluster from which the snapshot was taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster.
         * <code>true</code> indicates that the data is encrypted using HSM keys.
         * </p>
         * 
         * @param encryptedWithHSM
         *        A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source
         *        cluster. <code>true</code> indicates that the data is encrypted using HSM keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedWithHSM(Boolean encryptedWithHSM);

        /**
         * <p>
         * A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no
         * accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if
         *        no accounts are authorized. Visible only to the snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess);

        /**
         * <p>
         * A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no
         * accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if
         *        no accounts are authorized. Visible only to the snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(AccountWithRestoreAccess... accountsWithRestoreAccess);

        /**
         * <p>
         * A list of the AWS customer accounts authorized to restore the snapshot. Returns <code>null</code> if no
         * accounts are authorized. Visible only to the snapshot owner.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountWithRestoreAccess>.Builder} avoiding
         * the need to create one manually via {@link List<AccountWithRestoreAccess>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountWithRestoreAccess>.Builder#build()} is called
         * immediately and its result is passed to {@link #accountsWithRestoreAccess(List<AccountWithRestoreAccess>)}.
         * 
         * @param accountsWithRestoreAccess
         *        a consumer that will call methods on {@link List<AccountWithRestoreAccess>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountsWithRestoreAccess(List<AccountWithRestoreAccess>)
         */
        Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder>... accountsWithRestoreAccess);

        /**
         * <p>
         * For manual snapshots, the AWS customer account used to create or copy the snapshot. For automatic snapshots,
         * the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        For manual snapshots, the AWS customer account used to create or copy the snapshot. For automatic
         *        snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a
         *        manual snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The size of the complete set of backup data that would be used to restore the cluster.
         * </p>
         * 
         * @param totalBackupSizeInMegaBytes
         *        The size of the complete set of backup data that would be used to restore the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes);

        /**
         * <p>
         * The size of the incremental backup.
         * </p>
         * 
         * @param actualIncrementalBackupSizeInMegaBytes
         *        The size of the incremental backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes);

        /**
         * <p>
         * The number of megabytes that have been transferred to the snapshot backup.
         * </p>
         * 
         * @param backupProgressInMegaBytes
         *        The number of megabytes that have been transferred to the snapshot backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes);

        /**
         * <p>
         * The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a
         * completed backup.
         * </p>
         * 
         * @param currentBackupRateInMegaBytesPerSecond
         *        The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code>
         *        for a completed backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond);

        /**
         * <p>
         * The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a
         * completed backup.
         * </p>
         * 
         * @param estimatedSecondsToCompletion
         *        The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code>
         *        for a completed backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion);

        /**
         * <p>
         * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed
         * backup to finish.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of time an in-progress snapshot backup has been running, or the amount of time it took a
         *        completed backup to finish.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The source region from which the snapshot was copied.
         * </p>
         * 
         * @param sourceRegion
         *        The source region from which the snapshot was copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The list of node types that this cluster snapshot is able to restore into.
         * </p>
         * 
         * @param restorableNodeTypes
         *        The list of node types that this cluster snapshot is able to restore into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableNodeTypes(Collection<String> restorableNodeTypes);

        /**
         * <p>
         * The list of node types that this cluster snapshot is able to restore into.
         * </p>
         * 
         * @param restorableNodeTypes
         *        The list of node types that this cluster snapshot is able to restore into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorableNodeTypes(String... restorableNodeTypes);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The name of the maintenance track for the snapshot.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained
         * indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is
         *        retained indefinitely. </p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The number of days until a manual snapshot will pass its retention period.
         * </p>
         * 
         * @param manualSnapshotRemainingDays
         *        The number of days until a manual snapshot will pass its retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRemainingDays(Integer manualSnapshotRemainingDays);

        /**
         * <p>
         * A timestamp representing the start of the retention period for the snapshot.
         * </p>
         * 
         * @param snapshotRetentionStartTime
         *        A timestamp representing the start of the retention period for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String clusterIdentifier;

        private Instant snapshotCreateTime;

        private String status;

        private Integer port;

        private String availabilityZone;

        private Instant clusterCreateTime;

        private String masterUsername;

        private String clusterVersion;

        private String snapshotType;

        private String nodeType;

        private Integer numberOfNodes;

        private String dbName;

        private String vpcId;

        private Boolean encrypted;

        private String kmsKeyId;

        private Boolean encryptedWithHSM;

        private List<AccountWithRestoreAccess> accountsWithRestoreAccess = DefaultSdkAutoConstructList.getInstance();

        private String ownerAccount;

        private Double totalBackupSizeInMegaBytes;

        private Double actualIncrementalBackupSizeInMegaBytes;

        private Double backupProgressInMegaBytes;

        private Double currentBackupRateInMegaBytesPerSecond;

        private Long estimatedSecondsToCompletion;

        private Long elapsedTimeInSeconds;

        private String sourceRegion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<String> restorableNodeTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean enhancedVpcRouting;

        private String maintenanceTrackName;

        private Integer manualSnapshotRetentionPeriod;

        private Integer manualSnapshotRemainingDays;

        private Instant snapshotRetentionStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            snapshotIdentifier(model.snapshotIdentifier);
            clusterIdentifier(model.clusterIdentifier);
            snapshotCreateTime(model.snapshotCreateTime);
            status(model.status);
            port(model.port);
            availabilityZone(model.availabilityZone);
            clusterCreateTime(model.clusterCreateTime);
            masterUsername(model.masterUsername);
            clusterVersion(model.clusterVersion);
            snapshotType(model.snapshotType);
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            dbName(model.dbName);
            vpcId(model.vpcId);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            encryptedWithHSM(model.encryptedWithHSM);
            accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            ownerAccount(model.ownerAccount);
            totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            sourceRegion(model.sourceRegion);
            tags(model.tags);
            restorableNodeTypes(model.restorableNodeTypes);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maintenanceTrackName(model.maintenanceTrackName);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            manualSnapshotRemainingDays(model.manualSnapshotRemainingDays);
            snapshotRetentionStartTime(model.snapshotRetentionStartTime);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getClusterCreateTime() {
            return clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getDBName() {
            return dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEncryptedWithHSM() {
            return encryptedWithHSM;
        }

        @Override
        public final Builder encryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
            return this;
        }

        public final void setEncryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
        }

        public final Collection<AccountWithRestoreAccess.Builder> getAccountsWithRestoreAccess() {
            return accountsWithRestoreAccess != null ? accountsWithRestoreAccess.stream()
                    .map(AccountWithRestoreAccess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(AccountWithRestoreAccess... accountsWithRestoreAccess) {
            accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder>... accountsWithRestoreAccess) {
            accountsWithRestoreAccess(Stream.of(accountsWithRestoreAccess)
                    .map(c -> AccountWithRestoreAccess.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess.BuilderImpl> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copyFromBuilder(accountsWithRestoreAccess);
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        public final Double getBackupProgressInMegaBytes() {
            return backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getRestorableNodeTypes() {
            return restorableNodeTypes;
        }

        @Override
        public final Builder restorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableNodeTypes(String... restorableNodeTypes) {
            restorableNodeTypes(Arrays.asList(restorableNodeTypes));
            return this;
        }

        public final void setRestorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final Integer getManualSnapshotRemainingDays() {
            return manualSnapshotRemainingDays;
        }

        @Override
        public final Builder manualSnapshotRemainingDays(Integer manualSnapshotRemainingDays) {
            this.manualSnapshotRemainingDays = manualSnapshotRemainingDays;
            return this;
        }

        public final void setManualSnapshotRemainingDays(Integer manualSnapshotRemainingDays) {
            this.manualSnapshotRemainingDays = manualSnapshotRemainingDays;
        }

        public final Instant getSnapshotRetentionStartTime() {
            return snapshotRetentionStartTime;
        }

        @Override
        public final Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
            return this;
        }

        public final void setSnapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
