/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeClusterSecurityGroupIngressResponse extends RedshiftResponse implements
        ToCopyableBuilder<RevokeClusterSecurityGroupIngressResponse.Builder, RevokeClusterSecurityGroupIngressResponse> {
    private static final SdkField<ClusterSecurityGroup> CLUSTER_SECURITY_GROUP_FIELD = SdkField
            .<ClusterSecurityGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(RevokeClusterSecurityGroupIngressResponse::clusterSecurityGroup))
            .setter(setter(Builder::clusterSecurityGroup)).constructor(ClusterSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SECURITY_GROUP_FIELD));

    private final ClusterSecurityGroup clusterSecurityGroup;

    private RevokeClusterSecurityGroupIngressResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSecurityGroup = builder.clusterSecurityGroup;
    }

    /**
     * Returns the value of the ClusterSecurityGroup property for this object.
     * 
     * @return The value of the ClusterSecurityGroup property for this object.
     */
    public ClusterSecurityGroup clusterSecurityGroup() {
        return clusterSecurityGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeClusterSecurityGroupIngressResponse)) {
            return false;
        }
        RevokeClusterSecurityGroupIngressResponse other = (RevokeClusterSecurityGroupIngressResponse) obj;
        return Objects.equals(clusterSecurityGroup(), other.clusterSecurityGroup());
    }

    @Override
    public String toString() {
        return ToString.builder("RevokeClusterSecurityGroupIngressResponse").add("ClusterSecurityGroup", clusterSecurityGroup())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSecurityGroup":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevokeClusterSecurityGroupIngressResponse, T> g) {
        return obj -> g.apply((RevokeClusterSecurityGroupIngressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokeClusterSecurityGroupIngressResponse> {
        /**
         * Sets the value of the ClusterSecurityGroup property for this object.
         *
         * @param clusterSecurityGroup
         *        The new value for the ClusterSecurityGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroup(ClusterSecurityGroup clusterSecurityGroup);

        /**
         * Sets the value of the ClusterSecurityGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link ClusterSecurityGroup.Builder} avoiding the need
         * to create one manually via {@link ClusterSecurityGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterSecurityGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #clusterSecurityGroup(ClusterSecurityGroup)}.
         * 
         * @param clusterSecurityGroup
         *        a consumer that will call methods on {@link ClusterSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSecurityGroup(ClusterSecurityGroup)
         */
        default Builder clusterSecurityGroup(Consumer<ClusterSecurityGroup.Builder> clusterSecurityGroup) {
            return clusterSecurityGroup(ClusterSecurityGroup.builder().applyMutation(clusterSecurityGroup).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private ClusterSecurityGroup clusterSecurityGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeClusterSecurityGroupIngressResponse model) {
            super(model);
            clusterSecurityGroup(model.clusterSecurityGroup);
        }

        public final ClusterSecurityGroup.Builder getClusterSecurityGroup() {
            return clusterSecurityGroup != null ? clusterSecurityGroup.toBuilder() : null;
        }

        @Override
        public final Builder clusterSecurityGroup(ClusterSecurityGroup clusterSecurityGroup) {
            this.clusterSecurityGroup = clusterSecurityGroup;
            return this;
        }

        public final void setClusterSecurityGroup(ClusterSecurityGroup.BuilderImpl clusterSecurityGroup) {
            this.clusterSecurityGroup = clusterSecurityGroup != null ? clusterSecurityGroup.build() : null;
        }

        @Override
        public RevokeClusterSecurityGroupIngressResponse build() {
            return new RevokeClusterSecurityGroupIngressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
