/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module
 * (HSM), and used by the Amazon Redshift cluster to encrypt data files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HsmClientCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<HsmClientCertificate.Builder, HsmClientCertificate> {
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HsmClientCertificate::hsmClientCertificateIdentifier))
            .setter(setter(Builder::hsmClientCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_PUBLIC_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(HsmClientCertificate::hsmClientCertificatePublicKey))
            .setter(setter(Builder::hsmClientCertificatePublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificatePublicKey")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(HsmClientCertificate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CLIENT_CERTIFICATE_PUBLIC_KEY_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hsmClientCertificateIdentifier;

    private final String hsmClientCertificatePublicKey;

    private final List<Tag> tags;

    private HsmClientCertificate(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmClientCertificatePublicKey = builder.hsmClientCertificatePublicKey;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the HSM client certificate.
     * </p>
     * 
     * @return The identifier of the HSM client certificate.
     */
    public String hsmClientCertificateIdentifier() {
        return hsmClientCertificateIdentifier;
    }

    /**
     * <p>
     * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key
     * in the HSM.
     * </p>
     * 
     * @return The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the
     *         public key in the HSM.
     */
    public String hsmClientCertificatePublicKey() {
        return hsmClientCertificatePublicKey;
    }

    /**
     * <p>
     * The list of tags for the HSM client certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags for the HSM client certificate.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificatePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmClientCertificate)) {
            return false;
        }
        HsmClientCertificate other = (HsmClientCertificate) obj;
        return Objects.equals(hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier())
                && Objects.equals(hsmClientCertificatePublicKey(), other.hsmClientCertificatePublicKey())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("HsmClientCertificate").add("HsmClientCertificateIdentifier", hsmClientCertificateIdentifier())
                .add("HsmClientCertificatePublicKey", hsmClientCertificatePublicKey()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmClientCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(hsmClientCertificateIdentifier()));
        case "HsmClientCertificatePublicKey":
            return Optional.ofNullable(clazz.cast(hsmClientCertificatePublicKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HsmClientCertificate, T> g) {
        return obj -> g.apply((HsmClientCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HsmClientCertificate> {
        /**
         * <p>
         * The identifier of the HSM client certificate.
         * </p>
         * 
         * @param hsmClientCertificateIdentifier
         *        The identifier of the HSM client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier);

        /**
         * <p>
         * The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public
         * key in the HSM.
         * </p>
         * 
         * @param hsmClientCertificatePublicKey
         *        The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the
         *        public key in the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificatePublicKey(String hsmClientCertificatePublicKey);

        /**
         * <p>
         * The list of tags for the HSM client certificate.
         * </p>
         * 
         * @param tags
         *        The list of tags for the HSM client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the HSM client certificate.
         * </p>
         * 
         * @param tags
         *        The list of tags for the HSM client certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the HSM client certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String hsmClientCertificateIdentifier;

        private String hsmClientCertificatePublicKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HsmClientCertificate model) {
            hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            hsmClientCertificatePublicKey(model.hsmClientCertificatePublicKey);
            tags(model.tags);
        }

        public final String getHsmClientCertificateIdentifier() {
            return hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmClientCertificatePublicKey() {
            return hsmClientCertificatePublicKey;
        }

        @Override
        public final Builder hsmClientCertificatePublicKey(String hsmClientCertificatePublicKey) {
            this.hsmClientCertificatePublicKey = hsmClientCertificatePublicKey;
            return this;
        }

        public final void setHsmClientCertificatePublicKey(String hsmClientCertificatePublicKey) {
            this.hsmClientCertificatePublicKey = hsmClientCertificatePublicKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public HsmClientCertificate build() {
            return new HsmClientCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
