/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Temporary credentials with authorization to log on to an Amazon Redshift database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterCredentialsResponse extends RedshiftResponse implements
        ToCopyableBuilder<GetClusterCredentialsResponse.Builder, GetClusterCredentialsResponse> {
    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetClusterCredentialsResponse::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetClusterCredentialsResponse::dbPassword)).setter(setter(Builder::dbPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetClusterCredentialsResponse::expiration)).setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_USER_FIELD,
            DB_PASSWORD_FIELD, EXPIRATION_FIELD));

    private final String dbUser;

    private final String dbPassword;

    private final Instant expiration;

    private GetClusterCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.expiration = builder.expiration;
    }

    /**
     * <p>
     * A database user name that is authorized to log on to the database <code>DbName</code> using the password
     * <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database
     * privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code>
     * parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these
     * credentials.
     * </p>
     * 
     * @return A database user name that is authorized to log on to the database <code>DbName</code> using the password
     *         <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same
     *         database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the
     *         <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any
     *         sessions created using these credentials.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database
     * <code>DbName</code>.
     * </p>
     * 
     * @return A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the
     *         database <code>DbName</code>.
     */
    public String dbPassword() {
        return dbPassword;
    }

    /**
     * <p>
     * The date and time the password in <code>DbPassword</code> expires.
     * </p>
     * 
     * @return The date and time the password in <code>DbPassword</code> expires.
     */
    public Instant expiration() {
        return expiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsResponse)) {
            return false;
        }
        GetClusterCredentialsResponse other = (GetClusterCredentialsResponse) obj;
        return Objects.equals(dbUser(), other.dbUser()) && Objects.equals(dbPassword(), other.dbPassword())
                && Objects.equals(expiration(), other.expiration());
    }

    @Override
    public String toString() {
        return ToString.builder("GetClusterCredentialsResponse").add("DbUser", dbUser()).add("DbPassword", dbPassword())
                .add("Expiration", expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.ofNullable(clazz.cast(dbPassword()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsResponse, T> g) {
        return obj -> g.apply((GetClusterCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClusterCredentialsResponse> {
        /**
         * <p>
         * A database user name that is authorized to log on to the database <code>DbName</code> using the password
         * <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same
         * database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the
         * <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any
         * sessions created using these credentials.
         * </p>
         * 
         * @param dbUser
         *        A database user name that is authorized to log on to the database <code>DbName</code> using the
         *        password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name
         *        has the same database privileges as the the user named in DbUser. By default, the user is added to
         *        PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed
         *        groups for any sessions created using these credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database
         * <code>DbName</code>.
         * </p>
         * 
         * @param dbPassword
         *        A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the
         *        database <code>DbName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        /**
         * <p>
         * The date and time the password in <code>DbPassword</code> expires.
         * </p>
         * 
         * @param expiration
         *        The date and time the password in <code>DbPassword</code> expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String dbUser;

        private String dbPassword;

        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsResponse model) {
            super(model);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
            expiration(model.expiration);
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public GetClusterCredentialsResponse build() {
            return new GetClusterCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
