/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableLoggingRequest extends RedshiftRequest implements
        ToCopyableBuilder<EnableLoggingRequest.Builder, EnableLoggingRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnableLoggingRequest::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD));

    private final String clusterIdentifier;

    private final String bucketName;

    private final String s3KeyPrefix;

    private EnableLoggingRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    /**
     * <p>
     * The identifier of the cluster on which logging is to be started.
     * </p>
     * <p>
     * Example: <code>examplecluster</code>
     * </p>
     * 
     * @return The identifier of the cluster on which logging is to be started.</p>
     *         <p>
     *         Example: <code>examplecluster</code>
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of an existing S3 bucket where the log files are to be stored.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the same region as the cluster
     * </p>
     * </li>
     * <li>
     * <p>
     * The cluster must have read bucket and put object permissions
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of an existing S3 bucket where the log files are to be stored.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the same region as the cluster
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The cluster must have read bucket and put object permissions
     *         </p>
     *         </li>
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix applied to the log file names.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cannot exceed 512 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The
     * hexadecimal codes for invalid characters are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * x00 to x20
     * </p>
     * </li>
     * <li>
     * <p>
     * x22
     * </p>
     * </li>
     * <li>
     * <p>
     * x27
     * </p>
     * </li>
     * <li>
     * <p>
     * x5c
     * </p>
     * </li>
     * <li>
     * <p>
     * x7f or larger
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The prefix applied to the log file names.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cannot exceed 512 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters.
     *         The hexadecimal codes for invalid characters are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         x00 to x20
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x22
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x27
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x5c
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x7f or larger
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingRequest)) {
            return false;
        }
        EnableLoggingRequest other = (EnableLoggingRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix());
    }

    @Override
    public String toString() {
        return ToString.builder("EnableLoggingRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("BucketName", bucketName()).add("S3KeyPrefix", s3KeyPrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableLoggingRequest, T> g) {
        return obj -> g.apply((EnableLoggingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableLoggingRequest> {
        /**
         * <p>
         * The identifier of the cluster on which logging is to be started.
         * </p>
         * <p>
         * Example: <code>examplecluster</code>
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the cluster on which logging is to be started.</p>
         *        <p>
         *        Example: <code>examplecluster</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of an existing S3 bucket where the log files are to be stored.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the same region as the cluster
         * </p>
         * </li>
         * <li>
         * <p>
         * The cluster must have read bucket and put object permissions
         * </p>
         * </li>
         * </ul>
         * 
         * @param bucketName
         *        The name of an existing S3 bucket where the log files are to be stored.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the same region as the cluster
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The cluster must have read bucket and put object permissions
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix applied to the log file names.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cannot exceed 512 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The
         * hexadecimal codes for invalid characters are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * x00 to x20
         * </p>
         * </li>
         * <li>
         * <p>
         * x22
         * </p>
         * </li>
         * <li>
         * <p>
         * x27
         * </p>
         * </li>
         * <li>
         * <p>
         * x5c
         * </p>
         * </li>
         * <li>
         * <p>
         * x7f or larger
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param s3KeyPrefix
         *        The prefix applied to the log file names.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cannot exceed 512 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control
         *        characters. The hexadecimal codes for invalid characters are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        x00 to x20
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x22
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x27
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x5c
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x7f or larger
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String bucketName;

        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableLoggingRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            bucketName(model.bucketName);
            s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableLoggingRequest build() {
            return new EnableLoggingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
